/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InsetsPanel
extends JPanel {
    public static final String PROP_NAME = "Insets";
    protected JSpinner[] sideSpinners = new JSpinner[4];
    protected JLabel[] sideLabels = new JLabel[]{new JLabel("Top:"), new JLabel("Left:"), new JLabel("Bottom:"), new JLabel("Right:")};

    public InsetsPanel(int n) {
        super(new GridBagLayout());
        this.setBackground(null);
        for (int i = 0; i < 4; ++i) {
            this.sideSpinners[i] = new JSpinner(new SpinnerNumberModel(0, -99, 99, 1));
            int n2 = n == 0 ? 20 : 0;
            int n3 = n == 0 ? i * 2 : 0;
            int n4 = n == 0 ? 0 : i;
            this.add((Component)this.sideLabels[i], new GridBagConstraints(n3, n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, n2, 0, 0), 0, 0));
            this.add((Component)this.sideSpinners[i], new GridBagConstraints(n3 + 1, n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.sideSpinners[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    InsetsPanel.this.firePropertyChange(InsetsPanel.PROP_NAME, null, null);
                }
            });
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < 4; ++i) {
            this.sideSpinners[i].setEnabled(bl);
            this.sideLabels[i].setEnabled(bl);
        }
    }

    public void setInsetsValue(Insets insets) {
        this.sideSpinners[0].setValue(new Integer(insets.top));
        this.sideSpinners[1].setValue(new Integer(insets.left));
        this.sideSpinners[2].setValue(new Integer(insets.bottom));
        this.sideSpinners[3].setValue(new Integer(insets.right));
    }

    public Insets getInsetsValue() {
        int n = (Integer)this.sideSpinners[0].getValue();
        int n2 = (Integer)this.sideSpinners[1].getValue();
        int n3 = (Integer)this.sideSpinners[2].getValue();
        int n4 = (Integer)this.sideSpinners[3].getValue();
        return new Insets(n, n2, n3, n4);
    }
}

