/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.panels;

import com.miginfocom.themeeditor.PaintChooseDialog;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.border.LineBorder;

public class PaintPanel
extends JComponent {
    public static final String PROP_NAME = "Paint";
    LineBorder a = new LineBorder(Color.DARK_GRAY);
    LineBorder b = new LineBorder(Color.GRAY);
    protected Paint paint;
    protected boolean drawRGB = false;
    private Dimension c = new Dimension(10, 10);
    private String d = "null";
    private static final AtRefRangeNumber e = new AtFraction(0.5f);
    private static final Font f = new Font("sansserif", 1, 12);
    private static final Color g = new Color(150, 150, 255);

    public PaintPanel(boolean bl) {
        this(bl, null);
    }

    public PaintPanel(boolean bl, Paint paint) {
        if (paint != null) {
            this.setPaint(paint);
        }
        this.setBorder(this.a);
        if (bl) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (PaintPanel.this.isEnabled()) {
                        PaintChooseDialog paintChooseDialog = new PaintChooseDialog(PaintPanel.this.getPaint(), JOptionPane.getFrameForComponent(PaintPanel.this), true);
                        paintChooseDialog.setVisible(true);
                        if (paintChooseDialog.isOkPressed()) {
                            Paint paint = paintChooseDialog.getSelectedPaint();
                            PaintPanel.this.setPaint(paint);
                            PaintPanel.this.firePropertyChange(PaintPanel.PROP_NAME, null, null);
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            });
        }
    }

    public void setPaint(Paint paint) {
        if (this.paint != paint) {
            this.paint = paint;
            this.repaint();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setBorder(bl ? this.a : this.b);
    }

    public void setDrawRGB(boolean bl) {
        this.drawRGB = bl;
    }

    public Dimension getBackdropSquareSize() {
        return this.c;
    }

    public void setBackdropSquareSize(Dimension dimension) {
        this.c = dimension;
    }

    public String getNullString() {
        return this.d;
    }

    public void setNullString(String string) {
        this.d = string;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.isEnabled()) {
            if (this.paint != null) {
                if (this.paint.getTransparency() != 1) {
                    if (this.c != null) {
                        graphics2D.setColor(Color.WHITE);
                        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                        graphics2D.setColor(Color.BLACK);
                        for (int i = 0; i < this.getWidth(); i += this.c.width << 1) {
                            for (int j = 0; j < this.getHeight(); j += this.c.height) {
                                graphics2D.fillRect(i + (j % (this.c.height << 1) != 0 ? this.c.width : 0), j, this.c.width, this.c.height);
                            }
                        }
                    } else {
                        graphics2D.setColor(this.getBackground());
                        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                }
                graphics2D.setPaint(this.paint);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.drawRGB && this.paint instanceof Color) {
                    Color color = (Color)this.paint;
                    if (color.getAlpha() < 100) {
                        graphics2D.setColor(g);
                    } else {
                        graphics2D.setColor(color.getRed() + color.getGreen() + color.getBlue() < 255 ? Color.WHITE : Color.BLACK);
                    }
                    graphics2D.setFont(f);
                    graphics2D.drawString("R: " + color.getRed() + ", G: " + color.getGreen() + ", B: " + color.getBlue() + ", A: " + color.getAlpha(), 3, this.getHeight() - 2);
                }
            } else {
                graphics2D.setColor(Color.BLACK);
                GfxUtil.drawStringInRect(graphics2D, this.d, new Rectangle(0, 0, this.getWidth(), this.getHeight()), e, e, 0, true, 9);
            }
        } else {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.isEnabled() ? Color.BLACK : Color.GRAY);
            graphics2D.drawLine(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            graphics2D.drawLine(1, this.getHeight() - 2, this.getWidth() - 2, 1);
        }
        graphics2D.dispose();
    }
}

