/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.themeeditor.panels;

import com.miginfocom.themeeditor.DividerBorder;
import com.miginfocom.themeeditor.EditorUtil;
import com.miginfocom.themeeditor.panels.ImagePanel;
import com.miginfocom.themeeditor.panels.TransparencyPanel;
import com.miginfocom.util.Base64;
import com.miginfocom.util.NameValuePair;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.XtdImage;
import com.miginfocom.util.io.IOUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class XtdImagePanel
extends JPanel {
    public static final String PROP_NAME = "XtdImage";
    final NameValuePair[] a = new NameValuePair[]{new NameValuePair<Object>("Default (unset)", null), new NameValuePair<Integer>("Nearest Neighbor", new Integer(0)), new NameValuePair<Integer>("Bilinear", new Integer(1)), new NameValuePair<Integer>("Bicubic", new Integer(2))};
    private final JPanel b = new JPanel(new BorderLayout(0, 5));
    private final JCheckBox c = new JCheckBox("Draw black and white squares in the background to show transparency", true);
    private final ImagePanel d = new ImagePanel();
    private final JPanel e = new JPanel(new GridBagLayout());
    private final JLabel f = new JLabel("Comma separated Filenames, Resources, URLs and/or a BASE64 encoded image.");
    private final JTextArea g = new JTextArea(3, 80);
    private final JButton h = new JButton("Add Filename...");
    private final JButton i = new JButton("Add as BASE64...");
    private final JButton j = new JButton("Apply / Test...");
    private final JLabel k = new JLabel("Transparency:");
    private final TransparencyPanel l = new TransparencyPanel();
    private final JLabel m = new JLabel("Scale Quality:");
    private final JComboBox n = new JComboBox<NameValuePair>(this.a);
    private final JLabel o = new JLabel("Cache Scaled Images:");
    private final JSpinner p = new JSpinner(new SpinnerNumberModel(1, 0, 1000, 1));
    private boolean q = true;

    public XtdImagePanel() {
        super(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.g);
        this.g.setFont(new Font("monospaced", 0, 11));
        this.g.setBackground(null);
        this.d.setMinimumSize(new Dimension(100, 100));
        this.d.setPreferredSize(new Dimension(100, 100));
        this.e.setBorder(new DividerBorder("Image Properties", 5));
        this.setBackground(null);
        this.f.setBackground(null);
        this.e.setBackground(null);
        this.b.setBackground(null);
        this.l.setBackground(null);
        this.c.setBackground(null);
        this.d.setImage(new XtdImage("", 1));
        this.e.add((Component)this.f, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 17, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.e.add((Component)jScrollPane, new GridBagConstraints(0, 1, 4, 2, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.e.add((Component)this.h, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.e.add((Component)this.i, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.e.add((Component)this.o, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 5, 0, 0), 0, 0));
        this.e.add((Component)this.p, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 5, 0, 0), 0, 0));
        this.e.add((Component)this.m, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.e.add((Component)this.n, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.e.add((Component)this.k, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.e.add((Component)this.l, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.e.add((Component)this.j, new GridBagConstraints(4, 5, 1, 1, 0.0, 1.0, 16, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.b.setBorder(new DividerBorder("Image Preview", 0));
        this.b.add((Component)this.d, "Center");
        this.b.add((Component)this.c, "South");
        this.add((Component)this.e, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.b, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.d.setBorder(new MatteBorder(1, 1, 1, 1, Color.GRAY));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                String string = EditorUtil.getPreference("xtdpanelpath", (String)null);
                if (string != null) {
                    jFileChooser.setCurrentDirectory(new File(string));
                }
                if (jFileChooser.showOpenDialog(XtdImagePanel.this) != 0) {
                    return;
                }
                string = jFileChooser.getSelectedFile().getAbsolutePath();
                EditorUtil.setPreference("xtdpanelpath", string);
                if (!jFileChooser.getSelectedFile().exists()) {
                    JOptionPane.showMessageDialog(XtdImagePanel.this, "File not found!", "File not found!", 0);
                    return;
                }
                XtdImagePanel.this.a();
                if (actionEvent.getSource() == XtdImagePanel.this.h) {
                    XtdImagePanel.this.g.append(jFileChooser.getSelectedFile().getAbsolutePath());
                } else {
                    try {
                        byte[] byArray = IOUtil.readByteArray(jFileChooser.getSelectedFile());
                        XtdImagePanel.this.g.append(Base64.encodeToString(byArray, true));
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(XtdImagePanel.this, iOException.toString(), iOException.getLocalizedMessage(), 0);
                    }
                }
                XtdImagePanel.this.setDirty(true);
            }
        };
        this.p.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                XtdImagePanel.this.setDirty(true);
            }
        });
        this.n.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                XtdImagePanel.this.setDirty(true);
            }
        });
        this.h.addActionListener(actionListener);
        this.i.addActionListener(actionListener);
        this.c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                XtdImagePanel.this.d.setBackdropSquareSize(XtdImagePanel.this.c.isSelected() ? new Integer(10) : null);
                XtdImagePanel.this.repaint();
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XtdImagePanel.this.setDirty(true);
                XtdImagePanel.this.firePropertyChange(XtdImagePanel.PROP_NAME, null, null);
                XtdImage xtdImage = (XtdImage)XtdImagePanel.this.d.getImage();
                StringBuffer stringBuffer = xtdImage.getImageLoadReport();
                String string = null;
                if (stringBuffer != null) {
                    string = "Image Loading Report:\n\n" + stringBuffer;
                } else if (xtdImage == null || xtdImage.getBufferedImage() == null) {
                    string = "Image not found!";
                }
                if (string != null) {
                    JOptionPane.showMessageDialog(XtdImagePanel.this, string);
                }
            }
        });
        this.l.addPropertyChangeListener("Transparency", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                XtdImagePanel.this.setDirty(true);
            }
        });
        this.g.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                XtdImagePanel.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                XtdImagePanel.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                XtdImagePanel.this.setDirty(true);
            }
        });
        this.addPropertyChangeListener(PROP_NAME, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                XtdImagePanel.this.d.setImage(XtdImagePanel.this.getXtdImage());
                XtdImagePanel.this.getSelectedTransparency();
            }
        });
        this.setDirty(false);
    }

    private void a() {
        String string = this.g.getText();
        String string2 = string.trim();
        if (string2.length() == 0) {
            return;
        }
        if (string2.charAt(string2.length() - 1) != ',') {
            this.g.setText(string2 + ",\n");
        } else {
            this.g.setText(string2 + "\n");
        }
    }

    public Integer getSelectedTransparency() {
        Integer n = this.l.getTransparecyValue();
        this.l.setUsedTransparencyLabel(n != null ? n : GfxUtil.getTransparency(this.d.getImage()));
        return n;
    }

    protected void setDirty(boolean bl) {
        this.j.setEnabled(bl);
        this.q = bl;
    }

    protected boolean isDirty() {
        return this.q;
    }

    public XtdImage getXtdImage() {
        if (this.isDirty()) {
            String string = this.g.getText();
            int n = (Integer)this.p.getValue();
            Integer n2 = (Integer)((NameValuePair)this.n.getSelectedItem()).getValue();
            this.d.setImage(new XtdImage(string, n, this.getSelectedTransparency(), n2));
            this.setDirty(false);
        }
        return (XtdImage)this.d.getImage();
    }

    public void setXtdImage(XtdImage xtdImage) {
        this.g.setText(xtdImage.getImageContext());
        NameValuePair.selectComboBoxItem(this.n, xtdImage.getScaleQuality());
        this.p.setValue(new Integer(xtdImage.getCacheScaledImages()));
        this.getSelectedTransparency();
        this.d.setImage(xtdImage);
    }
}

