/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util;

import com.miginfocom.util.io.IOUtil;
import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;
import com.smardec.license4j.LicenseNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public final class LicenseValidator {
    public static final String MC = "C";
    public static final String DBC = "D";
    public static final String DBG = "G";
    private static final HashMap<String, License> a;
    private static final HashMap<String, Boolean> b;

    public static String getComponentVersion() {
        return "6.9.3";
    }

    public static int getComponentVersionInt() {
        return 693;
    }

    public static void setLicenseKey(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalAccessError("Invalid license key: " + string);
        }
        LicenseValidator.a(string.trim().getBytes());
    }

    public static void setLicenseKey(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            LicenseValidator.setLicenseKey(fileInputStream);
        }
        catch (Exception exception) {
            throw new IllegalAccessError("License File Not Found!");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setLicenseKey(InputStream inputStream) {
        try {
            LicenseValidator.a(IOUtil.toByteArray(inputStream));
        }
        catch (IOException iOException) {
            throw new IllegalAccessError("License File Not Found!");
        }
    }

    private static void a(byte[] byArray) {
        if (Character.isWhitespace((char)byArray[0]) || Character.isWhitespace((char)byArray[byArray.length - 1])) {
            byArray = new String(byArray).trim().getBytes();
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by != 39 && by != 59) continue;
            byArray[i] = 10;
        }
        try {
            String string;
            if (byArray[15] == 49 && byArray[16] == 49 && byArray[17] == 51 && byArray[18] == 52 && (string = new String(byArray)).hashCode() == -388081317 && string.substring(1).hashCode() == -1240324392) {
                b.put(MC, Boolean.TRUE);
            }
            if (byArray[15] == 49 && byArray[16] == 49 && byArray[17] == 54 && byArray[18] == 48) {
                throw new IllegalAccessError("License Key Expired! Contact MiG InfoCom Support.");
            }
            License license = LicenseManager.loadLicense(new ByteArrayInputStream(byArray));
            String string2 = license.getFeatureAsString("Pd");
            if (string2 == null) {
                string2 = MC;
            }
            if (string2.equals(MC)) {
                String string3 = license.getFeatureAsString("V");
                if (LicenseValidator.getComponentVersionInt() >= 600) {
                    int n;
                    int n2 = n = string3 != null && string3.trim().length() > 0 ? Integer.parseInt(string3) : 5;
                    if (n * 100 + 99 < LicenseValidator.getComponentVersionInt()) {
                        throw new IllegalAccessError("The license you have is only up until version " + n + " of the component. Please visit www.migcalendar.com for an upgrade.");
                    }
                }
            }
            a.put(string2, license);
            b.remove(string2);
            LicenseValidator.isLicenseValid(string2);
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
            throw new IllegalAccessError("License File Not Found!");
        }
    }

    public static String getProperty(String string, String string2, String string3) {
        License license = a.get(string);
        String string4 = license != null ? license.getFeatureAsString(string2) : null;
        return string4 != null ? string4 : string3;
    }

    public static boolean isDemo(String string) {
        return LicenseValidator.getProperty(string, "Dm", "false").equals("true");
    }

    public static boolean isLicenseValid(String string) {
        Boolean bl = b.get(string);
        if (bl == null) {
            try {
                bl = Boolean.FALSE;
                License license = a.get(string);
                if (license != null) {
                    if (!LicenseManager.isValid(license)) {
                        throw new IllegalAccessError("License Code Invalid!");
                    }
                    long l = Long.parseLong(license.getFeatureAsString("Ex"));
                    if (l == 0L || System.currentTimeMillis() < l) {
                        bl = Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalAccessError("License Code Invalid due to Exception:\n" + exception.getMessage());
            }
            b.put(string, bl);
        }
        return bl;
    }

    static {
        LicenseManager.setPublicKey("308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A03818400028180480DB6DDE003363CDF09B93DD69F0155E257A366B64349B63AADA7A8E67AFA0BA119345140BCB87267F41A5C54BBECDB7B7D46DF35E66B7B14AEDE5EFE573097BA3DD0216919E808B23BBC4B84649674A0188CF3C94E91212AFFAC11B28E0987E992DD23A03BF3C2A1535F462B9937F03AE6BB22EC9746C89C7B94789DAF2908");
        a = new HashMap();
        b = new HashMap();
    }
}

