/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util;

import com.miginfocom.ashape.interaction.InteractionEvent;
import com.miginfocom.ashape.interaction.InteractionListener;
import com.miginfocom.ashape.interaction.MouseInteractionEvent;
import com.miginfocom.ashape.interaction.MouseInteractionListener;
import com.miginfocom.calendar.category.CategoryStructureEvent;
import com.miginfocom.calendar.category.CategoryStructureListener;
import com.miginfocom.calendar.datearea.ActivityDragResizeEvent;
import com.miginfocom.calendar.datearea.ActivityDragResizeListener;
import com.miginfocom.calendar.datearea.ActivityMoveEvent;
import com.miginfocom.calendar.datearea.ActivityMoveListener;
import com.miginfocom.util.ExceptionEvent;
import com.miginfocom.util.ExceptionListener;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.SortableListener;
import com.miginfocom.util.dates.DateChangeEvent;
import com.miginfocom.util.dates.DateChangeListener;
import com.miginfocom.util.dates.TimeSpanListEvent;
import com.miginfocom.util.dates.TimeSpanListListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ListenerSet {
    private static final Comparator a = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((SortableListener)object2).getOrder() - ((SortableListener)object).getOrder();
        }
    };
    protected static final a EMPTY_ITERATOR = new a();
    private Object[] b = null;
    private boolean c = false;
    private final Class d;
    private boolean e = false;

    public ListenerSet() {
        this(null);
    }

    public ListenerSet(Class clazz) {
        this.d = clazz;
    }

    public void add(EventListener eventListener, boolean bl) {
        Object object;
        this.assertListenerType(eventListener);
        Object object2 = object = bl ? new WeakReference<EventListener>(eventListener) : eventListener;
        if (this.b == null || this.b.length == 0) {
            this.b = new Object[]{object};
        } else {
            for (int i = 0; i < this.b.length; ++i) {
                Object object3 = this.b[i];
                if (object3 instanceof WeakReference) {
                    object3 = ((WeakReference)object3).get();
                }
                if (object3 != eventListener) continue;
                return;
            }
            this.b = MigUtil.addToArray(this.b, object, 0x3FFFFFF5);
            if (eventListener instanceof SortableListener) {
                this.e = true;
            } else if (this.e) {
                throw new IllegalArgumentException("All or no listeners must implement SortableListener");
            }
            if (this.e) {
                MigUtil.sort(this.b, a);
            }
        }
    }

    public void remove(EventListener eventListener) {
        int n = this.findListener(eventListener);
        if (n != -1) {
            this.b = MigUtil.removeFromArray(this.b, n);
        }
    }

    public void removeAll() {
        this.b = null;
    }

    public int size() {
        return this.b != null ? this.b.length : 0;
    }

    public boolean setIgnoreEvents(boolean bl) {
        if (this.c != bl) {
            this.c = bl;
            return !bl;
        }
        return bl;
    }

    public boolean isIgnoreEvents() {
        return this.c;
    }

    public boolean isWeakReference(int n) {
        return this.b[n] instanceof WeakReference;
    }

    public int findListener(EventListener eventListener) {
        this.assertListenerType(eventListener);
        if (this.b != null) {
            for (int i = 0; i < this.b.length; ++i) {
                Object object = this.b[i];
                if (object != eventListener && (!(object instanceof WeakReference) || ((WeakReference)object).get() != eventListener)) continue;
                return i;
            }
        }
        return -1;
    }

    public EventListener getListener(int n) {
        Object object = this.b[n];
        return (EventListener)(object instanceof WeakReference ? ((WeakReference)object).get() : object);
    }

    public Iterator iterator() {
        if (this.c || this.b == null || this.b.length == 0) {
            return EMPTY_ITERATOR;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.b.length);
        for (int i = 0; i < this.b.length; ++i) {
            Object object = this.b[i];
            if (object instanceof WeakReference) {
                object = ((WeakReference)object).get();
            }
            if (object != null) {
                arrayList.add(object);
                continue;
            }
            this.b = MigUtil.removeFromArray(this.b, i);
            --i;
        }
        return arrayList.listIterator(0);
    }

    public List getListeners() {
        return Arrays.asList(this.b);
    }

    public boolean fireEvent(EventObject eventObject) {
        if (this.c || this.b == null || this.b.length == 0) {
            return false;
        }
        Iterator iterator = this.iterator();
        boolean bl = iterator.hasNext();
        if (eventObject instanceof ChangeEvent) {
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)eventObject);
            }
        } else if (eventObject instanceof ActivityDragResizeEvent) {
            while (iterator.hasNext()) {
                ((ActivityDragResizeListener)iterator.next()).activityDragResized((ActivityDragResizeEvent)eventObject);
            }
        } else if (eventObject instanceof MouseInteractionEvent) {
            while (iterator.hasNext() && ((MouseInteractionEvent)eventObject).getConsumeLevel() < 10003) {
                ((MouseInteractionListener)iterator.next()).mouseInteracted((MouseInteractionEvent)eventObject);
            }
        } else if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            while (iterator.hasNext()) {
                EventListener eventListener;
                Object e = iterator.next();
                if (e instanceof MouseListener) {
                    eventListener = (MouseListener)e;
                    switch (mouseEvent.getID()) {
                        case 500: {
                            eventListener.mouseClicked(mouseEvent);
                            break;
                        }
                        case 501: {
                            eventListener.mousePressed(mouseEvent);
                            break;
                        }
                        case 502: {
                            eventListener.mouseReleased(mouseEvent);
                            break;
                        }
                        case 504: {
                            eventListener.mouseEntered(mouseEvent);
                            break;
                        }
                        case 505: {
                            eventListener.mouseExited(mouseEvent);
                        }
                    }
                }
                if (!(e instanceof MouseMotionListener)) continue;
                eventListener = (MouseMotionListener)e;
                switch (mouseEvent.getID()) {
                    case 503: {
                        eventListener.mouseMoved(mouseEvent);
                        break;
                    }
                    case 506: {
                        eventListener.mouseDragged(mouseEvent);
                    }
                }
            }
        } else if (eventObject instanceof MouseWheelEvent) {
            while (iterator.hasNext()) {
                ((MouseWheelListener)iterator.next()).mouseWheelMoved((MouseWheelEvent)eventObject);
            }
        } else if (eventObject instanceof ActionEvent) {
            while (iterator.hasNext()) {
                ((ActionListener)iterator.next()).actionPerformed((ActionEvent)eventObject);
            }
        } else if (eventObject instanceof PropertyChangeEvent) {
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange((PropertyChangeEvent)eventObject);
            }
        } else if (eventObject instanceof ActivityMoveEvent) {
            while (iterator.hasNext()) {
                ((ActivityMoveListener)iterator.next()).activityMoved((ActivityMoveEvent)eventObject);
            }
        } else if (eventObject instanceof DateChangeEvent) {
            while (iterator.hasNext()) {
                ((DateChangeListener)iterator.next()).dateRangeChanged((DateChangeEvent)eventObject);
            }
        } else if (eventObject instanceof InteractionEvent) {
            while (iterator.hasNext()) {
                ((InteractionListener)iterator.next()).interactionOccured((InteractionEvent)eventObject);
            }
        } else if (eventObject instanceof TimeSpanListEvent) {
            while (iterator.hasNext()) {
                ((TimeSpanListListener)iterator.next()).timeSpanListChanged((TimeSpanListEvent)eventObject);
            }
        } else if (eventObject instanceof CategoryStructureEvent) {
            while (iterator.hasNext()) {
                ((CategoryStructureListener)iterator.next()).categoryStructureChanged((CategoryStructureEvent)eventObject);
            }
        } else if (eventObject instanceof ExceptionEvent) {
            while (iterator.hasNext()) {
                ((ExceptionListener)iterator.next()).exceptionThrown((ExceptionEvent)eventObject);
            }
        } else {
            throw new IllegalArgumentException("Unknown EventObject class: " + (eventObject != null ? eventObject.getClass().getName() : "null") + "   for listener class: " + this.d);
        }
        return bl;
    }

    public boolean fireVetoableEvent(EventObject eventObject) throws PropertyVetoException {
        if (this.c || this.b == null || this.b.length == 0) {
            return false;
        }
        Iterator iterator = this.iterator();
        boolean bl = iterator.hasNext();
        if (eventObject instanceof PropertyChangeEvent) {
            while (iterator.hasNext()) {
                ((VetoableChangeListener)iterator.next()).vetoableChange((PropertyChangeEvent)eventObject);
            }
        } else {
            throw new IllegalArgumentException("Unknown EventObject class: " + (eventObject != null ? eventObject.getClass().getName() : "null") + "   for listener class: " + this.d);
        }
        return bl;
    }

    protected void assertListenerType(Object object) {
        if (object == null) {
            throw new NullPointerException("listener = null!");
        }
        if (this.d != null && !this.d.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Wrong listener class type: " + object.getClass() + "  for: " + this.d);
        }
    }

    private static final class a
    implements Iterator {
        private a() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

