/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.dates;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatList
implements Serializable {
    private static final SimpleDateFormat a = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    protected final transient String pattern;
    protected final transient Locale locale;
    protected final transient TimeZone timeZone;
    private transient SimpleDateFormat[] b = null;
    private transient SimpleDateFormat c = null;
    private transient int[] d = null;
    private transient Locale e = null;
    private transient TimeZone f = null;
    private static final long serialVersionUID = 1L;

    public DateFormatList(String string) {
        this(string, null, null);
    }

    public DateFormatList(String string, Locale locale) {
        this(string, locale, null);
    }

    public DateFormatList(String string, Locale locale, TimeZone timeZone) {
        this.pattern = string;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public SimpleDateFormat toSimpleDateFormat(Locale locale) {
        return this.toSimpleDateFormats(locale, null)[0];
    }

    public SimpleDateFormat toSimpleDateFormat(Locale locale, TimeZone timeZone) {
        return this.toSimpleDateFormats(locale, timeZone)[0];
    }

    public SimpleDateFormat[] toSimpleDateFormats(Locale locale) {
        return this.toSimpleDateFormats(locale, null);
    }

    public SimpleDateFormat[] toSimpleDateFormats(Locale locale, TimeZone timeZone) {
        this.b(locale, timeZone);
        return this.b;
    }

    public int getFormatCount() {
        if (this.b == null) {
            this.b(null, null);
        }
        return this.b.length;
    }

    public String[] format(Date date) {
        return this.format(null, date);
    }

    public String[] format(Locale locale, Date date) {
        return this.format(locale, null, date);
    }

    public String[] format(Locale locale, TimeZone timeZone, Date date) {
        this.b(locale, timeZone);
        String[] stringArray = new String[this.b.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.b[i].format(date);
            int n = this.d[i];
            stringArray[i] = n >= 0 && string.length() > n ? string.substring(0, n) : string;
        }
        return stringArray;
    }

    public String formatFirst(Date date) {
        return this.format(null, null, date)[0];
    }

    public String formatFirst(Locale locale, Date date) {
        return this.format(locale, null, date)[0];
    }

    public String formatFirst(Locale locale, TimeZone timeZone, Date date) {
        return this.format(locale, timeZone, date)[0];
    }

    public Date parse(String string, Date date) throws ParseException {
        return this.parse(string, date, true);
    }

    public Date parse(String string, Date date, boolean bl) throws ParseException {
        if (date != null) {
            if (this.c == null) {
                this.c = new SimpleDateFormat("yyyyMMddHHmmssSSS" + this.pattern);
                if (this.timeZone != null) {
                    this.c.setTimeZone(this.timeZone);
                }
            }
            this.c.setLenient(bl);
            return this.c.parse(a.format(date) + string);
        }
        return this.toSimpleDateFormat(this.a((Locale)null), this.a((TimeZone)null)).parse(string);
    }

    private SimpleDateFormat[] a(Locale locale, TimeZone timeZone) {
        locale = this.a(locale);
        timeZone = this.a(timeZone);
        String[] stringArray = MigUtil.toTokens(this.pattern, '|');
        SimpleDateFormat[] simpleDateFormatArray = new SimpleDateFormat[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            simpleDateFormatArray[i] = new SimpleDateFormat(this.a(stringArray[i]), locale);
            if (timeZone == null) continue;
            simpleDateFormatArray[i].setTimeZone(timeZone);
        }
        return simpleDateFormatArray;
    }

    private void b(Locale locale, TimeZone timeZone) {
        if (this.b == null || !MigUtil.equals(this.e, locale) || !MigUtil.equals(this.f, timeZone)) {
            this.b = this.a(locale, timeZone);
            this.d = new int[this.b.length];
            String[] stringArray = MigUtil.toTokens(this.pattern, '|');
            for (int i = 0; i < stringArray.length; ++i) {
                this.d[i] = this.b(stringArray[i]);
            }
            this.e = locale;
            this.f = timeZone;
            this.c = null;
        }
    }

    private Locale a(Locale locale) {
        return locale != null ? locale : (this.locale != null ? this.locale : Locale.getDefault());
    }

    private TimeZone a(TimeZone timeZone) {
        return timeZone != null ? timeZone : (this.timeZone != null ? this.timeZone : TimeZone.getDefault());
    }

    private final String a(String string) {
        if (string.length() == 0) {
            return string;
        }
        char c2 = string.charAt(0);
        return c2 < '0' || c2 > '9' ? string : string.substring(1);
    }

    private final int b(String string) {
        if (string.length() == 0) {
            return -1;
        }
        char c2 = string.charAt(0);
        return c2 < '0' || c2 > '9' ? -1 : c2 - 48;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return "Pattern: [" + this.pattern + "], Locale: [" + this.locale + "], Time zone: [" + this.timeZone + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateFormatList)) {
            return false;
        }
        DateFormatList dateFormatList = (DateFormatList)object;
        return MigUtil.equals(this.pattern, dateFormatList.pattern) && MigUtil.equals(this.locale, dateFormatList.locale) && MigUtil.equals(this.timeZone, dateFormatList.timeZone);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == DateFormatList.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(DateFormatList.class, new DefaultPersistenceDelegate(new String[]{"pattern", "locale", "timeZone"}));
    }
}

