/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.dates;

import com.miginfocom.util.ListenerSet;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.DateRangeRounder;
import com.miginfocom.util.dates.DateUtil;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public class DateRange
implements MutableDateRange {
    private transient long a;
    private transient long b;
    private final transient TimeZone c;
    private final transient Locale d;
    private transient boolean e = true;
    private transient boolean f = true;
    private transient int g = 0;
    private transient ImmutableDateRange h = null;
    private transient ListenerSet i = null;
    private static final long serialVersionUID = 1L;

    public DateRange() {
        this(System.currentTimeMillis(), null, null);
    }

    public DateRange(long l) {
        this(l, null, null);
    }

    public DateRange(long l, TimeZone timeZone, Locale locale) {
        this.c = timeZone;
        this.d = locale;
        this.a = l;
        this.b = l;
    }

    public DateRange(Date date, Date date2, boolean bl, TimeZone timeZone, Locale locale) {
        this(date.getTime(), date2.getTime(), bl, timeZone, locale);
    }

    public DateRange(Calendar calendar, TimeZone timeZone, Locale locale) {
        this(calendar.getTimeInMillis(), calendar.getTimeInMillis(), false, timeZone, locale);
    }

    public DateRange(long l, long l2) {
        this.a = l;
        this.b = l2;
        this.c = null;
        this.d = null;
    }

    public DateRange(long l, long l2, boolean bl, TimeZone timeZone, Locale locale) {
        this(l, l2, bl, -1, timeZone, locale);
    }

    public DateRange(DateRangeI dateRangeI) {
        this.a = dateRangeI.getStartMillis();
        this.b = dateRangeI.getEndMillis();
        this.d = dateRangeI.getLocale();
        this.c = dateRangeI.getTimeZone();
        this.e = dateRangeI.getHasDate();
        this.f = dateRangeI.getHasTime();
    }

    public DateRange(long l, long l2, boolean bl, int n, TimeZone timeZone, Locale locale) {
        this.a = l;
        this.b = l2;
        this.c = timeZone;
        this.d = locale;
        if (bl) {
            if (this.a == this.b) {
                throw new IllegalArgumentException("Range can't span negative zero millis. Set 'endExcluding' to false.");
            }
            --this.b;
        }
        if (n != -1) {
            this.roundExpand(n);
        }
    }

    public DateRange(long l, int n, int n2, TimeZone timeZone, Locale locale) {
        this.a = l;
        this.b = l;
        this.c = timeZone;
        this.d = locale;
        this.roundExpand(n);
        if (n2 > 1) {
            this.setSize(n, n2, 1000);
        }
    }

    public DateRange(DateRangeI dateRangeI, DateRangeI dateRangeI2) {
        if (dateRangeI == null && dateRangeI2 == null) {
            throw new IllegalArgumentException("Both ranges is null!");
        }
        if (dateRangeI == null) {
            this.a = dateRangeI2.getStartMillis();
            this.b = dateRangeI2.getEndMillis();
            this.sort(true);
        } else if (dateRangeI2 == null) {
            this.a = dateRangeI.getStartMillis();
            this.b = dateRangeI.getEndMillis();
            this.sort(true);
        } else {
            this.a = Math.min(Math.min(dateRangeI.getStartMillis(), dateRangeI.getEndMillis()), Math.min(dateRangeI2.getStartMillis(), dateRangeI2.getEndMillis()));
            this.b = Math.max(Math.max(dateRangeI.getStartMillis(), dateRangeI.getEndMillis()), Math.max(dateRangeI2.getStartMillis(), dateRangeI2.getEndMillis()));
        }
        this.c = dateRangeI != null ? dateRangeI.getTimeZone() : dateRangeI2.getTimeZone();
        this.d = dateRangeI != null ? dateRangeI.getLocale() : dateRangeI2.getLocale();
    }

    public DateRange(long l, long l2, TimeZone timeZone, Locale locale, boolean bl, boolean bl2) {
        this(l, l2, false, timeZone, locale);
        this.e = bl;
        this.f = bl2;
    }

    private Calendar a(long l) {
        return DateUtil.createCalendar(l, this.c, this.d);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.c;
    }

    @Override
    public Locale getLocale() {
        return this.d;
    }

    @Override
    public boolean getHasDate() {
        return this.e;
    }

    @Override
    public void setHasDate(boolean bl) {
        this.e = bl;
    }

    @Override
    public boolean getHasTime() {
        return this.f;
    }

    @Override
    public void setHasTime(boolean bl) {
        this.f = bl;
    }

    @Override
    public MutableDateRange getDateRangeClone() {
        return new DateRange(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    @Override
    public DateRangeI getDateRangeForReading() {
        return this;
    }

    @Override
    public MutableDateRange getWritableDateRange() {
        return this;
    }

    @Override
    public ImmutableDateRange getImmutable() {
        return new ImmutableDateRange(this.a, this.b, false, this.c, this.d, this.e, this.f);
    }

    public ImmutableDateRange getImmutable(TimeZone timeZone) {
        return new ImmutableDateRange(this.a, this.b, false, timeZone, this.d, this.e, this.f);
    }

    @Override
    public Calendar getEnd(boolean bl) {
        return DateUtil.createCalendar(this.b + (long)(bl ? 1 : 0), this.c, this.d);
    }

    @Override
    public Calendar getEnd() {
        return DateUtil.createCalendar(this.b, this.c, this.d);
    }

    @Override
    public Date getEndTime(boolean bl) {
        return new Date(this.b + (long)(bl ? 1 : 0));
    }

    @Override
    public Date getEndTime() {
        return new Date(this.b);
    }

    @Override
    public int getEndField(int n, boolean bl) {
        return this.a(this.b + (long)(bl ? 1 : 0)).get(n);
    }

    @Override
    public int getEndField(int n) {
        return this.a(this.b).get(n);
    }

    public void setEnd(Calendar calendar, boolean bl) {
        long l = calendar.getTimeInMillis();
        if (bl) {
            --l;
        }
        if (this.b != l) {
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setEndMillis(long l, boolean bl) {
        if (bl) {
            --l;
        }
        if (this.b != l) {
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public long getEndMillis(boolean bl) {
        return bl ? this.b + 1L : this.b;
    }

    @Override
    public long getEndMillis() {
        return this.b;
    }

    @Override
    public void setEndField(int n, int n2) {
        Calendar calendar = this.getEnd();
        calendar.set(n, n2);
        long l = calendar.getTimeInMillis();
        if (this.b != l) {
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void addEnd(int n, long l) {
        if (l != 0L) {
            Calendar calendar = this.getEnd();
            if (n == 14) {
                calendar.setTimeInMillis(calendar.getTimeInMillis() + l);
            } else {
                calendar.add(n, (int)l);
            }
            this.b = calendar.getTimeInMillis();
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public ImmutableDateRange getStartInstant() {
        return new ImmutableDateRange(this.a, this.a, false, this.c, this.d);
    }

    @Override
    public ImmutableDateRange getEndInstant(boolean bl) {
        long l = bl ? this.b + 1L : this.b;
        return new ImmutableDateRange(l, l, false, this.c, this.d);
    }

    @Override
    public ImmutableDateRange getEndInstant() {
        return new ImmutableDateRange(this.b, this.b, false, this.c, this.d);
    }

    @Override
    public Calendar getStart() {
        return DateUtil.createCalendar(this.a, this.c, this.d);
    }

    @Override
    public Date getStartTime() {
        return new Date(this.a);
    }

    @Override
    public int getStartField(int n) {
        return this.getStart().get(n);
    }

    @Override
    public long getStartMillis() {
        return this.a;
    }

    public void setStart(Calendar calendar) {
        long l = calendar.getTimeInMillis();
        if (this.a != l) {
            this.a = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setStartMillis(long l) {
        if (this.a != l) {
            this.a = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setStartField(int n, int n2) {
        Calendar calendar = this.getStart();
        calendar.set(n, n2);
        long l = calendar.getTimeInMillis();
        if (this.a != l) {
            this.a = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setStartTime(Integer n, Integer n2, Integer n3, Integer n4) {
        long l;
        Calendar calendar = this.getStart();
        if (n != null) {
            calendar.set(11, n);
        }
        if (n2 != null) {
            calendar.set(12, n2);
        }
        if (n3 != null) {
            calendar.set(13, n3);
        }
        if (n4 != null) {
            calendar.set(14, n4);
        }
        if (this.a != (l = calendar.getTimeInMillis())) {
            this.a = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setEndTime(Integer n, Integer n2, Integer n3, Integer n4, boolean bl) {
        long l;
        Calendar calendar = this.getEnd();
        if (n != null) {
            calendar.set(11, n);
        }
        if (n2 != null) {
            calendar.set(12, n2);
        }
        if (n3 != null) {
            calendar.set(13, n3);
        }
        if (n4 != null) {
            calendar.set(14, n4);
        }
        if (this.b != (l = calendar.getTimeInMillis() + (long)(bl ? -1 : 0))) {
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void addStart(int n, long l) {
        if (l != 0L) {
            Calendar calendar = this.getStart();
            if (n == 14) {
                calendar.setTimeInMillis(calendar.getTimeInMillis() + l);
            } else {
                calendar.add(n, (int)l);
            }
            this.a = calendar.getTimeInMillis();
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public MutableDateRange setToRange(DateRangeI dateRangeI) {
        this.a = dateRangeI.getStartMillis();
        this.b = dateRangeI.getEndMillis();
        this.e = dateRangeI.getHasDate();
        this.f = dateRangeI.getHasTime();
        this.firePropertyChangeEvent(true);
        return this;
    }

    @Override
    public MutableDateRange setTimeFromRange(DateRangeI dateRangeI) {
        Calendar calendar = this.getStart();
        calendar.set(11, dateRangeI.getStartField(11));
        calendar.set(12, dateRangeI.getStartField(12));
        calendar.set(13, dateRangeI.getStartField(13));
        calendar.set(14, dateRangeI.getStartField(14));
        this.a = calendar.getTimeInMillis();
        Calendar calendar2 = this.getEnd();
        calendar2.set(11, dateRangeI.getEndField(11, false));
        calendar2.set(12, dateRangeI.getEndField(12, false));
        calendar2.set(13, dateRangeI.getEndField(13, false));
        calendar2.set(14, dateRangeI.getEndField(14, false));
        this.b = calendar2.getTimeInMillis();
        this.firePropertyChangeEvent(true);
        return this;
    }

    @Override
    public MutableDateRange setDateFromRange(DateRangeI dateRangeI) {
        Calendar calendar = this.getStart();
        calendar.set(1, dateRangeI.getStartField(1));
        calendar.set(6, dateRangeI.getStartField(6));
        this.a = calendar.getTimeInMillis();
        Calendar calendar2 = this.getEnd();
        calendar2.set(1, dateRangeI.getEndField(1, false));
        calendar2.set(6, dateRangeI.getEndField(6, false));
        this.b = calendar2.getTimeInMillis();
        this.firePropertyChangeEvent(true);
        return this;
    }

    @Override
    public boolean isSpanningTime() {
        return this.a != this.b + 1L;
    }

    @Override
    public boolean isSorted() {
        return this.a <= this.b;
    }

    @Override
    public boolean isInSame(int n) {
        return DateUtil.isInSame(this.getStart(), this.getEnd(), n);
    }

    @Override
    public int getSize(int n, boolean bl) {
        return DateUtil.getSpanCount(this.getStart(), this.getEnd(), n, bl);
    }

    @Override
    public long getMillisSpanned(boolean bl, boolean bl2) {
        if (bl) {
            return DateUtil.getMillisSpannedDST(this.a, this.c, this.b, this.c) + (long)(bl2 ? 1 : 0);
        }
        return this.b - this.a + (long)(bl2 ? 1 : 0);
    }

    @Override
    public long getMillisSpanned(boolean bl) {
        if (!bl) {
            return this.b - this.a + 1L;
        }
        return DateUtil.getMillisSpannedDST(this.a, this.c, this.b, this.c) + 1L;
    }

    @Override
    public void setMillisSpanned(long l, boolean bl, boolean bl2) {
        if (bl2) {
            --l;
        }
        this.b = bl ? DateUtil.addMillisDSTSafe(this.a, this.c, l) : this.a + l;
        this.firePropertyChangeEvent(true);
    }

    @Override
    public void setMillisSpanned(long l, boolean bl) {
        this.setMillisSpanned(l, bl, false);
    }

    @Override
    public boolean isOverlapping(DateRangeI dateRangeI) {
        return this.a <= dateRangeI.getEndMillis() && this.b >= dateRangeI.getStartMillis();
    }

    @Override
    public long getOverlap(DateRangeI dateRangeI) {
        return Math.max(0L, Math.min(this.b, dateRangeI.getEndMillis()) - Math.max(this.a, dateRangeI.getStartMillis()));
    }

    @Override
    public boolean isOverlapping(long l, long l2) {
        return this.a <= l2 && this.b >= l;
    }

    @Override
    public boolean isContinuous(DateRangeI dateRangeI) {
        return this.a <= dateRangeI.getEndMillis(true) && this.b + 1L >= dateRangeI.getStartMillis();
    }

    @Override
    public boolean isOverlapping(DateRangeI dateRangeI, DateRangeI dateRangeI2) {
        return this.a <= Math.min(dateRangeI.getEndMillis(), dateRangeI2.getEndMillis()) && this.b >= Math.max(dateRangeI.getStartMillis(), dateRangeI2.getStartMillis());
    }

    @Override
    public boolean isContaining(DateRangeI dateRangeI) {
        return dateRangeI.getStartMillis() >= this.a && dateRangeI.getEndMillis() <= this.b;
    }

    @Override
    public boolean isOutside(DateRangeI dateRangeI) {
        return dateRangeI.getStartMillis() > this.a && dateRangeI.getEndMillis() < this.b;
    }

    public DateRangeI cloneRange() {
        return new DateRange(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    @Override
    public MutableDateRange sort(boolean bl) {
        if (this.a <= this.b != bl) {
            long l = this.a;
            this.a = this.b;
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
        return this;
    }

    @Override
    public MutableDateRange sort() {
        return this.sort(true);
    }

    @Override
    public boolean isContaining(long l, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.a <= this.b;
        if (!bl && !bl2) {
            return false;
        }
        if (bl2) {
            return this.a <= l && this.b >= l;
        }
        return this.b >= l && this.a <= l;
    }

    @Override
    public int getRangeType() {
        Calendar calendar;
        Calendar calendar2 = this.getStart();
        if (DateUtil.isInSame(calendar2, calendar = this.getEnd(), 44)) {
            if (calendar2.get(11) == 0 && calendar2.get(12) == 0 && calendar2.get(14) == 0 && calendar.get(11) == 23 && calendar.get(12) == 59 && calendar.get(14) == 999) {
                return 44;
            }
            return 48;
        }
        int n = DateUtil.getSpanCount(calendar2, calendar, 44, false);
        if (n < 7 || n > 7 && n < 28 || n > 31 && n < 330 || n > 380) {
            return 48;
        }
        int n2 = calendar2.getFirstDayOfWeek();
        int n3 = DateUtil.getLastDayOfWeek(calendar2);
        if (calendar2.get(7) == n2 && calendar.get(7) == n3 && calendar2.get(3) == calendar.get(3) && DateUtil.getYear_WeekBased(calendar2) == DateUtil.getYear_WeekBased(calendar)) {
            return 43;
        }
        if (calendar2.get(5) == 1 && calendar.get(5) == calendar.getActualMaximum(5) && calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2)) {
            return 42;
        }
        if (n > 350 && n < 380 && calendar2.get(7) == n2 && calendar.get(7) == n3 && calendar2.get(3) == 1 && calendar.get(3) == calendar.getActualMaximum(3)) {
            return 40;
        }
        if (calendar2.get(6) == 1 && calendar2.get(1) == calendar.get(1) && calendar.get(6) == calendar.getActualMaximum(6)) {
            return 41;
        }
        return 48;
    }

    @Override
    public DateRange roundExpand(int n) {
        boolean bl = this.a <= this.b;
        Calendar calendar = this.getStart();
        DateUtil.setToBoundary(calendar, n, bl);
        long l = calendar.getTimeInMillis();
        calendar.setTimeInMillis(this.b);
        DateUtil.setToBoundary(calendar, n, !bl);
        long l2 = calendar.getTimeInMillis();
        if (this.a != l || this.b != l2) {
            this.a = l;
            this.b = l2;
            this.firePropertyChangeEvent(false);
        }
        return this;
    }

    @Override
    public DateRange roundReduce(int n) {
        boolean bl = this.a <= this.b;
        Calendar calendar = this.a(this.a + (long)(bl ? -1 : 1));
        Calendar calendar2 = this.a(this.b + (long)(bl ? 1 : -1));
        DateUtil.setToEndBoundary(bl ? calendar : calendar2, n);
        DateUtil.setToStartBoundary(bl ? calendar2 : calendar, n);
        long l = calendar.getTimeInMillis() + (long)(bl ? 1 : -1);
        long l2 = calendar2.getTimeInMillis() + (long)(bl ? -1 : 1);
        if (this.a != l || this.b != l2) {
            this.a = l;
            this.b = l2;
            this.firePropertyChangeEvent(false);
        }
        return this;
    }

    @Override
    public void setStartToBoundaryExpand(int n) {
        Calendar calendar = this.getStart();
        long l = this.a <= this.b ? DateUtil.setToStartBoundary(calendar, n).getTimeInMillis() : DateUtil.setToEndBoundary(calendar, n).getTimeInMillis();
        if (this.a != l) {
            this.a = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setStartToBoundaryReduce(int n) {
        boolean bl = this.a <= this.b;
        long l = this.a + (long)(bl ? -1 : 1);
        Calendar calendar = this.a(l);
        l = bl ? DateUtil.setToEndBoundary(calendar, n).getTimeInMillis() : DateUtil.setToStartBoundary(calendar, n).getTimeInMillis();
        if (this.a != (l += (long)(bl ? 1 : -1))) {
            this.a = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setEndToBoundaryExpand(int n) {
        Calendar calendar = this.getEnd();
        long l = this.a <= this.b ? DateUtil.setToEndBoundary(calendar, n).getTimeInMillis() : DateUtil.setToStartBoundary(calendar, n).getTimeInMillis();
        if (this.b != l) {
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void setEndToBoundaryReduce(int n) {
        boolean bl = this.a <= this.b;
        long l = this.b + (long)(bl ? 1 : -1);
        Calendar calendar = this.a(l);
        l = bl ? DateUtil.setToStartBoundary(calendar, n).getTimeInMillis() : DateUtil.setToEndBoundary(calendar, n).getTimeInMillis();
        l = this.b + (long)(bl ? -1 : 1);
        if (this.b != l) {
            this.b = l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public MutableDateRange move(int n, long l, int n2) {
        long l2;
        Calendar calendar = this.getMiddle();
        if (n == 14) {
            calendar.setTimeInMillis(calendar.getTimeInMillis() + l);
        } else {
            calendar.add(n, (int)l);
        }
        this.a = l2 = calendar.getTimeInMillis();
        this.b = l2;
        this.roundExpand(n2);
        return this;
    }

    @Override
    public void add(int n, long l, boolean bl, boolean bl2, DateRangeRounder dateRangeRounder) {
        this.postponeEvents();
        if (bl) {
            this.addStart(n, l);
        }
        if (bl2) {
            this.addEnd(n, l);
        }
        if (dateRangeRounder != null) {
            dateRangeRounder.round(this);
        }
        this.allowEvents();
    }

    @Override
    public MutableDateRange add(int n, long l, boolean bl, boolean bl2) {
        this.postponeEvents();
        long l2 = 0L;
        if (bl) {
            l2 = this.getMillisSpanned(bl2);
        }
        this.addStart(n, l);
        if (bl) {
            this.setMillisSpanned(l2, bl2);
        } else {
            this.addEnd(n, l);
        }
        this.allowEvents();
        return this;
    }

    @Override
    public void addMillis(long l) {
        if (l != 0L) {
            this.a += l;
            this.b += l;
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void addMillisDSTSafe(long l) {
        if (l != 0L) {
            this.a = DateUtil.addMillisDSTSafe(this.getStartMillis(), this.c, l);
            this.b = DateUtil.addMillisDSTSafe(this.getEndMillis(), this.c, l);
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public void roll(int n, int n2) {
        if (n2 != 0) {
            Calendar calendar = this.getStart();
            calendar.roll(n, n2);
            this.a = calendar.getTimeInMillis();
            calendar.setTimeInMillis(this.b);
            calendar.roll(n, n2);
            this.b = calendar.getTimeInMillis();
            this.firePropertyChangeEvent(false);
        }
    }

    @Override
    public DateRange expandRange(int n, int n2) {
        if (n2 != 0) {
            Calendar calendar = this.getStart();
            calendar.add(n, -n2);
            this.a = calendar.getTimeInMillis();
            calendar.setTimeInMillis(this.b);
            calendar.add(n, n2);
            this.b = calendar.getTimeInMillis();
            this.firePropertyChangeEvent(false);
        }
        return this;
    }

    @Override
    public DateRange setSize(int n, int n2, int n3) {
        if (n3 < 1000 || n3 > 1005) {
            throw new IllegalArgumentException("Unknown alignment: " + n3);
        }
        this.postponeEvents();
        boolean bl = this.a <= this.b;
        this.sort(true);
        int n4 = this.getSize(n, false);
        if (n4 != n2) {
            int n5 = DateUtil.convertRangeTypeToCalField(n);
            if (n3 == 1001 || n3 == 1000) {
                int n6 = Math.round((float)(n4 - n2) / 2.0f + (n3 == 1000 ? -0.1f : 0.1f));
                this.addStart(n5, n6);
                this.addEnd(n5, n2 - n4 + n6);
            } else if (bl && n3 == 1002 || !bl && n3 == 1003 || n3 == 1004) {
                this.addEnd(n5, n2 - n4);
            } else {
                this.addStart(n5, -(n2 - n4));
            }
        }
        this.sort(bl);
        this.roundExpand(n);
        this.allowEvents();
        return this;
    }

    @Override
    public MutableDateRange setSize(int n, int n2, AtRefRangeNumber atRefRangeNumber) {
        this.postponeEvents();
        boolean bl = this.a <= this.b;
        this.sort(true);
        int n3 = this.getSize(n, false);
        if (n3 != n2) {
            int n4 = atRefRangeNumber != null ? atRefRangeNumber.getIntValue(0.0f, n2 - n3) : n2 - n3 >> 1;
            int n5 = DateUtil.convertRangeTypeToCalField(n);
            this.addStart(n5, -n4);
            this.addEnd(n5, n2 - n3 - n4);
        }
        this.sort(bl);
        this.roundExpand(n);
        this.allowEvents();
        return this;
    }

    @Override
    public DateRange cut(DateRangeI dateRangeI) {
        long l = dateRangeI.getStartMillis();
        long l2 = dateRangeI.getEndMillis();
        boolean bl = false;
        if (l > this.a) {
            this.a = l;
            bl = true;
        }
        if (l2 < this.b) {
            this.b = l2;
            bl = true;
        }
        if (bl) {
            this.firePropertyChangeEvent(true);
        }
        return this;
    }

    @Override
    public DateRange cutAway(DateRangeI dateRangeI) {
        if (!this.isOverlapping(dateRangeI) || !dateRangeI.isSpanningTime()) {
            return null;
        }
        if (this.isOutside(dateRangeI)) {
            long l = this.b;
            this.b = dateRangeI.getStartMillis() - 1L;
            this.firePropertyChangeEvent(true);
            return new DateRange(dateRangeI.getEndMillis() + 1L, l, false, this.c, this.d);
        }
        if (dateRangeI.isContaining(this)) {
            this.b = this.a - 1L;
            this.firePropertyChangeEvent(true);
            return null;
        }
        if (this.a < dateRangeI.getStartMillis()) {
            this.b = dateRangeI.getStartMillis() - 1L;
        }
        if (this.b > dateRangeI.getEndMillis()) {
            this.a = dateRangeI.getEndMillis() + 1L;
        }
        this.firePropertyChangeEvent(true);
        return null;
    }

    @Override
    public DateRange union(DateRangeI dateRangeI) {
        if (dateRangeI == null) {
            return this;
        }
        long l = dateRangeI.getStartMillis();
        long l2 = dateRangeI.getEndMillis();
        boolean bl = false;
        if (l < this.a) {
            this.a = l;
            bl = true;
        }
        if (l2 > this.b) {
            this.b = l2;
            bl = true;
        }
        if (bl) {
            this.firePropertyChangeEvent(true);
        }
        return this;
    }

    @Override
    public DateRange addRange(DateRangeI dateRangeI) {
        boolean bl = this.getMiddleMillis() <= dateRangeI.getMiddleMillis();
        this.postponeEvents();
        this.union(dateRangeI);
        this.sort(bl);
        this.allowEvents();
        return this;
    }

    @Override
    public Calendar getMiddle() {
        return this.a(this.a + this.b >> 1);
    }

    @Override
    public long getMiddleMillis() {
        return this.a + this.b >> 1;
    }

    @Override
    public Calendar getRelative(double d) {
        return this.a(this.a + Math.round(d * (double)(this.b - this.a)));
    }

    @Override
    public long getRelativeMillis(double d) {
        return this.a + Math.round(d * (double)(this.b - this.a));
    }

    @Override
    public DateRangeI getRelativeRange(double d, double d2) {
        long l = this.b - this.a;
        long l2 = this.a + Math.round(d * (double)l);
        long l3 = this.b + Math.round(d2 * (double)l);
        return new DateRange(l2, l3, false, this.c, this.d);
    }

    @Override
    public String getDurationString(String string) {
        return DateUtil.getDurationString(this, string);
    }

    @Override
    public RangeIterator iterator(int n) {
        return new RangeIterator(n, 1);
    }

    @Override
    public Iterator<ImmutableDateRange> iterator(int n, int n2) {
        return new RangeIterator(n, n2);
    }

    @Override
    public ArrayList getSubDateList(int n, int[] nArray, int n2, int[] nArray2, int n3, boolean bl) {
        if (nArray2 != null && (nArray2.length != nArray.length || n != 7 || n2 != 5 && n2 != 6)) {
            throw new IllegalArgumentException("Illegal combination of parameters when dayOfWeekOccur != null.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length << 1);
        Calendar calendar = this.getStart();
        int n4 = DateUtil.convertCalFieldToRangeType(n);
        while (calendar.getTimeInMillis() < this.b) {
            int n5 = calendar.get(n);
            for (int i = 0; i < nArray.length; ++i) {
                int n6;
                int n7 = nArray[i];
                if (n7 < 0) {
                    n7 = calendar.getActualMaximum(n) - (n7 + 1);
                }
                if (nArray2 != null && (n6 = nArray2[i]) != 0) {
                    int n8 = DateUtil.getWeekDayOccurence(calendar, n2, n6 > 0);
                    if (Math.abs(n6) != n8) continue;
                }
                if (n7 != n5) continue;
                arrayList.add(bl ? new DateRange(calendar.getTimeInMillis(), n4, 1, this.c, this.d) : calendar.clone());
                if (n3 == -1 || arrayList.size() < n3) continue;
                return arrayList;
            }
            calendar.add(n, 1);
        }
        return arrayList;
    }

    public String toString() {
        return this.toString(null, false, false, false);
    }

    @Override
    public String toString(String string, boolean bl, boolean bl2) {
        return this.toString(string, bl, bl2, false);
    }

    @Override
    public String toString(String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder(150);
        DateFormat dateFormat = string == null ? SimpleDateFormat.getDateTimeInstance() : new SimpleDateFormat(string);
        Calendar calendar = this.getStart();
        dateFormat.setCalendar(calendar);
        stringBuilder.append(dateFormat.format(calendar.getTime()));
        if (bl2) {
            long l = calendar.getTimeInMillis();
            TimeZone timeZone = calendar.getTimeZone();
            stringBuilder.append(" (RAW:").append((float)timeZone.getRawOffset() / 3600000.0f);
            stringBuilder.append(", DST:").append((float)(timeZone.getRawOffset() - timeZone.getOffset(l)) / 3600000.0f).append(')');
        }
        Calendar calendar2 = this.getEnd(bl);
        dateFormat.setCalendar(calendar2);
        stringBuilder.append(" to ").append(dateFormat.format(calendar2.getTime()));
        if (bl2) {
            long l = calendar2.getTimeInMillis();
            TimeZone timeZone = calendar2.getTimeZone();
            stringBuilder.append(" (RAW:").append((float)timeZone.getRawOffset() / 3600000.0f);
            stringBuilder.append(", DST:").append((float)(timeZone.getRawOffset() - timeZone.getOffset(l)) / 3600000.0f).append(')');
        }
        if (this.c != null) {
            stringBuilder.append(", Time zone: ").append(this.c.getDisplayName());
        }
        if (this.d != null) {
            stringBuilder.append(", Locale: ").append(this.d.getDisplayName());
        }
        if (bl3) {
            stringBuilder.append(", Start Millis: ").append(this.getStartMillis());
            stringBuilder.append(", End Millis: ").append(this.getEndMillis(bl));
            stringBuilder.append(", Length Millis: ").append(this.getMillisSpanned(false));
            stringBuilder.append(", Length: ");
            stringBuilder.append(DateUtil.getDurationString(calendar, calendar2, bl, "y?' (: year: years) 'M?' (:month:months) 'd?' (:day:days) 'H?' (:hour:hours) 'm?' (:minute:minutes) 's?' (:second:seconds) 'S?' (:millisecond:milliseconds)'"));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateRangeI)) {
            return false;
        }
        DateRangeI dateRangeI = (DateRangeI)object;
        return dateRangeI.getStartMillis() == this.a && dateRangeI.getEndMillis() == this.b && dateRangeI.getHasDate() == this.e && dateRangeI.getHasTime() == this.f && MigUtil.equals(dateRangeI.getTimeZone(), this.c) && MigUtil.equals(dateRangeI.getLocale(), this.d);
    }

    public int compareTo(Object object) {
        long l;
        long l2;
        if (object == null || !(object instanceof DateRangeI)) {
            throw new IllegalArgumentException("Wrong type: " + object);
        }
        DateRangeI dateRangeI = (DateRangeI)object;
        long l3 = this.getStartMillis();
        if (l3 != (l2 = dateRangeI.getStartMillis())) {
            return l3 > l2 ? 1 : -1;
        }
        long l4 = this.getEndMillis();
        return l4 < (l = dateRangeI.getEndMillis()) ? -1 : (l4 > l ? 1 : 0);
    }

    public int hashCode() {
        return (int)(this.a + (this.b >>> 1));
    }

    @Override
    public void postponeEvents() {
        if (this.g > 100) {
            throw new IllegalStateException("postpone count can't be > 100!");
        }
        ++this.g;
    }

    @Override
    public void allowEvents() {
        if (this.g <= 0) {
            throw new IllegalStateException("postpone count can't be < 0!");
        }
        if (--this.g == 0) {
            this.firePropertyChangeEvent(true);
        }
    }

    @Override
    public boolean isIgnorePropertyEvents() {
        return this.i != null ? this.i.isIgnoreEvents() : true;
    }

    @Override
    public boolean setIgnorePropertyEvents(boolean bl) {
        return this.i != null ? this.i.setIgnoreEvents(bl) : true;
    }

    @Override
    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyListener(propertyChangeListener, false);
    }

    @Override
    public void addPropertyListener(PropertyChangeListener propertyChangeListener, boolean bl) {
        if (this.i == null) {
            this.h = this.getImmutable();
            this.i = new ListenerSet(PropertyChangeListener.class);
        }
        this.i.add(propertyChangeListener, bl);
    }

    @Override
    public void removePropertyListener(PropertyChangeListener propertyChangeListener) {
        if (this.i != null) {
            this.i.remove(propertyChangeListener);
        }
    }

    protected boolean firePropertyChangeEvent(boolean bl) {
        if (this.i == null || this.g > 0 || bl && this.equals(this.h)) {
            return false;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "dateRange", this.h, new ImmutableDateRange(this));
        this.h = (ImmutableDateRange)propertyChangeEvent.getNewValue();
        return this.i.fireEvent(propertyChangeEvent);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == DateRange.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(DateRange.class, new DefaultPersistenceDelegate(new String[]{"startMillis", "endMillis", "locale", "timeZone", "hasDate", "hasTime"}));
    }

    public final class RangeIterator
    implements Iterable<ImmutableDateRange>,
    Iterator<ImmutableDateRange> {
        private final int b;
        private final int c;
        private final long d;
        private final MutableDateRange e;
        private boolean f;

        private RangeIterator(int n, int n2) {
            this.c = n2;
            this.b = n;
            this.d = DateRange.this.b;
            this.e = new DateRange(DateRange.this.a, DateRange.this.b, false, DateRange.this.c, DateRange.this.d);
            this.e.setSize(n, n2, 1002);
            this.e.cut(DateRange.this);
            this.f = DateRange.this.isSorted();
        }

        @Override
        public Iterator<ImmutableDateRange> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.f;
        }

        @Override
        public ImmutableDateRange next() {
            if (!this.f) {
                throw new NoSuchElementException("Iteration past end of range: " + this.toString());
            }
            ImmutableDateRange immutableDateRange = new ImmutableDateRange(this.e);
            this.e.setStartMillis(this.e.getEndMillis(true));
            if (this.e.getStartMillis() <= this.d) {
                this.e.setEndMillis(this.e.getStartMillis(), false);
                this.e.setSize(this.b, this.c, 1002);
                if (this.e.getEndMillis() > this.d) {
                    this.e.setEndMillis(this.d, false);
                }
            } else {
                this.f = false;
            }
            return immutableDateRange;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(".remove() not supported in a RangeIterator.");
        }
    }
}

