/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.dates;

import com.miginfocom.calendar.activity.recurrence.Recurrence;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.dates.DateRange;
import com.miginfocom.util.dates.DateRangeI;
import com.miginfocom.util.dates.ImmutableDateRange;
import com.miginfocom.util.dates.MutableDateRange;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final long SECOND_MILLIS = 1000L;
    public static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    public static final long WEEK_MILLIS = 604800000L;
    private static int[] a = new int[]{1, 1, 2, 3, 6, 11, 12, 13};
    private static int[] b = new int[]{-1, 41, 42, 43, 43, 44, 44, 44, 44, -1, 45, 45, 46, 47};
    public static final SimpleDateFormat ICAL_DF = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
    private static final long[] c = new long[]{604800000L, 86400000L, 3600000L, 60000L, 1000L, 1L};

    public static Calendar createCalendar(TimeZone timeZone, Locale locale) {
        return DateUtil.createCalendar(Long.MIN_VALUE, timeZone, locale);
    }

    public static Date parseDateTime(String string) {
        try {
            return ICAL_DF.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Long getLastRecurrenceMillis(Recurrence recurrence, DateRangeI dateRangeI, Calendar calendar) {
        if (recurrence.isRepeatingForever()) {
            return null;
        }
        long l = calendar != null ? calendar.getTimeInMillis() : System.currentTimeMillis() + 3153600000000L;
        ImmutableDateRange immutableDateRange = new ImmutableDateRange(dateRangeI.getStartMillis(), l, false, null, null);
        ArrayList<MutableDateRange> arrayList = recurrence.getDateRanges(dateRangeI, immutableDateRange, true);
        int n = arrayList.size();
        return n > 0 ? new Long(((DateRangeI)arrayList.get(n - 1)).getEndMillis()) : null;
    }

    public static Calendar createCalendar(long l, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone != null ? timeZone : TimeZone.getDefault(), locale != null ? locale : Locale.getDefault());
        if (l != Long.MIN_VALUE) {
            calendar.setTimeInMillis(l);
        }
        return calendar;
    }

    public static int convertRangeTypeToCalField(int n) {
        return a[n - 40];
    }

    public static int convertCalFieldToRangeType(int n) {
        int n2 = b[n];
        if (n2 != -1) {
            return n2;
        }
        throw new ArrayIndexOutOfBoundsException("Wrong Calendar field: " + n);
    }

    public static Calendar setToStartBoundary(Calendar calendar, int n) {
        return DateUtil.setToBoundary(calendar, n, true);
    }

    public static Calendar setToEndBoundary(Calendar calendar, int n) {
        return DateUtil.setToBoundary(calendar, n, false);
    }

    public static Calendar setToBoundary(Calendar calendar, int n, boolean bl) {
        int n2;
        int n3;
        if (n != 45 && n != 46 && n != 47) {
            switch (n) {
                case 44: 
                case 48: {
                    break;
                }
                case 43: {
                    n3 = calendar.get(3);
                    n2 = DateUtil.getYear_WeekBased(calendar);
                    if (bl) {
                        int n4 = calendar.getFirstDayOfWeek() - calendar.get(7);
                        if (n4 == 0) break;
                        calendar.add(7, n4 > 0 ? n4 - 7 : n4);
                        break;
                    }
                    int n5 = DateUtil.getLastDayOfWeek(calendar) - calendar.get(7);
                    if (n5 == 0) break;
                    calendar.add(7, n5 < 0 ? n5 + 7 : n5);
                    break;
                }
                case 42: {
                    calendar.set(5, bl ? 1 : calendar.getActualMaximum(5));
                    break;
                }
                case 41: {
                    calendar.set(6, bl ? 1 : calendar.getActualMaximum(6));
                    break;
                }
                case 40: {
                    calendar.set(1, DateUtil.getYear_WeekBased(calendar));
                    calendar.set(7, bl ? calendar.getFirstDayOfWeek() : DateUtil.getLastDayOfWeek(calendar));
                    calendar.set(3, bl ? 1 : calendar.getActualMaximum(3));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong boundaryType: " + n);
                }
            }
            calendar.set(11, bl ? 0 : 23);
            calendar.set(12, bl ? 0 : 59);
            calendar.set(13, bl ? 0 : 59);
        } else {
            n3 = bl ? 0 : 59;
            switch (n) {
                case 45: {
                    n2 = calendar.get(12);
                    if (n2 != n3) {
                        calendar.add(12, n3 - n2);
                    }
                }
                case 46: {
                    int n6 = calendar.get(13);
                    if (n6 == n3) break;
                    calendar.add(13, n3 - n6);
                }
            }
        }
        n3 = bl ? 0 : 999;
        n2 = calendar.get(14);
        if (n2 != n3) {
            calendar.add(14, n3 - n2);
        }
        return calendar;
    }

    public static boolean isOnBoundaryStart(Calendar calendar, int n) {
        switch (n) {
            case 40: {
                if (calendar.get(7) != calendar.getFirstDayOfWeek() || calendar.get(3) != 1) {
                    return false;
                }
            }
            case 41: {
                if (n == 41 && calendar.get(6) != 1) {
                    return false;
                }
            }
            case 42: {
                if (n == 42 && calendar.get(5) != 1) {
                    return false;
                }
            }
            case 43: {
                if (n == 43 && calendar.get(7) != calendar.getFirstDayOfWeek()) {
                    return false;
                }
            }
            case 44: {
                if (calendar.get(11) != 0) {
                    return false;
                }
            }
            case 45: {
                if (calendar.get(12) != 0) {
                    return false;
                }
            }
            case 46: {
                if (calendar.get(13) != 0) {
                    return false;
                }
            }
            case 47: {
                return calendar.get(14) == 0;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Calendar field: " + n);
            }
        }
    }

    public static <E extends Collection<ImmutableDateRange>> Collection<ImmutableDateRange> toImmutable(Collection<? extends DateRangeI> collection, E object) {
        for (DateRangeI dateRangeI : collection) {
            object.add(dateRangeI.getImmutable());
        }
        return object;
    }

    public static LinkedList<DateRange> getUnionRanges(Collection<? extends DateRangeI> collection) {
        LinkedList<DateRange> linkedList = new LinkedList<DateRange>();
        if (collection.isEmpty()) {
            return linkedList;
        }
        if (collection.size() == 1) {
            linkedList.add(new DateRange(collection.iterator().next()));
            return linkedList;
        }
        for (DateRangeI object2 : collection) {
            linkedList.add(new DateRange(object2));
        }
        Collections.sort(linkedList);
        Object object3 = linkedList.get(0);
        ListIterator<DateRange> listIterator = linkedList.listIterator(1);
        while (listIterator.hasNext()) {
            DateRange dateRange = (DateRange)listIterator.next();
            if (dateRange.isOverlapping((DateRangeI)object3)) {
                ((DateRange)object3).union(dateRange);
                listIterator.remove();
                continue;
            }
            object3 = dateRange;
        }
        return linkedList;
    }

    public static void copyTimeOfDay(Calendar calendar, Calendar calendar2) {
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        calendar2.set(14, calendar.get(14));
    }

    public static long getFieldModulo(Calendar calendar, int n) {
        calendar = (Calendar)calendar.clone();
        return DateUtil.setToStartBoundary(calendar, n).getTimeInMillis();
    }

    public static String getDurationString(Calendar calendar, Calendar calendar2, boolean bl, String string) {
        return DateUtil.getDurationString(new DateRange(calendar.getTimeInMillis(), calendar2.getTimeInMillis(), bl, calendar.getTimeZone(), null), string);
    }

    public static String getDurationString(DateRangeI dateRangeI, String string) {
        int n;
        int n2;
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        boolean[] blArray = new boolean[8];
        boolean bl = false;
        int n3 = string.length();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n2 = string.charAt(i);
            if (n2 == 39) {
                bl = !bl;
                continue;
            }
            if (n2 == 63) {
                blArray[n4] = true;
                continue;
            }
            if (n2 == 32 || bl) continue;
            int n5 = n4 = DateUtil.a((char)n2);
            nArray[n5] = nArray[n5] + 1;
        }
        long l = dateRangeI.getEndMillis(true);
        for (n2 = 0; n2 < 2; ++n2) {
            Calendar calendar = dateRangeI.getStart();
            n = n2 == 0 ? 1 : 2;
            while (true) {
                calendar.add(n, 1);
                if (calendar.getTimeInMillis() > l) break;
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + 1;
            }
            if (nArray2[n2] <= 0) continue;
            dateRangeI = new DateRange(dateRangeI);
            ((DateRange)dateRangeI).addStart(n, nArray2[n2]);
        }
        long l2 = dateRangeI.getMillisSpanned(true, true);
        n = 0;
        int n7 = 2;
        while (n < c.length) {
            long l3 = c[n];
            if (nArray[n7] > 0) {
                nArray2[n7] = (int)(l2 / l3);
                l2 -= (long)nArray2[n7] * l3;
            }
            ++n;
            ++n7;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 + 6);
        bl = false;
        n7 = 0;
        block4: for (int i = 0; i < n3; ++i) {
            int n8;
            char c2 = string.charAt(i);
            if (c2 == '\'') {
                bl = !bl;
                continue;
            }
            if (c2 == '(') {
                n8 = -1;
                int n9 = -1;
                for (int j = i + 1; j < n3; ++j) {
                    char c3 = string.charAt(j);
                    if (c3 == '\'') {
                        stringBuilder.append(string.substring(i, j));
                        bl = false;
                        i = j;
                        continue block4;
                    }
                    if (c3 == ')') {
                        if (n8 != -1 && n9 != -1) {
                            if (n7 == 0) {
                                stringBuilder.append(string.substring(i + 1, n8));
                            } else if (n7 == 1) {
                                stringBuilder.append(string.substring(n8 + 1, n9));
                            } else {
                                stringBuilder.append(string.substring(n9 + 1, j));
                            }
                        } else {
                            stringBuilder.append(string.substring(i, j + 1));
                        }
                        i = j;
                        continue block4;
                    }
                    if (c3 != ':') continue;
                    if (n8 == -1) {
                        n8 = j;
                        continue;
                    }
                    n9 = j;
                }
                continue;
            }
            if (bl || c2 == ' ') {
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == '?') continue;
            n8 = DateUtil.a(c2);
            n7 = nArray2[n8];
            if (n7 != 0 || !blArray[n8]) {
                stringBuilder.append(MigUtil.intToString(n7, nArray[n8]));
            }
            while (i < n3 - 1 && string.charAt(i + 1) == c2) {
                ++i;
            }
        }
        return stringBuilder.toString().trim();
    }

    private static int a(char c2) {
        switch (c2) {
            case 'H': {
                return 4;
            }
            case 'm': {
                return 5;
            }
            case 'd': {
                return 3;
            }
            case 's': {
                return 6;
            }
            case 'y': {
                return 0;
            }
            case 'M': {
                return 1;
            }
            case 'w': {
                return 2;
            }
            case 'S': {
                return 7;
            }
        }
        throw new IllegalArgumentException("Unknown format char: " + c2);
    }

    public static String getLocalDateTimeString(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        simpleDateFormat.setCalendar(calendar);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static int getWeeksOfYear(int n, Locale locale) {
        Calendar calendar = DateUtil.createCalendar(null, locale);
        calendar.set(n, 0, 1);
        return calendar.getActualMaximum(3);
    }

    public static Calendar setYearWeekDay_WeekBased(Calendar calendar, int n, int n2, int n3) {
        calendar.set(1, n);
        calendar.set(7, DateUtil.convertToDayOfWeek(n3, calendar));
        calendar.set(3, n2);
        return calendar;
    }

    public static int convertToDayOfWeek(int n, Calendar calendar) {
        int n2 = n + (calendar != null ? calendar.getFirstDayOfWeek() : Calendar.getInstance().getFirstDayOfWeek());
        if (n2 > 7) {
            n2 -= 7;
        }
        return n2;
    }

    public static int convertToDayIndex(int n, Calendar calendar) {
        int n2 = n - calendar.getFirstDayOfWeek();
        if (n2 < 0) {
            n2 += 7;
        }
        return n2;
    }

    public static int getDaysSpanApprox(Date date, Date date2) {
        return Math.abs((int)(date2.getTime() / 86400000L) - (int)(date.getTime() / 86400000L) + 1);
    }

    public static boolean isInSame(Calendar calendar, Calendar calendar2, int n) {
        if (n == 40) {
            return DateUtil.getYear_WeekBased(calendar) == DateUtil.getYear_WeekBased(calendar2);
        }
        if (n == 41) {
            return calendar.get(1) == calendar2.get(1);
        }
        long l = calendar.getTimeInMillis();
        long l2 = calendar2.getTimeInMillis();
        long l3 = l2 - l;
        switch (n) {
            case 42: {
                return l3 < 2851200000L && calendar.get(2) == calendar2.get(2);
            }
            case 43: {
                return (float)l3 < 6.6528E8f && calendar.get(3) == calendar2.get(3);
            }
            case 44: {
                return (float)l3 < 9.504E7f && calendar.get(6) == calendar2.get(6);
            }
            case 45: {
                return (float)l3 < 3960000.0f && calendar.get(11) == calendar2.get(11);
            }
            case 46: {
                return (float)l3 < 66000.0f && calendar.get(12) == calendar2.get(12);
            }
            case 47: {
                return (float)l3 < 1100.0f && calendar.get(13) == calendar2.get(13);
            }
        }
        throw new IllegalArgumentException("Wrong rangeType: " + n);
    }

    public static int getLastDayOfWeek(Calendar calendar) {
        int n = calendar.getFirstDayOfWeek() + 6;
        if (n > 7) {
            n -= 7;
        }
        return n;
    }

    public static int getYear_WeekBased(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(3);
        int n3 = calendar.get(5);
        if (n2 == 1 && n3 > 20) {
            return n + 1;
        }
        if (n2 >= 52 && n3 < 10) {
            return n - 1;
        }
        return n;
    }

    public static Calendar getMiddleDate(Date date, Date date2, Locale locale) {
        return DateUtil.createCalendar(date.getTime() + (date2.getTime() >> 1), null, locale);
    }

    public static boolean isOverlapping(Calendar calendar, Calendar calendar2, Calendar calendar3, Calendar calendar4) {
        return calendar.getTimeInMillis() <= calendar4.getTimeInMillis() && calendar2.getTimeInMillis() >= calendar3.getTimeInMillis();
    }

    public static boolean isOverlapping(Date date, Date date2, Date date3, Date date4) {
        return date.getTime() <= date4.getTime() && date2.getTime() >= date3.getTime();
    }

    public static boolean isOverlapping(long l, long l2, long l3, long l4) {
        return l <= l4 && l2 >= l3;
    }

    public static boolean isContaining(Calendar calendar, Calendar calendar2, Calendar calendar3, Calendar calendar4) {
        return calendar3.getTime().getTime() >= calendar.getTime().getTime() && calendar4.getTime().getTime() <= calendar2.getTime().getTime();
    }

    public static boolean isContaining(Date date, Date date2, Date date3, Date date4) {
        return date3.getTime() >= date.getTime() && date4.getTime() <= date2.getTime();
    }

    public static boolean isContaining(long l, long l2, long l3, long l4) {
        return l3 >= l && l4 <= l2;
    }

    public static int getSpanCountIter(Calendar calendar, Calendar calendar2, int n) {
        if (n == 40) {
            int n2 = DateUtil.getYear_WeekBased(calendar2) - DateUtil.getYear_WeekBased(calendar);
            return calendar.getTimeInMillis() <= calendar2.getTimeInMillis() ? n2 + 1 : n2 - 1;
        }
        int n3 = DateUtil.convertRangeTypeToCalField(n);
        int n4 = (calendar = (Calendar)calendar.clone()).getTimeInMillis() <= calendar2.getTimeInMillis() ? 1 : -1;
        int n5 = 1;
        while (!DateUtil.isInSame(calendar, calendar2, n)) {
            ++n5;
            calendar.add(n3, n4);
        }
        return n5 * n4;
    }

    public static int getSpanCount(Calendar calendar, Calendar calendar2, int n, boolean bl) {
        TimeZone timeZone;
        int n2;
        if (n <= 42) {
            return DateUtil.getSpanCountIter(calendar, calendar2, n);
        }
        long l = DateRangeI.RANGE_TYPES_MILLIS[n - 40];
        int n3 = DateUtil.convertRangeTypeToCalField(n);
        Calendar calendar3 = (Calendar)calendar.clone();
        int n4 = (int)(calendar3.getTimeInMillis() / l);
        int n5 = (int)(calendar2.getTimeInMillis() / l);
        int n6 = n5 - n4;
        calendar3.add(n3, n6);
        int n7 = 0;
        for (int i = 1; !DateUtil.isInSame(calendar3, calendar2, n) && i < 100; ++i) {
            n7 = (i & 1) != 0 ? i * -1 : i;
            calendar3.add(n3, n7);
        }
        if (n7 > 0) {
            n7 >>= 1;
        } else if (n7 < 0) {
            n7 = n7 - 1 >> 1;
        }
        if (bl && (n2 = (timeZone = calendar.getTimeZone()).getOffset(calendar.getTimeInMillis()) - timeZone.getOffset(calendar2.getTimeInMillis())) != 0) {
            n7 = (int)((long)n7 - (long)n2 / l);
        }
        return n6 + n7 + (calendar2.before(calendar) ? -1 : 1);
    }

    public static long getMillisSpannedDST(long l, TimeZone timeZone, long l2, TimeZone timeZone2) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (timeZone2 == null) {
            timeZone2 = TimeZone.getDefault();
        }
        return l2 - l - DateUtil.getDSTDiff(new Date(l), timeZone, new Date(l2), timeZone2);
    }

    public static long getDSTDiff(Date date, TimeZone timeZone, Date date2, TimeZone timeZone2) {
        long l = 0L;
        if (timeZone.inDaylightTime(date) && (l = (long)timeZone.getDSTSavings()) == 0L && timeZone.getID().equals("Australia/Perth")) {
            l = 3600000L;
        }
        long l2 = 0L;
        if (timeZone2.inDaylightTime(date2) && (l2 = (long)timeZone.getDSTSavings()) == 0L && timeZone2.getID().equals("Australia/Perth")) {
            l2 = 3600000L;
        }
        return l - l2;
    }

    public static long addMillisDSTSafe(long l, TimeZone timeZone, long l2) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        int n = timeZone.getOffset(l);
        int n2 = timeZone.getOffset(l + l2);
        int n3 = n - n2;
        return l + l2 + (long)n3;
    }

    public static Calendar addDSTSafe(Calendar calendar, int n, int n2) {
        TimeZone timeZone = calendar.getTimeZone();
        int n3 = timeZone.getOffset(calendar.getTimeInMillis());
        calendar.add(n, n2);
        int n4 = timeZone.getOffset(calendar.getTimeInMillis());
        int n5 = n3 - n4;
        if (n5 != 0) {
            calendar.setTimeInMillis(calendar.getTimeInMillis() + (long)n5);
        }
        return calendar;
    }

    public static int getWeekDayOccurence(Calendar calendar, int n, boolean bl) {
        int n2 = bl ? calendar.get(n) - 1 : calendar.getActualMaximum(n) - calendar.get(n);
        return n2 / 7 + 1;
    }

    public static Calendar setFieldCorrect(Calendar calendar, int n, int n2) {
        switch (n) {
            case 2: {
                calendar.set(2, n2);
                while (calendar.get(2) != n2) {
                    calendar.add(6, -1);
                }
                break;
            }
            case 1: {
                if (calendar.get(2) == 1 && calendar.get(5) == 29) {
                    calendar.set(1, n2);
                    calendar.set(5, 28);
                    calendar.set(2, 1);
                    calendar.set(5, calendar.getActualMaximum(5));
                    break;
                }
                calendar.set(1, n2);
                break;
            }
            case 9: {
                if (n2 == calendar.get(9)) break;
                calendar.add(9, n2 == 0 ? 1 : -1);
                break;
            }
            default: {
                calendar.set(n, n2);
            }
        }
        return calendar;
    }

    public static String[] getAlternativesForField(int n, Calendar calendar, DateFormat dateFormat, Integer n2) {
        String[] stringArray;
        Calendar calendar2 = (Calendar)calendar.clone();
        switch (n) {
            case 1: {
                stringArray = new String[n2 != null ? n2 : 12];
                calendar2.set(calendar.get(n) - Math.round((float)stringArray.length * 0.3f), 0, 1);
                break;
            }
            case 2: {
                stringArray = new String[n2 != null ? n2 : 12];
                if (stringArray.length == 12) {
                    calendar2.set(2, 0);
                    break;
                }
                calendar2.add(2, -Math.round((float)stringArray.length * 0.3f));
                break;
            }
            case 5: 
            case 6: {
                stringArray = new String[n2 != null ? n2.intValue() : calendar2.getActualMaximum(5)];
                if (n2 == null) {
                    DateUtil.setFieldCorrect(calendar2, 5, 1);
                    break;
                }
                calendar2.add(5, -Math.round((float)stringArray.length * 0.3f));
                break;
            }
            case 3: {
                DateUtil.setYearWeekDay_WeekBased(calendar2, calendar.get(n), 1, 0);
                stringArray = new String[n2 != null ? n2.intValue() : calendar2.getActualMaximum(3)];
                break;
            }
            case 7: {
                DateUtil.setYearWeekDay_WeekBased(calendar2, calendar.get(n), 1, 0);
                stringArray = new String[n2 != null ? n2 : 7];
                break;
            }
            case 10: {
                stringArray = new String[n2 != null ? n2 : 12];
                DateUtil.setToStartBoundary(calendar2, 44);
                break;
            }
            case 11: {
                stringArray = new String[n2 != null ? n2 : 24];
                DateUtil.setToStartBoundary(calendar2, 44);
                break;
            }
            case 12: {
                stringArray = new String[n2 != null ? n2 : 60];
                DateUtil.setToStartBoundary(calendar2, 44);
                break;
            }
            case 13: {
                stringArray = new String[n2 != null ? n2 : 60];
                DateUtil.setToStartBoundary(calendar2, 46);
                break;
            }
            case 9: {
                stringArray = new String[n2 != null ? n2 : 2];
                DateUtil.setToStartBoundary(calendar2, 44);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Calendar Field:" + n);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = dateFormat.format(calendar2.getTime());
            calendar2.add(n, 1);
        }
        return stringArray;
    }
}

