/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.expression;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.PropertyKey;
import com.miginfocom.util.PropertyProvider;
import com.miginfocom.util.expression.Expression;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;

public class LogicalExpression
implements Expression {
    public static final int EQUALS = 0;
    public static final int NOT_EQUALS = 1;
    public static final int EQUALS_IGNORE_CASE = 2;
    public static final int IN_CS = 3;
    public static final int GREATER_THAN = 4;
    public static final int LESS_THAN = 5;
    public static final int IS_NULL = 6;
    public static final int IN_COLLECTION = 7;
    public static final int NOT_IN_COLLECTION = 8;
    public static final int FIRST_IN_COLLECTION = 9;
    public static final int NOT_FIRST_IN_COLLECTION = 10;
    public static final int EMPTY_COLLECTION = 11;
    public static final int NOT_EMPTY_COLLECTION = 12;
    public static final int LAST_OPER = 12;
    private final transient PropertyKey a;
    private final transient int b;
    private final transient Object c;
    private static final long serialVersionUID = 1L;

    public LogicalExpression(String string, int n, Object object) {
        this(PropertyKey.getKey(string), n, object);
    }

    public LogicalExpression(PropertyKey propertyKey, int n, Object object) {
        if (n < 0 || n > 12) {
            throw new IllegalArgumentException("Unknown operation: " + n);
        }
        this.a = propertyKey;
        this.b = n;
        this.c = object;
    }

    @Override
    public boolean evaluate(PropertyProvider propertyProvider) {
        Object object = propertyProvider.getProperty(this.a);
        switch (this.b) {
            case 0: 
            case 1: {
                return MigUtil.equals(object, this.c) == (this.b == 0);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (object == null || this.c == null) break;
                if (!(object instanceof Comparable)) {
                    object = object.toString();
                }
                if (this.b == 3) {
                    return MigUtil.inCSString((String)object, this.c.toString());
                }
                if (this.b == 2) {
                    return ((String)object).equalsIgnoreCase((String)this.c);
                }
                int n = ((Comparable)object).compareTo(this.c);
                return this.b == 4 ? n > 0 : n < 0;
            }
            case 6: {
                return object == null;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (object instanceof Collection && ((Collection)object).size() > 0) {
                    int n = 0;
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        boolean bl = MigUtil.equals(this.c, iterator.next());
                        if (n == 0) {
                            if (this.b == 9) {
                                return bl;
                            }
                            if (this.b == 10) {
                                return !bl;
                            }
                        }
                        if (bl) {
                            return this.b == 7;
                        }
                        ++n;
                    }
                }
                return this.b == 8 || this.b == 10;
            }
            case 11: 
            case 12: {
                int n;
                int n2 = n = object instanceof Collection ? ((Collection)object).size() : 0;
                return this.b == 11 ? n == 0 : n != 0;
            }
        }
        return false;
    }

    public PropertyKey getProperty() {
        return this.a;
    }

    public int getOperation() {
        return this.b;
    }

    public Object getValue() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LogicalExpression)) {
            return false;
        }
        LogicalExpression logicalExpression = (LogicalExpression)object;
        return this.getOperation() == logicalExpression.getOperation() && this.getProperty() == logicalExpression.getProperty() && MigUtil.equals(this.getValue(), logicalExpression.getValue());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == LogicalExpression.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(LogicalExpression.class, new DefaultPersistenceDelegate(new String[]{"property", "operation", "value"}));
    }
}

