/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.Base64;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.StringProvider;
import com.miginfocom.util.gfx.XtdImage;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GfxUtil {
    public static final Font DEFAULT_FONT = UIManager.getFont("label.font");
    private static final Object[] a = new Object[]{null, RenderingHints.VALUE_ANTIALIAS_OFF, RenderingHints.VALUE_ANTIALIAS_DEFAULT, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_ON};
    private static RenderingHints.Key b = null;
    private static Object c = null;
    private static final Object[] d = new Object[]{null, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_ON};
    private static final String[] e = new String[]{"GASP", "LCD_HRGB", "LCD_HBGR", "LCD_VRGB", "LCD_VBGR"};
    public static final int AA_HINT_INHERIT = 0;
    public static final int AA_HINT_OFF = 1;
    public static final int AA_HINT_DEFAULT = 2;
    public static final int AA_HINT_ON = 3;
    public static final int AA_HINT_LCD_GASP = 4;
    public static final int AA_HINT_LCD_HRGB = 5;
    public static final int AA_HINT_LCD_HBGR = 6;
    public static final int AA_HINT_LCD_VRGB = 7;
    public static final int AA_HINT_LCD_VBGR = 8;
    public static final int AA_HINT_PLATFORM = 9;
    public static final int defaultImageTransparency = 1;
    private static GraphicsConfiguration f;
    private static Graphics2D g;
    private static String h;
    private static final Pattern i;
    private static final Graphics2D j;
    private static final BreakIterator k;
    private static final MediaTracker l;

    public static void setTextAntiAliasPlatformDefault(Object object) {
        GfxUtil.d[9] = object;
    }

    public static Object confAntiAliasingHint(Graphics2D graphics2D, boolean bl, int n) {
        Object object = null;
        if (graphics2D != null && n == -1) {
            return graphics2D.getRenderingHint(bl ? RenderingHints.KEY_TEXT_ANTIALIASING : RenderingHints.KEY_ANTIALIASING);
        }
        try {
            if (bl) {
                object = d[n];
                if (object != null && graphics2D != null) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                    if (c != null) {
                        graphics2D.setRenderingHint(b, c);
                    }
                }
            } else {
                object = a[n];
                if (object != null && graphics2D != null) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        if (f == null) {
            f = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return f;
    }

    public static Graphics2D getDummyGraphics() {
        if (g == null) {
            g = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(new BufferedImage(1, 1, 2));
        }
        return g;
    }

    public static String getUIName() {
        try {
            if (h == null) {
                String string = UIManager.getLookAndFeel().getName();
                if (string.equals("Metal") && System.getProperty("java.version").compareTo("1.5") >= 0 && !MigUtil.equals(System.getProperty("swing.metalTheme"), "steel")) {
                    string = "Ocean";
                } else if (string.equals("Windows") && MigUtil.isTrue(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"))) {
                    string = "WindowsXP";
                }
                h = string;
            }
        }
        catch (Throwable throwable) {
            h = "Metal";
        }
        return h;
    }

    public void setUIName(String string) {
        h = string;
    }

    public static Frame getShowingFrame() {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isShowing()) continue;
            return frameArray[i];
        }
        return null;
    }

    public static Cursor getCursor(Object object) {
        if (object instanceof Cursor) {
            return (Cursor)object;
        }
        if (object instanceof Integer) {
            return Cursor.getPredefinedCursor((Integer)object);
        }
        if (object instanceof String) {
            try {
                return Cursor.getSystemCustomCursor(object.toString());
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
        }
        return null;
    }

    public static int getMaxStringWidth(String[] stringArray, Font font, boolean bl, boolean bl2) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, bl, bl2);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = (int)(font.getStringBounds(stringArray[i], fontRenderContext).getWidth() + 0.5);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static Shape[] getTransformedShapes(AffineTransform affineTransform, Shape[] shapeArray) {
        Shape[] shapeArray2 = new Shape[shapeArray.length];
        for (int i = 0; i < shapeArray2.length; ++i) {
            shapeArray2[i] = GfxUtil.getTransformedShape(affineTransform, shapeArray[i]);
        }
        return shapeArray2;
    }

    public static Shape getTransformedShape(AffineTransform affineTransform, Shape shape) {
        if (shape instanceof Rectangle2D && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            double d3 = affineTransform.getScaleX();
            double d4 = affineTransform.getScaleY();
            if (shape instanceof Rectangle && (double)((int)d3) == d3 && (double)((int)d4) == d4 && (double)((int)d) == d && (double)((int)d2) == d2) {
                Rectangle rectangle = (Rectangle)shape;
                int n = (int)d3;
                int n2 = (int)d4;
                return new Rectangle(rectangle.x * n + (int)d, rectangle.y * n2 + (int)d2, rectangle.width * n, rectangle.height * n2);
            }
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            return new Rectangle2D.Double(rectangle2D.getX() * d3 + d, rectangle2D.getY() * d4 + d2, rectangle2D.getWidth() * d3, rectangle2D.getHeight() * d4);
        }
        return affineTransform.createTransformedShape(shape);
    }

    public static final Color brightColor(Color color, int n) {
        return new Color(Math.max(0, Math.min(255, color.getRed() + n)), Math.max(0, Math.min(255, color.getGreen() + n)), Math.max(0, Math.min(255, color.getBlue() + n)), color.getAlpha());
    }

    public static final Color tintColor(Color color, float f) {
        return new Color(Math.max(0, Math.min(255, Math.round((float)color.getRed() + 255.0f * f))), Math.max(0, Math.min(255, Math.round((float)color.getGreen() + 255.0f * f))), Math.max(0, Math.min(255, Math.round((float)color.getBlue() + 255.0f * f))), color.getAlpha());
    }

    public static final Color tintColor(Color color, int n) {
        return new Color(Math.max(0, Math.min(255, color.getRed() + n)), Math.max(0, Math.min(255, color.getGreen() + n)), Math.max(0, Math.min(255, color.getBlue() + n)), color.getAlpha());
    }

    public static Color getCrossColor(Color color, Color color2, float f) {
        if ((double)f < 0.001) {
            return color;
        }
        if ((double)f > 0.999) {
            return color2;
        }
        int n = color.getRGB();
        int n2 = color2.getRGB();
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            int n4 = n & 0xFF;
            int n5 = (n2 & 0xFF) - n4;
            int n6 = (int)((float)n4 + (float)n5 * f + 0.5f);
            n3 |= n6 << (i << 3);
            n >>= 8;
            n2 >>= 8;
        }
        return new Color(n3, true);
    }

    public static final Color alphaColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Rectangle drawFittingStringInRect(Graphics2D graphics2D, StringProvider stringProvider, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, boolean bl, int n2) {
        return GfxUtil.drawFittingStringInRect(graphics2D, stringProvider, rectangle, atRefRangeNumber, atRefRangeNumber2, n, null, bl, n2);
    }

    public static Rectangle drawFittingStringInRect(Graphics2D graphics2D, StringProvider stringProvider, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, Point point, boolean bl, int n2) {
        String string;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = stringProvider.getStringCount() - 1;
        for (int i = 0; i <= n3 && (string = stringProvider.getString(i)).length() != 0; ++i) {
            if (i != n3 && fontMetrics.stringWidth(string) > rectangle.width) continue;
            return GfxUtil.drawStringInRect(graphics2D, string, rectangle, atRefRangeNumber, atRefRangeNumber2, n, point, bl, n2);
        }
        return new Rectangle(rectangle.x, rectangle.y, 0, 0);
    }

    public static Rectangle drawStringInRect(Graphics2D graphics2D, String string, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, boolean bl, int n2) {
        return GfxUtil.drawStringInRect(graphics2D, string, rectangle, atRefRangeNumber, atRefRangeNumber2, n, null, bl, n2);
    }

    public static Rectangle drawStringInRect(Graphics2D graphics2D, String string, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, Point point, boolean bl, int n2) {
        Object object = GfxUtil.confAntiAliasingHint(graphics2D, true, n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getDescent();
        int n4 = fontMetrics.stringWidth(string) + (point != null ? point.x & 0x7FFFFFF : 0);
        int n5 = fontMetrics.getAscent() + n3 + (point != null ? point.y & 0x7FFFFFF : 0);
        int n6 = atRefRangeNumber != null ? Math.max(rectangle.x, rectangle.x + atRefRangeNumber.getIntValue(0.0f, rectangle.width - n4)) : rectangle.x;
        int n7 = rectangle.y + fontMetrics.getAscent() + (atRefRangeNumber2 != null ? atRefRangeNumber2.getIntValue(0.0f, rectangle.height - n5) : 0);
        if (bl) {
            if (point != null) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setColor(graphics2D.getBackground());
                graphics2D.drawString(string, n6 + point.x, n7 + point.y);
                graphics2D.setPaint(paint);
            }
            graphics2D.drawString(string, n6, n7);
            if (n > 0) {
                graphics2D.fillRect(n6, n7 + 1, n4, n);
            }
        }
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        return new Rectangle(n6, n7 - n5 + n3, n4, n5);
    }

    public static Rectangle drawFittingStringRot90(Graphics2D graphics2D, StringProvider stringProvider, boolean bl, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, boolean bl2, int n2) {
        return GfxUtil.drawFittingStringRot90(graphics2D, stringProvider, bl, rectangle, atRefRangeNumber, atRefRangeNumber2, n, null, bl2, n2);
    }

    public static Rectangle drawFittingStringRot90(Graphics2D graphics2D, StringProvider stringProvider, boolean bl, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, Point point, boolean bl2, int n2) {
        String string;
        Object object = GfxUtil.confAntiAliasingHint(graphics2D, true, n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = stringProvider.getStringCount() - 1;
        for (int i = 0; i <= n3 && (string = stringProvider.getString(i)).length() != 0; ++i) {
            if (i != n3 && fontMetrics.stringWidth(string) > rectangle.height) continue;
            return GfxUtil.drawStringRot90(graphics2D, string, bl, rectangle, atRefRangeNumber, atRefRangeNumber2, n, point, bl2, -1);
        }
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        return new Rectangle(rectangle.x, rectangle.y, 0, 0);
    }

    public static Rectangle drawStringRot90(Graphics2D graphics2D, String string, boolean bl, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, boolean bl2, int n2) {
        return GfxUtil.drawStringRot90(graphics2D, string, bl, rectangle, atRefRangeNumber, atRefRangeNumber2, n, null, bl2, n2);
    }

    public static Rectangle drawStringRot90(Graphics2D graphics2D, String string, boolean bl, Rectangle rectangle, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n, Point point, boolean bl2, int n2) {
        int n3;
        int n4;
        Object object = GfxUtil.confAntiAliasingHint(graphics2D, true, n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.getDescent() - 1;
        int n6 = fontMetrics.stringWidth(string) + (point != null ? point.x & 0x7FFFFFF : 0);
        int n7 = fontMetrics.getAscent() + n5 + (point != null ? point.y & 0x7FFFFFF : 0);
        int n8 = atRefRangeNumber.getIntValue(0.0f, rectangle.height - n6);
        int n9 = atRefRangeNumber2.getIntValue(0.0f, rectangle.width - n7);
        int n10 = bl ? rectangle.x + (n9 < 0 ? 0 : n9) + n5 : (n4 = rectangle.x + rectangle.width - (n9 < 0 ? 0 : n9) - n5);
        int n11 = bl ? rectangle.y + (n8 < 0 ? 0 : n8) : (n3 = rectangle.y + rectangle.height - (n8 < 0 ? 0 : n8));
        if (bl2) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n4, n3);
            graphics2D.rotate(bl ? 1.5707963267948966 : -1.5707963267948966);
            if (point != null) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setColor(graphics2D.getBackground());
                graphics2D.drawString(string, n4 + point.x, n3 + point.y);
                graphics2D.setPaint(paint);
            }
            graphics2D.drawString(string, 0, 0);
            if (n > 0) {
                graphics2D.fillRect(0, 1, n6, n);
            }
            graphics2D.setTransform(affineTransform);
        }
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        return bl ? new Rectangle(n4 - n5, n3, n7, n6) : new Rectangle(n4 - n7 + n5, n3 - n6, n7, n6);
    }

    public static Rectangle drawTextLinesInRect(Graphics2D graphics2D, String string, Rectangle rectangle, int n, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n2, boolean bl, boolean bl2, int n3) {
        return GfxUtil.drawTextLinesInRect(graphics2D, string, rectangle, n, atRefRangeNumber, atRefRangeNumber2, n2, null, bl, bl2, n3);
    }

    public static Rectangle drawTextLinesInRect(Graphics2D graphics2D, String string, Rectangle rectangle, int n, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, int n2, Point point, boolean bl, boolean bl2, int n3) {
        int n4;
        if (string == null || string.length() == 0 || bl && (rectangle.width <= 0 || rectangle.height <= 0)) {
            return new Rectangle(rectangle.x, rectangle.y, 0, 0);
        }
        Object object = GfxUtil.confAntiAliasingHint(graphics2D, true, n3);
        Shape shape = null;
        if (bl && bl2) {
            shape = graphics2D.getClip();
            graphics2D.clip(rectangle);
        }
        int n5 = point != null ? point.x & 0x7FFFFFF : 0;
        int n6 = rectangle.width + n5;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n7 = fontMetrics.getHeight() + n2;
        ArrayList arrayList = GfxUtil.createLayouts(graphics2D, string, n6, n, n7, rectangle.height);
        int n8 = arrayList.size() * n7 + fontMetrics.getDescent();
        int n9 = Math.max(rectangle.y + atRefRangeNumber2.getIntValue(0.0f, rectangle.height - n8), rectangle.y);
        int n10 = bl ? rectangle.y + rectangle.height : 0x3FFFFFF5;
        int n11 = 0x3FFFFFF5;
        int n12 = 0;
        int n13 = n9 + fontMetrics.getAscent();
        int n14 = arrayList.size();
        for (n4 = 0; n4 < n14 && n13 < n10; n13 += n7, ++n4) {
            TextLayout textLayout = (TextLayout)arrayList.get(n4);
            if (textLayout == null) continue;
            float f = textLayout.getVisibleAdvance();
            int n15 = rectangle.x + (atRefRangeNumber == null ? 0 : atRefRangeNumber.getIntValue(0.0f, (float)rectangle.width - f));
            if (f > (float)n12) {
                n12 = (int)(f + 0.5f);
            }
            if (n15 < n11) {
                n11 = n15;
            }
            if (!bl2) continue;
            if (point != null) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setColor(graphics2D.getBackground());
                textLayout.draw(graphics2D, n15 + point.x, n13 + point.y);
                graphics2D.setPaint(paint);
            }
            textLayout.draw(graphics2D, n15, n13);
        }
        if (bl && bl2) {
            graphics2D.setClip(shape);
        }
        n4 = Math.min(n8, n10 - rectangle.y);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
        return new Rectangle(n11 != 0x3FFFFFF5 ? n11 : 0, n9, n12 + n5, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTextLinesHeight(Font font, String string, Integer n, int n2, Object object) {
        if (string == null || string.length() == 0 || n != null && n < 1) {
            return 0;
        }
        Graphics2D graphics2D = j;
        synchronized (graphics2D) {
            j.setFont(font);
            j.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object != null ? object : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            int n3 = j.getFontMetrics(font).getHeight();
            if (n == null) {
                return n3;
            }
            ArrayList arrayList = GfxUtil.createLayouts(j, string, n, 0);
            return arrayList.size() * (n3 - n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStringWidth(Font font, String string, Object object) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Graphics2D graphics2D = j;
        synchronized (graphics2D) {
            j.setFont(font);
            j.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object != null ? object : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            return SwingUtilities.computeStringWidth(j.getFontMetrics(font), string);
        }
    }

    public static ArrayList createLayouts(Graphics2D graphics2D, String string, int n, int n2) {
        return GfxUtil.createLayouts(graphics2D, string, n, n2, 0, 0x3FFFFFF5);
    }

    public static ArrayList createLayouts(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>(4);
        String[] stringArray = i.split(string, 0);
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0) {
                TextLayout textLayout;
                AttributedString attributedString = new AttributedString(stringArray[i]);
                attributedString.addAttribute(TextAttribute.FONT, font);
                if (n2 > 0) {
                    attributedString.addAttribute(TextAttribute.UNDERLINE, n2 < 2 ? TextAttribute.UNDERLINE_LOW_ONE_PIXEL : TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
                }
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), k, fontRenderContext);
                while (lineBreakMeasurer.getPosition() < string.length() && (textLayout = lineBreakMeasurer.nextLayout(n)) != null) {
                    arrayList.add(textLayout);
                    if ((n5 += n3) + n3 <= n4) continue;
                    return arrayList;
                }
                continue;
            }
            arrayList.add(null);
            if ((n5 += n3) + n3 <= n4) continue;
            return arrayList;
        }
        return arrayList;
    }

    public static void unionInsets(Insets insets, Insets insets2) {
        if (insets2 != null) {
            if (insets2.top > insets.top) {
                insets.top = insets2.top;
            }
            if (insets2.left > insets.left) {
                insets.left = insets2.left;
            }
            if (insets2.bottom > insets.bottom) {
                insets.bottom = insets2.bottom;
            }
            if (insets2.right > insets.right) {
                insets.right = insets2.right;
            }
        }
    }

    public static void addInsets(Insets insets, Insets insets2) {
        if (insets2 != null) {
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
    }

    public static void drawRoundRect(Graphics2D graphics2D, Rectangle rectangle, float f, float f2, Paint paint, BasicStroke basicStroke, Paint paint2) {
        float f3 = 0.0f;
        if (basicStroke != null && paint2 != null) {
            f3 = basicStroke.getLineWidth() / 2.0f;
        }
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float((float)rectangle.x + f3, (float)rectangle.y + f3, (float)rectangle.width - f3, (float)rectangle.height - f3, f, f2);
        Paint paint3 = graphics2D.getPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            if (f == 0.0f && f2 == 0.0f) {
                graphics2D.fill(GfxUtil.getRoundedRect(float_, true));
            } else {
                graphics2D.fill(float_);
            }
        }
        if (basicStroke != null && paint2 != null) {
            ((RoundRectangle2D)float_).setRoundRect(((RectangularShape)float_).getX(), ((RectangularShape)float_).getY(), ((RectangularShape)float_).getWidth() - (double)f3, ((RectangularShape)float_).getHeight() - (double)f3, f, f2);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(paint2);
            if (f == 0.0f && f2 == 0.0f) {
                graphics2D.draw(GfxUtil.getRoundedRect(float_, true));
            } else {
                graphics2D.draw(float_);
            }
            graphics2D.setStroke(stroke);
        }
        graphics2D.setPaint(paint3);
    }

    public static void drawArrow(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6;
        if (n5 == 1 || n5 == 5) {
            n6 = (int)Math.ceil(0.5 * (double)n3);
            if (n6 > n4) {
                n6 = n4;
            }
        } else {
            n6 = (int)Math.ceil(0.5 * (double)n4);
            if (n6 > n3) {
                n6 = n3;
            }
        }
        graphics2D.translate(n, n2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        if (n5 == 1) {
            int n7 = (n4 - n6) / 2;
            int n8 = (n3 - 1) / 2;
            if (n3 % 2 == 0) {
                for (int i = 0; i < n6; ++i) {
                    graphics2D.fillRect(n8 - i, n7 + i, 2 * i + 2, 1);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillRect(n8 - n6 + 2, n7 + n6, 2 * n6, 1);
                }
            } else {
                for (int i = 0; i < n6; ++i) {
                    graphics2D.fillRect(n8 - i, n7 + i, 2 * i + 1, 1);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillRect(n8 - n6 + 2, n7 + n6, 2 * n6 - 1, 1);
                }
            }
        } else if (n5 == 5) {
            int n9 = (n4 + n6) / 2 - 1;
            int n10 = (n3 - 1) / 2;
            if (n3 % 2 == 0) {
                int n11;
                for (n11 = 0; n11 < n6; ++n11) {
                    graphics2D.fillRect(n10 - n11, n9 - n11, 2 * n11 + 2, 1);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    ++n10;
                    ++n9;
                    for (n11 = 0; n11 < n6; ++n11) {
                        graphics2D.fillRect(n10 + n11, n9 - n11, 2, 1);
                    }
                }
            } else {
                int n12;
                for (n12 = 0; n12 < n6; ++n12) {
                    graphics2D.fillRect(n10 - n12, n9 - n12, 2 * n12 + 1, 1);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    ++n9;
                    for (n12 = 1; n12 < n6; ++n12) {
                        graphics2D.fillRect(n10 + n12, n9 - n12, 2, 1);
                    }
                    graphics2D.fillRect(n10 + 1, n9, 1, 1);
                }
            }
        } else if (n5 == 3) {
            int n13 = (n3 + n6) / 2 - 1;
            int n14 = (n4 - 1) / 2;
            if (n4 % 2 == 0) {
                int n15;
                for (n15 = 0; n15 < n6; ++n15) {
                    graphics2D.fillRect(n13 - n15, n14 - n15, 1, 2 * n15 + 2);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    ++n13;
                    ++n14;
                    for (n15 = 0; n15 < n6; ++n15) {
                        graphics2D.fillRect(n13 - n15, n14 + n15, 1, 2);
                    }
                }
            } else {
                int n16;
                for (n16 = 0; n16 < n6; ++n16) {
                    graphics2D.fillRect(n13 - n16, n14 - n16, 1, 2 * n16 + 1);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    ++n14;
                    for (n16 = 0; n16 < n6 - 1; ++n16) {
                        graphics2D.fillRect(n13 - n16, n14 + n16, 1, 2);
                    }
                    graphics2D.fillRect(n13 + 1, n14, 1, 1);
                }
            }
        } else if (n5 == 7) {
            int n17 = (n3 - n6) / 2;
            int n18 = (n4 - 1) / 2;
            if (n4 % 2 == 0) {
                for (int i = 0; i < n6; ++i) {
                    graphics2D.fillRect(n17 + i, n18 - i, 1, 2 * i + 2);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillRect(n17 + n6, n18 - n6 + 2, 1, 2 * n6);
                }
            } else {
                for (int i = 0; i < n6; ++i) {
                    graphics2D.fillRect(n17 + i, n18 - i, 1, 2 * i + 1);
                }
                if (color2 != null) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillRect(n17 + n6, n18 - n6 + 2, 1, 2 * n6 - 1);
                }
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.translate(-n, -n2);
    }

    public static double getDistance(Point point, Point point2) {
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        return Math.sqrt(n * n + n2 * n2);
    }

    public static Shape cropShape(Shape shape, Shape shape2) {
        if (shape != null && shape2 != null) {
            if (shape2 instanceof Rectangle2D && shape instanceof Rectangle2D) {
                shape2 = ((Rectangle2D)shape).createIntersection((Rectangle2D)shape2);
            } else {
                Rectangle2D rectangle2D;
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                Rectangle2D rectangle2D2 = rectangle2D = shape2 instanceof Rectangle2D ? (Rectangle2D)shape2 : shape2.getBounds2D();
                if (!rectangle.contains(rectangle2D)) {
                    Area area = new Area(shape);
                    area.intersect(new Area(shape2));
                    shape2 = area;
                }
            }
        }
        return shape2;
    }

    public static final Rectangle getOutlineRect(RectangularShape rectangularShape) {
        int n = (int)rectangularShape.getX();
        int n2 = (int)rectangularShape.getY();
        int n3 = (int)Math.ceil(rectangularShape.getMaxX()) - n;
        int n4 = (int)Math.ceil(rectangularShape.getMaxY()) - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    public static final Rectangle getRoundedRect(RectangularShape rectangularShape, boolean bl) {
        if (rectangularShape == null) {
            return null;
        }
        if (bl) {
            double d = rectangularShape.getX();
            double d2 = rectangularShape.getY();
            int n = (int)(d + 0.5);
            int n2 = (int)(d2 + 0.5);
            int n3 = (int)(d + rectangularShape.getWidth() - (double)n + 0.5);
            int n4 = (int)(d2 + rectangularShape.getHeight() - (double)n2 + 0.5);
            return new Rectangle(n, n2, n3, n4);
        }
        return new Rectangle((int)(rectangularShape.getX() + 0.5), (int)(rectangularShape.getY() + 0.5), (int)(rectangularShape.getWidth() + 0.5), (int)(rectangularShape.getHeight() + 0.5));
    }

    public static Rectangle2D getCrossedRect2D(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d) {
        return new Rectangle2D.Double((rectangle2D2.getX() - rectangle2D.getX()) * d + rectangle2D.getX(), (rectangle2D2.getY() - rectangle2D.getY()) * d + rectangle2D.getY(), (rectangle2D2.getWidth() - rectangle2D.getWidth()) * d + rectangle2D.getWidth(), (rectangle2D2.getHeight() - rectangle2D.getHeight()) * d + rectangle2D.getHeight());
    }

    public static void resizeRect(Rectangle rectangle, Insets insets, boolean bl) {
        if (insets != null) {
            if (bl) {
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
            } else {
                rectangle.x -= insets.left;
                rectangle.y -= insets.top;
                rectangle.width += insets.left + insets.right;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    public static void cropRect(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            int n = rectangle.x;
            rectangle.x = rectangle.x + (insets.left >= 0 ? insets.left : rectangle.width + insets.left);
            if (rectangle.x < n) {
                rectangle.x = n;
            }
            int n2 = insets.right >= 0 ? rectangle.width - insets.right : -insets.right;
            rectangle.width = (n2 <= rectangle.width ? n2 : rectangle.width) + (n - rectangle.x);
            int n3 = rectangle.y;
            rectangle.y = rectangle.y + (insets.top >= 0 ? insets.top : rectangle.height + insets.top);
            if (rectangle.y < n3) {
                rectangle.y = n3;
            }
            n2 = insets.bottom >= 0 ? rectangle.height - insets.bottom : -insets.bottom;
            rectangle.height = (n2 <= rectangle.height ? n2 : rectangle.height) + (n3 - rectangle.y);
        }
    }

    public static final Rectangle getResizedRect(Rectangle rectangle, Insets insets, boolean bl) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        GfxUtil.resizeRect(rectangle2, insets, bl);
        return rectangle2;
    }

    public static final Rectangle getResizedRect(Rectangle rectangle, float f, float f2, float f3, float f4) {
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        if (f != 1.0f) {
            rectangle2.width = (int)((float)rectangle2.width * f);
            rectangle2.x += Math.round((float)(rectangle.width - rectangle2.width) * f3);
        }
        if (f2 != 1.0f) {
            rectangle2.height = (int)((float)rectangle2.height * f2);
            rectangle2.y += Math.round((float)(rectangle.height - rectangle2.height) * f4);
        }
        return rectangle2;
    }

    public static Rectangle getRect(Point point, Point point2) {
        int n = point.x < point2.x ? point.x : point2.x;
        int n2 = point.y < point2.y ? point.y : point2.y;
        int n3 = (point.x > point2.x ? point.x : point2.x) - n;
        int n4 = (point.y > point2.y ? point.y : point2.y) - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    public static final void reduceRectXXX(Rectangle2D rectangle2D, Number number, Number number2) {
        double d;
        if (number != null) {
            d = number instanceof Float || number instanceof Double ? rectangle2D.getWidth() * number.doubleValue() : (double)(number.intValue() << 1);
            rectangle2D.setRect(rectangle2D.getX() + d / 2.0, rectangle2D.getY(), rectangle2D.getWidth() - d, rectangle2D.getHeight());
        }
        if (number2 != null) {
            d = number2 instanceof Float || number instanceof Double ? rectangle2D.getHeight() * number2.doubleValue() : (double)(number2.intValue() << 1);
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + d / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight() - d);
        }
    }

    public static final int cutRectEdge(Rectangle rectangle, Rectangle rectangle2, int n) {
        switch (n) {
            case 0: {
                int n2 = 1;
                int n3 = rectangle.width * (rectangle.height - (rectangle2.y + rectangle2.height - rectangle.y));
                int n4 = rectangle.height * (rectangle.width - (rectangle2.x + rectangle2.width - rectangle.x));
                if (n4 > n3) {
                    n3 = n4;
                    n2 = 2;
                }
                if ((n4 = rectangle.width * (rectangle2.y - rectangle.y)) > n3) {
                    n3 = n4;
                    n2 = 3;
                }
                if ((n4 = rectangle.height * (rectangle2.x - rectangle.x)) > n3) {
                    n3 = n4;
                    n2 = 4;
                }
                if (n3 > 0) {
                    return GfxUtil.cutRectEdge(rectangle, rectangle2, n2);
                }
                rectangle.height = 0;
                rectangle.width = 0;
                return -1;
            }
            case 1: {
                int n5 = rectangle2.y + rectangle2.height - rectangle.y;
                rectangle.y += n5;
                rectangle.height -= n5;
                return rectangle.height > 0 ? 1 : -1;
            }
            case 2: {
                int n6 = rectangle2.x + rectangle2.width - rectangle.x;
                rectangle.x += n6;
                rectangle.width -= n6;
                return rectangle.width > 0 ? 2 : -1;
            }
            case 3: {
                rectangle.height = rectangle2.y - rectangle.y;
                return rectangle.height > 0 ? 3 : -1;
            }
            case 4: {
                rectangle.width = rectangle2.x - rectangle.x;
                return rectangle.width > 0 ? 4 : -1;
            }
        }
        throw new IllegalArgumentException("Illegal side: " + n);
    }

    public static int cutRect(Rectangle rectangle, List list, int n) {
        ListIterator listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            if (!rectangle.intersects(rectangle2) || GfxUtil.cutRectEdge(rectangle, rectangle2, n) != -1) continue;
            return -1;
        }
        return n;
    }

    public static final double getRelativeSizeXXX(Number number, double d) {
        if (number instanceof Integer) {
            return number.intValue();
        }
        if (number instanceof Long) {
            return (double)number.longValue() + d;
        }
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue() * d;
    }

    public static final float getConstrainedSize(AtRefNumber atRefNumber, AtRefNumber atRefNumber2, AtRefNumber atRefNumber3, float f) {
        float f2;
        float f3;
        float f4 = f3 = atRefNumber != null ? atRefNumber.getValue(f) : f;
        if (atRefNumber2 != null && f3 <= (f2 = atRefNumber2.getValue(f))) {
            return f2;
        }
        if (atRefNumber3 != null && f3 >= (f2 = atRefNumber3.getValue(f))) {
            return f2;
        }
        return f3;
    }

    public static final double getVectorAngle(double d, double d2, double d3) {
        double d4 = StrictMath.toDegrees(StrictMath.atan2(d2, d));
        if (d4 < 0.0) {
            d4 += 360.0;
        }
        if ((d4 = Math.abs(d3 - d4)) > 180.0) {
            d4 = 360.0 - d4;
        }
        return d4;
    }

    public static final double getAngleBetweenCords(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = Math.toDegrees(Math.atan2(d2, d));
        if (d6 < 0.0) {
            d6 += 360.0;
        }
        if ((d5 = Math.toDegrees(Math.atan2(d4, d3))) < 0.0) {
            d5 += 360.0;
        }
        if ((d6 = Math.abs(d5 - d6)) > 180.0) {
            d6 = 360.0 - d6;
        }
        return d6;
    }

    public static double getCrossDouble(double d, double d2, double d3) {
        return (d2 - d) * d3 + d;
    }

    public static float getCrossFloat(float f, float f2, float f3) {
        return (f2 - f) * f3 + f;
    }

    public static TexturePaint getCrossTexturePaint(TexturePaint texturePaint, TexturePaint texturePaint2, float f, int n, boolean bl) {
        BufferedImage bufferedImage = texturePaint != null ? texturePaint.getImage() : null;
        BufferedImage bufferedImage2 = texturePaint2 != null ? texturePaint2.getImage() : null;
        BufferedImage bufferedImage3 = bufferedImage == bufferedImage2 ? bufferedImage : GfxUtil.getCrossImage(bufferedImage, bufferedImage2, null, n, f, bl);
        Rectangle2D rectangle2D = texturePaint != null ? texturePaint.getAnchorRect() : texturePaint2.getAnchorRect();
        Rectangle2D rectangle2D2 = texturePaint2 != null ? texturePaint2.getAnchorRect() : texturePaint.getAnchorRect();
        Rectangle2D rectangle2D3 = GfxUtil.getCrossedRect2D(rectangle2D, rectangle2D2, f);
        return new TexturePaint(bufferedImage3, rectangle2D3);
    }

    public static BufferedImage getCrossImage(Image image, Image image2, BufferedImage bufferedImage, int n, float f, boolean bl) {
        int n2;
        int n3;
        if (bufferedImage == null) {
            n3 = Math.max(image != null ? image.getWidth(null) : 0, image2 != null ? image2.getWidth(null) : 0);
            n2 = Math.max(image != null ? image.getHeight(null) : 0, image2 != null ? image2.getHeight(null) : 0);
            bufferedImage = GfxUtil.getDefaultConfiguration().createCompatibleImage(n3, n2, n);
        } else {
            n3 = bufferedImage.getWidth();
            n2 = bufferedImage.getHeight();
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if ((double)f < 0.99999) {
            if (image != null) {
                if (bl) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - f));
                }
                graphics2D.drawImage(image, n3 - image.getWidth(null) >> 1, n2 - image.getHeight(null) >> 1, null);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        if ((double)f > 1.0E-5 && image2 != null) {
            graphics2D.drawImage(image2, n3 - image2.getWidth(null) >> 1, n2 - image2.getHeight(null) >> 1, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getImageFromString(String string, Integer n) {
        return GfxUtil.getImageFromString(string, null, n);
    }

    public static BufferedImage getImageFromString(String string, StringBuffer stringBuffer, Integer n) {
        int n2;
        String[] stringArray;
        if (string == null || string.trim().length() == 0) {
            if (stringBuffer != null) {
                stringBuffer.append("No Image to Load!");
            }
            return null;
        }
        BufferedImage bufferedImage = null;
        long l = System.currentTimeMillis();
        if (string.indexOf(44) != -1) {
            stringArray = string.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        String[] stringArray3 = stringArray;
        for (n2 = 0; bufferedImage == null && n2 < stringArray3.length; ++n2) {
            String string2 = stringArray3[n2].trim();
            if (string2.length() == 0) continue;
            try {
                Object object;
                if (IOUtil.isProbableBase64(string2)) {
                    object = Base64.decode(string2);
                    if (object != null) {
                        bufferedImage = ImageIO.read(new ByteArrayInputStream((byte[])object));
                    }
                    if (stringBuffer == null) continue;
                    stringBuffer.append("Base64: ");
                    continue;
                }
                if (IOUtil.isProbableURL(string2)) {
                    bufferedImage = ImageIO.read(new URL(string2));
                    if (stringBuffer == null) continue;
                    stringBuffer.append("URL: ").append(string2).append(" - ");
                    continue;
                }
                object = GfxUtil.class.getResource(string2);
                if (object == null) {
                    if (stringBuffer != null) {
                        stringBuffer.append("File: ");
                    }
                    bufferedImage = ImageIO.read(new File(string2));
                } else {
                    if (stringBuffer != null) {
                        stringBuffer.append("Resource: ");
                    }
                    bufferedImage = ImageIO.read((URL)object);
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(string2).append(" - ");
                continue;
            }
            catch (IOException iOException) {
                if (stringBuffer == null) continue;
                stringBuffer.append(" - ").append(iOException.getLocalizedMessage()).append('\n');
            }
        }
        if (bufferedImage != null) {
            n2 = n != null ? n : GfxUtil.getTransparency(bufferedImage);
            bufferedImage = GfxUtil.getBufferedImage(bufferedImage, n2);
        }
        if (stringBuffer != null) {
            stringBuffer.append(bufferedImage != null ? "OK" : "Failed");
            stringBuffer.append("\nLoading took " + (System.currentTimeMillis() - l) + " milliseconds.");
            stringBuffer.append("\nEstimated transparency: ").append(GfxUtil.getTransparency(bufferedImage));
        }
        return bufferedImage;
    }

    public static synchronized boolean waitForImage(Image image, long l) throws IOException {
        GfxUtil.l.addImage(image, 0);
        try {
            GfxUtil.l.waitForID(0, l > 0L ? l : 1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (GfxUtil.l.isErrorID(0)) {
            GfxUtil.l.removeImage(image, 0);
            throw new IOException("Image loading error.");
        }
        boolean bl = GfxUtil.l.checkID(0);
        GfxUtil.l.removeImage(image, 0);
        return bl;
    }

    public static String imageToBase64(Image image, String string) {
        if (!(image instanceof RenderedImage)) {
            image = GfxUtil.getBufferedImage(image, 1);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)((Object)image), string, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return Base64.encodeToString(byteArrayOutputStream.toByteArray(), false);
    }

    public static BufferedImage getBufferedImage(Object object, int n) {
        if (object instanceof Image) {
            return GfxUtil.getBufferedImage((Image)object, n);
        }
        if (object instanceof Icon) {
            return GfxUtil.getBufferedImage((Icon)object, n);
        }
        return null;
    }

    public static BufferedImage getBufferedImage(Image image, int n) {
        if (image instanceof BufferedImage && ((BufferedImage)image).getColorModel().getTransparency() == n) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = GfxUtil.getDefaultConfiguration().createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(Icon icon, int n) {
        if (icon instanceof XtdImage && ((XtdImage)icon).getTransparency() == n) {
            return ((XtdImage)icon).getBufferedImage();
        }
        BufferedImage bufferedImage = GfxUtil.getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static VolatileImage getVolatileImage(Image image) {
        if (image instanceof VolatileImage) {
            return (VolatileImage)image;
        }
        VolatileImage volatileImage = GfxUtil.getDefaultConfiguration().createCompatibleVolatileImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = volatileImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return volatileImage;
    }

    public static int getTransparency(Object object) {
        return GfxUtil.getTransparency(object, 1);
    }

    public static int getTransparency(Object object, int n) {
        if (object instanceof Transparency) {
            return ((Transparency)object).getTransparency();
        }
        ColorModel colorModel = object instanceof RenderedImage ? ((RenderedImage)object).getColorModel() : null;
        return colorModel != null ? colorModel.getTransparency() : n;
    }

    public static void repaintAllFrames() {
        try {
            Frame[] frameArray = Frame.getFrames();
            for (int i = 0; i < frameArray.length; ++i) {
                frameArray[i].repaint();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static float[] RGBtoHSL(int n, int n2, int n3) {
        float[] fArray = new float[3];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = n >= n2 ? (float)n : (float)n2;
        f4 = f4 >= (float)n3 ? f4 : (float)n3;
        float f5 = n < n2 ? (float)n : (float)n2;
        f3 = (f4 + (f5 = f5 < (float)n3 ? f5 : (float)n3)) / 2.0f / 255.0f;
        if (f3 == 0.0f) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            return fArray;
        }
        f2 = f4 - f5;
        if (f2 > 0.0f) {
            f2 = f3 <= 0.5f ? (f2 /= f4 + f5) : (f2 /= 510.0f - f4 - f5);
        } else {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = f3;
            return fArray;
        }
        f = (float)n == f4 ? ((float)n2 == f5 ? 5.0f + (f4 - (float)n3) / (f4 - f5) : 1.0f - (f4 - (float)n2) / (f4 - f5)) : ((float)n2 == f4 ? ((float)n3 == f5 ? 1.0f + (f4 - (float)n) / (f4 - f5) : 3.0f - (f4 - (float)n3) / (f4 - f5)) : ((float)n == f5 ? 3.0f + (f4 - (float)n2) / (f4 - f5) : 5.0f - (f4 - (float)n) / (f4 - f5)));
        fArray[0] = f / 6.0f;
        fArray[1] = f2;
        fArray[2] = f3;
        return fArray;
    }

    public static int HSLtoRGB(float f, float f2, float f3) {
        float f4;
        float f5 = f4 = (double)f3 <= 0.5 ? f3 * (1.0f + f2) : f3 + f2 - f3 * f2;
        if (f4 <= 0.0f) {
            return -16777216;
        }
        float f6 = 2.0f * f3 - f4;
        float f7 = (f4 - f6) / f4;
        if ((f *= 6.0f) == 6.0f) {
            f = 0.0f;
        }
        int n = (int)f;
        float f8 = f - (float)n;
        float f9 = f4 * f7 * f8;
        float f10 = f6 + f9;
        float f11 = f4 - f9;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        switch (n) {
            case 0: {
                f12 = f4;
                f13 = f10;
                f14 = f6;
                break;
            }
            case 1: {
                f12 = f11;
                f13 = f4;
                f14 = f6;
                break;
            }
            case 2: {
                f12 = f6;
                f13 = f4;
                f14 = f10;
                break;
            }
            case 3: {
                f12 = f6;
                f13 = f11;
                f14 = f4;
                break;
            }
            case 4: {
                f12 = f10;
                f13 = f6;
                f14 = f4;
                break;
            }
            case 5: {
                f12 = f4;
                f13 = f6;
                f14 = f11;
            }
        }
        return 0xFF000000 | (int)(255.0f * f12) << 16 & 0xFF0000 | (int)(255.0f * f13) << 8 & 0xFF00 | (int)(255.0f * f14) & 0xFF;
    }

    static {
        try {
            if (MigUtil.isAtLeastJRE6()) {
                Object v;
                for (int i = 0; i < e.length; ++i) {
                    GfxUtil.d[i + 4] = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_" + e[i]).get(null);
                }
                Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (map != null && (v = map.get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
                    GfxUtil.d[9] = v;
                    b = (RenderingHints.Key)RenderingHints.class.getField("KEY_TEXT_LCD_CONTRAST").get(null);
                    c = map.get(b);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        f = null;
        g = null;
        h = null;
        i = Pattern.compile("\n");
        j = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(new BufferedImage(1, 1, 2));
        k = BreakIterator.getWordInstance();
        l = new MediaTracker(new Container());
    }
}

