/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtEnd;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class ShapeGradientPaint
implements Paint,
Serializable {
    public static final int MODE_ANGLE = 0;
    public static final int MODE_COORD = 1;
    private transient int a;
    private transient float b = 0.0f;
    private transient float c = 1.0f;
    private transient float d = 0.5f;
    private transient AtRefRangeNumber e;
    private transient AtRefRangeNumber f;
    private transient AtRefRangeNumber g;
    private transient AtRefRangeNumber h;
    private transient boolean i = false;
    private final transient Color j;
    private final transient Color k;
    private transient float l;
    private transient float m;
    private transient float n;
    private transient float o;
    private transient GradientPaint p = null;
    private transient Rectangle2D q = null;
    private final transient int r;
    private static final long serialVersionUID = 1L;

    public ShapeGradientPaint(Color color, Color color2, float f, float f2, float f3, boolean bl) {
        this.j = color;
        this.k = color2;
        this.b = f;
        this.c = f2;
        this.d = f3;
        this.i = bl;
        this.r = color.getAlpha() == 255 && color2.getAlpha() == 255 ? 1 : 3;
        this.a = 0;
    }

    public ShapeGradientPaint(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, Color color, AtRefRangeNumber atRefRangeNumber3, AtRefRangeNumber atRefRangeNumber4, Color color2, boolean bl) {
        this.e = atRefRangeNumber != null ? atRefRangeNumber : AtStart.START0;
        this.f = atRefRangeNumber2 != null ? atRefRangeNumber2 : AtStart.START0;
        this.j = color;
        this.g = atRefRangeNumber3 != null ? atRefRangeNumber3 : AtEnd.END0;
        this.h = atRefRangeNumber4 != null ? atRefRangeNumber4 : AtEnd.END0;
        this.k = color2;
        this.i = bl;
        this.r = color.getAlpha() == 255 && color2.getAlpha() == 255 ? 1 : 3;
        this.a = 1;
    }

    public ShapeGradientPaint(Color color, float f, float f2, boolean bl) {
        this(color, f, f2, 1.0f, 0.5f, bl);
    }

    public ShapeGradientPaint(Color color, float f, float f2, float f3, float f4, boolean bl) {
        this(color, GfxUtil.tintColor(color, f), f2, f3, f4, bl);
    }

    public ShapeGradientPaint(Color color, Color color2, float f, boolean bl) {
        this(color, color2, f, 1.0f, 0.5f, bl);
    }

    public void scaleToBounds(Rectangle rectangle) {
        this.p = this.a == 0 ? this.scaleToBoundsAngleMode(rectangle) : this.scaleToBoundsCoordMode(rectangle);
    }

    protected GradientPaint scaleToBoundsAngleMode(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        float f = this.b % 360.0f;
        boolean bl = f <= 90.0f || f > 270.0f;
        boolean bl2 = f < 180.0f;
        double d = GfxUtil.getVectorAngle(bl ? rectangle.width : -rectangle.width, bl2 ? rectangle.height : -rectangle.height, f);
        double d2 = Math.sqrt(rectangle.width * rectangle.width + rectangle.height * rectangle.height) / 2.0;
        double d3 = this.c <= 1.0f ? Math.cos(StrictMath.toRadians(d)) * d2 * (double)this.c : (double)((this.c - 1.0f) / 2.0f);
        double d4 = Math.toRadians(f);
        this.l = (float)(-(Math.cos(d4) * d3));
        this.m = (float)(-(-Math.sin(d4) * d3));
        this.n = -this.l;
        this.o = -this.m;
        double d5 = (float)rectangle.width * this.d + (float)rectangle.x;
        double d6 = (float)rectangle.height * this.d + (float)rectangle.y;
        this.l = (float)((double)this.l + d5);
        this.m = (float)((double)this.m + d6);
        this.n = (float)((double)this.n + d5);
        this.o = (float)((double)this.o + d6);
        return new GradientPaint(this.l, this.m, this.j, this.n, this.o, this.k, this.i);
    }

    protected GradientPaint scaleToBoundsCoordMode(Rectangle rectangle) {
        float f = (float)rectangle.getX();
        float f2 = (float)rectangle.getMaxX() - 1.0f;
        this.l = this.e.getValue(f, f2);
        this.n = this.g.getValue(f, f2);
        f = (float)rectangle.getY();
        f2 = (float)rectangle.getMaxY() - 1.0f;
        this.m = this.f.getValue(f, f2);
        this.o = this.h.getValue(f, f2);
        return new GradientPaint(this.l, this.m, this.j, this.n, this.o, this.k, this.i);
    }

    public Point2D getPoint1() {
        return new Point2D.Float(this.l, this.m);
    }

    public Point2D getPoint2() {
        return new Point2D.Float(this.n, this.o);
    }

    public Color getColor1() {
        return this.j;
    }

    public Color getColor2() {
        return this.k;
    }

    public float getAngle() {
        return this.b;
    }

    public float getLength() {
        return this.c;
    }

    public float getAlignment() {
        return this.d;
    }

    public AtRefRangeNumber getX1() {
        return this.e;
    }

    public AtRefRangeNumber getY1() {
        return this.f;
    }

    public AtRefRangeNumber getX2() {
        return this.g;
    }

    public AtRefRangeNumber getY2() {
        return this.h;
    }

    public int getMode() {
        return this.a;
    }

    public boolean isCyclic() {
        return this.i;
    }

    @Override
    public int getTransparency() {
        return this.r;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.p == null || this.q == null || !this.q.equals(rectangle2D)) {
            this.scaleToBounds(GfxUtil.getRoundedRect(rectangle2D, true));
            this.q = (Rectangle2D)rectangle2D.clone();
        }
        return this.p.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ShapeGradientPaint)) {
            return false;
        }
        ShapeGradientPaint shapeGradientPaint = (ShapeGradientPaint)object;
        if (shapeGradientPaint.getMode() != this.getMode() || shapeGradientPaint.isCyclic() != this.isCyclic()) {
            return false;
        }
        if (shapeGradientPaint.getColor1().getRGB() != this.getColor1().getRGB() || shapeGradientPaint.getColor2().getRGB() != this.getColor2().getRGB()) {
            return false;
        }
        if (this.getMode() == 1) {
            return this.getX1().equals(shapeGradientPaint.getX1()) && this.getY1().equals(shapeGradientPaint.getY1()) && this.getX2().equals(shapeGradientPaint.getX2()) && this.getY2().equals(shapeGradientPaint.getY2());
        }
        return this.getAngle() == shapeGradientPaint.getAngle() && this.getAlignment() == shapeGradientPaint.getAlignment() && this.getLength() == shapeGradientPaint.getLength();
    }

    public String toString() {
        if (this.a == 0) {
            return this.getClass() + ": Angle mode. color1: " + this.j + ", color2: " + this.k + ", angle: " + this.b + ", align: " + this.d + ", length: " + this.c;
        }
        return this.getClass() + ": Coord mode. color1: " + this.j + ", color2: " + this.k + ", x1: " + this.e + ", y1: " + this.f + ", x2: " + this.g + ", y2: " + this.h;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == ShapeGradientPaint.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(ShapeGradientPaint.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                ShapeGradientPaint shapeGradientPaint = (ShapeGradientPaint)object;
                if (shapeGradientPaint.getMode() == 0) {
                    return new Expression(object, object.getClass(), "new", new Object[]{shapeGradientPaint.getColor1(), shapeGradientPaint.getColor2(), new Float(shapeGradientPaint.getAngle()), new Float(shapeGradientPaint.getLength()), new Float(shapeGradientPaint.getAlignment()), shapeGradientPaint.isCyclic()});
                }
                return new Expression(object, object.getClass(), "new", new Object[]{shapeGradientPaint.getX1() != AtStart.START0 ? shapeGradientPaint.getX1() : null, shapeGradientPaint.getY1() != AtStart.START0 ? shapeGradientPaint.getY1() : null, shapeGradientPaint.getColor1(), shapeGradientPaint.getX2() != AtEnd.END0 ? shapeGradientPaint.getX2() : null, shapeGradientPaint.getY2() != AtEnd.END0 ? shapeGradientPaint.getY2() : null, shapeGradientPaint.getColor2(), shapeGradientPaint.isCyclic()});
            }

            @Override
            protected boolean mutatesTo(Object object, Object object2) {
                return MigUtil.equals(object, object2);
            }
        });
    }
}

