/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.io.IOUtil;
import java.awt.Insets;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;

public class SliceSpec
implements Serializable {
    public static final boolean[] OPT_ALL = null;
    public static final boolean[] OPT_BOTTOM_RIGHT = new boolean[]{false, false, true, false, false, true, true, true, true};
    public static final boolean[] OPT_BOTTOM_LEFT = new boolean[]{true, false, false, true, false, false, true, true, true};
    public static final boolean[] OPT_TOP_RIGHT = new boolean[]{true, true, true, false, false, true, false, false, true};
    public static final boolean[] OPT_TOP_LEFT = new boolean[]{true, true, true, true, false, false, true, false, false};
    public static final boolean[] OPT_BORDER = new boolean[]{true, true, true, true, false, true, true, true, true};
    public static final int TYPE_TILE_SHRINK = 100;
    public static final int TYPE_TILE_CUT = 101;
    public static final int TYPE_STRETCH = 102;
    private final transient Insets a;
    private final transient int b;
    private final transient boolean[] c;
    private static final long serialVersionUID = 1L;

    public SliceSpec(Insets insets, int n) {
        this(insets, n, null);
    }

    public SliceSpec(Insets insets, int n, boolean[] blArray) {
        if (insets == null) {
            throw new IllegalArgumentException("sliceCuts is null!");
        }
        if (n < 100 || n > 102) {
            throw new IllegalArgumentException("illegal paintType: " + n);
        }
        if (blArray != null && blArray.length != 9) {
            throw new IllegalArgumentException("illegal pntOpt length (should be 9): " + blArray.length);
        }
        this.a = insets;
        this.b = n;
        this.c = blArray;
    }

    public boolean[] getPaintedSlices() {
        return this.c;
    }

    public Insets getSliceCuts() {
        return this.a;
    }

    public int getPaintType() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SliceSpec)) {
            return false;
        }
        SliceSpec sliceSpec = (SliceSpec)object;
        return this.b == sliceSpec.b && Arrays.equals(this.c, sliceSpec.c) && this.a.equals(sliceSpec.a);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == SliceSpec.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(SliceSpec.class, new DefaultPersistenceDelegate(new String[]{"sliceCuts", "paintType", "paintedSlices"}));
    }
}

