/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.ScaleableImage;
import com.miginfocom.util.gfx.SliceSpec;
import com.miginfocom.util.gfx.XtdImage;
import com.miginfocom.util.gfx.geometry.AbsRect;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.filters.SizeConstraint;
import com.miginfocom.util.gfx.geometry.numbers.AtEnd;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import com.miginfocom.util.io.IOUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class SlicedImage
extends ScaleableImage
implements Serializable {
    private final transient SliceSpec a;
    private transient XtdImage b = null;
    private transient int[] c = null;
    private transient int[] d = null;
    protected transient ImageSlice[] slices = null;
    private transient Dimension e = null;
    private transient int f = 3;
    private transient int g = -1;
    private transient int h = -1;
    private final transient Rectangle i = new Rectangle();
    private static final long serialVersionUID = 1L;

    public SlicedImage(SliceSpec sliceSpec) {
        this(sliceSpec, null);
    }

    public SlicedImage(SliceSpec sliceSpec, XtdImage xtdImage) {
        this.a = sliceSpec;
        this.setXtdImage(xtdImage);
    }

    @Override
    public void drawImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.slices == null) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        int[] nArray = this.getSliceDimSz(n3, this.c[0], this.c[2]);
        int[] nArray2 = this.getSliceDimSz(n4, this.d[0], this.d[2]);
        boolean[] blArray = nArray[1] > 1 && nArray2[1] > 1 ? this.a.getPaintedSlices() : SliceSpec.OPT_ALL;
        int n5 = 0;
        int n6 = 0;
        while (n5 < 3) {
            int n7 = 0;
            int n8 = 0;
            while (n7 < 3) {
                int n9 = n5 * 3 + n7;
                ImageSlice imageSlice = this.slices[n9];
                if (imageSlice != null && (blArray == null || blArray[n9])) {
                    this.i.x = n8 + n - 0;
                    this.i.y = n6 + n2 - 0;
                    this.i.width = nArray[n7];
                    this.i.height = nArray2[n5];
                    imageSlice.drawSlice(graphics2D, this.i, n7, n5);
                }
                n8 += nArray[n7++];
            }
            n6 += nArray2[n5++];
        }
        graphics2D.setPaint(paint);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.slices != null) {
            this.drawImage((Graphics2D)graphics, n, n2, this.getIconWidth(), this.getIconHeight());
        }
    }

    @Override
    public int getIconWidth() {
        return this.g;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    public void setXtdImage(XtdImage xtdImage) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = xtdImage != null ? xtdImage.getBufferedImage() : null;
        if (bufferedImage != null) {
            this.createSlices(bufferedImage);
        } else {
            this.slices = null;
            this.e = null;
            this.f = 3;
            this.h = -1;
            this.g = -1;
        }
        this.b = xtdImage;
    }

    public void flush() {
        this.b = null;
    }

    protected void createSlices(BufferedImage bufferedImage) {
        this.slices = new ImageSlice[9];
        GraphicsConfiguration graphicsConfiguration = GfxUtil.getDefaultConfiguration();
        Insets insets = this.a.getSliceCuts();
        int n = this.a.getPaintType();
        this.c = this.getSliceDimSz(bufferedImage.getWidth(), insets.left, insets.right);
        this.d = this.getSliceDimSz(bufferedImage.getHeight(), insets.top, insets.bottom);
        this.g = this.c[0] + this.c[1] + this.c[2];
        this.h = this.d[0] + this.d[1] + this.d[2];
        this.f = bufferedImage.getColorModel().getTransparency();
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.d[i] <= 0) continue;
            int n3 = 0;
            for (int j = 0; j < 3; ++j) {
                if (this.c[j] > 0) {
                    BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(this.c[j], this.d[i], this.f);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.drawImage(bufferedImage, 0, 0, this.c[j], this.d[i], n3, n2, n3 + this.c[j], n2 + this.d[i], null);
                    graphics2D.dispose();
                    this.slices[i * 3 + j] = new ImageSlice(new XtdImage(bufferedImage2, 1), n);
                }
                n3 += this.c[j];
            }
            n2 += this.d[i];
        }
        this.e = new Dimension(bufferedImage.getWidth() - insets.left - insets.right, bufferedImage.getHeight() - insets.top - insets.bottom);
    }

    protected int[] getSliceDimSz(int n, int n2, int n3) {
        if (n2 + n3 >= n) {
            int n4 = n >> 1;
            return new int[]{n - n4, 0, n4};
        }
        return new int[]{n2, n - n2 - n3, n3};
    }

    public Dimension getCenterSize() {
        return this.e;
    }

    public SliceSpec getSliceSpec() {
        return this.a;
    }

    public XtdImage getXtdImage() {
        return this.b;
    }

    @Override
    public int getTransparency() {
        return this.f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SlicedImage)) {
            return false;
        }
        SlicedImage slicedImage = (SlicedImage)object;
        return MigUtil.equals(slicedImage.getSliceSpec(), this.getSliceSpec()) && MigUtil.equals(slicedImage.getXtdImage(), this.getXtdImage());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == SlicedImage.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(SlicedImage.class, new DefaultPersistenceDelegate(new String[]{"sliceSpec", "xtdImage"}));
    }

    protected static class ImageSlice {
        private static final AtRefRangeNumber[] a = new AtRefRangeNumber[]{AtStart.START0, AtFraction.CENTER, AtEnd.END0};
        private static final PlaceRect[] b = new PlaceRect[9];
        private static final PlaceRect c;
        private final transient XtdImage d;
        private final transient int e;

        public ImageSlice(XtdImage xtdImage, int n) {
            this.d = xtdImage;
            this.e = n;
        }

        public void drawSlice(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
            if (this.e == 100) {
                this.d.drawImageTile(graphics2D, rectangle, c);
            } else if (this.e == 101) {
                this.d.drawImageTile(graphics2D, rectangle, b[n + n2 * 3]);
            } else {
                this.d.drawImage(graphics2D, rectangle);
            }
        }

        static {
            for (int i = 0; i < 9; ++i) {
                ImageSlice.b[i] = new AbsRect(a[i % 3], a[i / 3]);
            }
            c = new AbsRect(AtStart.START0, AtStart.START0, null, null, SizeConstraint.SIZE_MIN_MAX_START, SizeConstraint.SIZE_MIN_MAX_START, null);
        }
    }
}

