/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import javax.swing.border.AbstractBorder;

public class SoftLineBorder
extends AbstractBorder {
    protected final Color col;
    protected float perc;
    protected boolean trans;
    protected transient Color b1Col = null;
    protected transient Color b2Col = null;
    private static final long serialVersionUID = 1L;

    public SoftLineBorder(Color color, float f, boolean bl) {
        this.col = color;
        this.perc = f;
        this.trans = bl;
        if (color != null) {
            this.b1Col = GfxUtil.tintColor(color, f);
            if (!bl) {
                this.b2Col = GfxUtil.tintColor(color, f * 2.0f);
            }
        }
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.col);
        graphics.fillRect(n + 2, n2, n3 - 4, 1);
        graphics.fillRect(n + n3 - 1, n2 + 2, 1, n4 - 4);
        graphics.fillRect(n + 2, n2 + n4 - 1, n3 - 4, 1);
        graphics.fillRect(n, n2 + 2, 1, n4 - 4);
        graphics.setColor(this.b1Col);
        graphics.fillRect(n + n3 - 2, n2, 1, 1);
        graphics.fillRect(n + n3 - 1, n2 + 1, 1, 1);
        graphics.fillRect(n, n2 + n4 - 2, 1, 1);
        graphics.fillRect(n + 1, n2 + n4 - 1, 1, 1);
        graphics.fillRect(n + n3 - 1, n2 + n4 - 2, 1, 1);
        graphics.fillRect(n + n3 - 2, n2 + n4 - 1, 1, 1);
        graphics.fillRect(n + 1, n2, 1, 1);
        graphics.fillRect(n, n2 + 1, 1, 1);
        if (this.b2Col != null) {
            graphics.setColor(this.b2Col);
            graphics.fillRect(n + n3 - 1, n2, 1, 1);
            graphics.fillRect(n, n2 + n4 - 1, 1, 1);
            graphics.fillRect(n + n3 - 1, n2 + n4 - 1, 1, 1);
            graphics.fillRect(n, n2, 1, 1);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 1, 1);
    }

    public Color getColor() {
        return this.col;
    }

    @Override
    public boolean isBorderOpaque() {
        return !this.trans;
    }

    public float getTintPercent() {
        return this.perc;
    }

    public boolean isTransparentCorner() {
        return this.trans;
    }

    public boolean getTransparentCorner() {
        return this.trans;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SoftLineBorder)) {
            return false;
        }
        SoftLineBorder softLineBorder = (SoftLineBorder)object;
        return this.perc == softLineBorder.perc && this.trans == softLineBorder.trans && MigUtil.equals(this.col, softLineBorder.col);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == SoftLineBorder.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(SoftLineBorder.class, new DefaultPersistenceDelegate(new String[]{"color", "tintPercent", "transparentCorner"}));
    }
}

