/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.io.IOUtil;
import java.awt.Color;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class UIColor
extends Color {
    private final String a;
    private final Float b;
    private final Integer c;
    private static final long serialVersionUID = 1L;

    public UIColor(String string) {
        this(string, null, null);
    }

    public UIColor(String string, Float f, Integer n) {
        super(UIColor.decodeToRGBA(string, f, n), true);
        this.a = string;
        this.b = f;
        this.c = n;
    }

    public String getColorName() {
        return this.a;
    }

    public Float getTint() {
        return this.b;
    }

    public Integer getForcedAlpha() {
        return this.c;
    }

    public static int decodeToRGBA(String string, Float f, Integer n) {
        Color color = UIColor.decodeToColor(string);
        if (color == null) {
            return -16777216;
        }
        int n2 = (f != null ? GfxUtil.tintColor(color, f.floatValue()) : color).getRGB();
        if (n != null) {
            n2 &= 0xFFFFFF;
            n2 |= n << 24;
        }
        return n2;
    }

    public static final int decodeToRGBA(String string) {
        Color color = UIColor.decodeToColor(string);
        return color != null ? color.getRGB() : -16777216;
    }

    public static final Color decodeToColor(String string) {
        if (string == null) {
            throw new NullPointerException("colorName shouldn't be null!");
        }
        return UIManager.getColor(string);
    }

    public static final Color decodeToColor(String string, Float f, Integer n) {
        return new Color(UIColor.decodeToRGBA(string, f, n));
    }

    public static String[] getColorStrings() {
        ArrayList arrayList = new ArrayList(500);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Set set = uIDefaults.entrySet();
        for (Map.Entry entry : set) {
            if (!(entry.getValue() instanceof Color) || !(entry.getKey() instanceof String)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == UIColor.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(UIColor.class, new DefaultPersistenceDelegate(new String[]{"colorName", "tint", "forcedAlpha"}));
    }
}

