/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx;

import com.miginfocom.util.MRUSoftCacheMap;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.ScaleableImage;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.io.IOUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public class XtdImage
extends ScaleableImage
implements Serializable {
    public static final HashMap SCALE_QUALITY_HINT_MAP = new HashMap(8);
    public static final transient boolean produceReport = false;
    private transient StringBuffer a = null;
    private transient BufferedImage b = null;
    private transient int c = 1;
    private transient String d = null;
    private final transient Integer e;
    private final transient Integer f;
    private final transient int g;
    private transient MRUSoftCacheMap h = null;
    private transient Dimension i = null;
    private static final long serialVersionUID = 1L;

    public XtdImage(String string) {
        this(string, 0, null, null);
    }

    public XtdImage(String string, int n) {
        this(string, n, null, null);
    }

    public XtdImage(String string, int n, Integer n2) {
        this(string, n, n2, null);
    }

    public XtdImage(String string, int n, Integer n2, Integer n3) {
        this.a(n3);
        this.d = string;
        this.g = n;
        this.e = n2;
        this.f = n3;
        this.a();
    }

    public XtdImage(BufferedImage bufferedImage, int n) {
        this(bufferedImage, n, null, null);
    }

    public XtdImage(BufferedImage bufferedImage, int n, Integer n2) {
        this(bufferedImage, n, n2, null);
    }

    public XtdImage(BufferedImage bufferedImage, int n, Integer n2, Integer n3) {
        this.a(n3);
        this.b = bufferedImage;
        this.e = n2;
        this.f = n3;
        this.g = n;
        this.a();
    }

    private void a(Integer n) {
        if (n != null && !SCALE_QUALITY_HINT_MAP.containsKey(n)) {
            throw new IllegalArgumentException("Unknown Scale Quality: " + n);
        }
    }

    public BufferedImage getBufferedImage() {
        if (this.b == null && this.d != null) {
            this.a = null;
            this.b = GfxUtil.getImageFromString(this.d, this.a, this.e);
            this.a();
        }
        return this.b;
    }

    private void a() {
        if (this.b != null) {
            this.c = GfxUtil.getTransparency(this.b);
        } else if (this.e != null) {
            this.c = this.e;
        }
    }

    public String getImageContext() {
        if (this.d != null) {
            return this.d;
        }
        BufferedImage bufferedImage = this.getBufferedImage();
        if (bufferedImage != null) {
            this.d = GfxUtil.imageToBase64(bufferedImage, "png");
            return this.d;
        }
        return null;
    }

    public int getCacheScaledImages() {
        return this.g;
    }

    public Integer getForceTransparency() {
        return this.e;
    }

    public Integer getScaleQuality() {
        return this.f;
    }

    @Override
    public int getTransparency() {
        return this.c;
    }

    public StringBuffer getImageLoadReport() {
        return this.a;
    }

    public Dimension getSize() {
        BufferedImage bufferedImage = this.getBufferedImage();
        return bufferedImage != null ? new Dimension(this.getIconWidth(), this.getIconHeight()) : null;
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.getBufferedImage();
        if (bufferedImage2 == null || n == 0 || n2 == 0) {
            return null;
        }
        if (n == -1) {
            n = bufferedImage2.getWidth();
        }
        if (n2 == -1) {
            n2 = bufferedImage2.getHeight();
        }
        if (n == bufferedImage2.getWidth() && n2 == bufferedImage2.getHeight()) {
            return bufferedImage2;
        }
        Integer n4 = new Integer(n2 | n << 16);
        BufferedImage bufferedImage3 = bufferedImage = this.h != null ? (BufferedImage)this.h.get(n4) : null;
        if (bufferedImage == null) {
            if (this.g > 0 && this.h == null) {
                this.h = new MRUSoftCacheMap(this.g, true);
            }
            bufferedImage = GfxUtil.getDefaultConfiguration().createCompatibleImage(n, n2, this.c);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (this.f != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, SCALE_QUALITY_HINT_MAP.get(this.f));
            }
            graphics2D.drawImage(bufferedImage2, 0, 0, n, n2, null);
            graphics2D.dispose();
            if (this.h != null) {
                this.h.put(n4, bufferedImage);
            }
        }
        return bufferedImage;
    }

    @Override
    public void drawImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = (BufferedImage)this.getScaledInstance(n3, n4, 0);
        if (bufferedImage != null) {
            graphics2D.drawImage((Image)bufferedImage, n, n2, null);
        }
    }

    public void drawImage(Graphics2D graphics2D, Rectangle rectangle, PlaceRect placeRect) {
        this.drawImage(graphics2D, placeRect.getRect(rectangle, this.getSize()));
    }

    public void drawImageTile(Graphics2D graphics2D, Rectangle rectangle, PlaceRect placeRect) {
        int n;
        Rectangle rectangle2 = placeRect.getRect(rectangle, this.b());
        if (rectangle2.isEmpty()) {
            return;
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Rectangle rectangle3 = graphics2D.getClipBounds();
        if (rectangle3.isEmpty()) {
            graphics2D.setClip(shape);
            return;
        }
        int n2 = rectangle2.width;
        int n3 = rectangle2.height;
        int n4 = (rectangle2.x - rectangle.x) % n2;
        if (n4 > 0) {
            n4 -= n2;
        }
        if ((n = (rectangle2.y - rectangle.y) % n3) > 0) {
            n -= n3;
        }
        BufferedImage bufferedImage = (BufferedImage)this.getScaledInstance(n2, n3, 0);
        int n5 = rectangle.x + rectangle.width;
        for (int i = n4 + rectangle.x; i < n5; i += n2) {
            int n6 = rectangle.y + rectangle.height;
            for (int j = n + rectangle.y; j < n6; j += n3) {
                if (!rectangle3.intersects(i, j, n2, n3)) continue;
                graphics2D.drawImage((Image)bufferedImage, i, j, null);
            }
        }
        graphics2D.setClip(shape);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = this.getBufferedImage();
        Image image = this.getScaledInstance(-1, -1, 0);
        if (image != null) {
            graphics.drawImage(bufferedImage, n, n2, component);
        }
    }

    private final Dimension b() {
        if (this.i != null) {
            return this.i;
        }
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        if (n != -1 && n2 != -1) {
            this.i = new Dimension(n, n2);
        }
        return this.i;
    }

    @Override
    public int getIconWidth() {
        BufferedImage bufferedImage = this.getBufferedImage();
        return bufferedImage != null ? bufferedImage.getWidth() : -1;
    }

    @Override
    public int getIconHeight() {
        BufferedImage bufferedImage = this.getBufferedImage();
        return bufferedImage != null ? bufferedImage.getHeight() : -1;
    }

    public String toString() {
        return "BufferedImage: " + this.getBufferedImage() + "\nTrans: " + this.getTransparency() + "\nSize: " + this.getSize();
    }

    public void flush() {
        this.d = null;
        if (this.b != null) {
            this.b.flush();
        }
        if (this.h != null) {
            this.h.clear();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof XtdImage)) {
            return false;
        }
        XtdImage xtdImage = (XtdImage)object;
        return xtdImage.getCacheScaledImages() == this.getCacheScaledImages() && MigUtil.equals(xtdImage.getForceTransparency(), this.getForceTransparency()) && MigUtil.equals(xtdImage.getScaleQuality(), this.getScaleQuality()) && MigUtil.equals(xtdImage.getImageContext(), this.getImageContext());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == XtdImage.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        SCALE_QUALITY_HINT_MAP.put(new Integer(0), RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        SCALE_QUALITY_HINT_MAP.put(new Integer(1), RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        SCALE_QUALITY_HINT_MAP.put(new Integer(2), RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        IOUtil.setDelegate(XtdImage.class, new DefaultPersistenceDelegate(new String[]{"imageContext", "cacheScaledImages", "forceTransparency", "scaleQuality"}));
    }
}

