/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.Range;
import com.miginfocom.util.gfx.geometry.filters.SizeConstraint;
import com.miginfocom.util.gfx.geometry.numbers.AtEnd;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import com.miginfocom.util.io.IOUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public final class AbsRect
implements PlaceRect {
    private final transient AtRefRangeNumber a;
    private final transient AtRefRangeNumber b;
    private final transient AtRefRangeNumber c;
    private final transient AtRefRangeNumber d;
    private final transient SizeConstraint e;
    private final transient SizeConstraint f;
    private final transient Insets g;
    public static final AbsRect NULL = new AbsRect(AtFixed.FIXED0, AtFixed.FIXED0, null, null);
    public static final AbsRect FILL = new AbsRect(AtStart.START0, AtStart.START0, AtEnd.END0, AtEnd.END0, null);
    public static final AbsRect FILL_INSIDE = new AbsRect(AtStart.START1, AtStart.START1, AtEnd.END1, AtEnd.END1, null);
    public static final AbsRect FILL_UPPER_LEFT = new AbsRect(AtStart.START0, AtStart.START0, AtEnd.END1, AtEnd.END1, null);
    private static final long serialVersionUID = 1L;

    public AbsRect(int n, Number number) {
        this(n, number, null);
    }

    public AbsRect(int n, Number number, SizeConstraint sizeConstraint) {
        if (!(number instanceof Integer) && !(number instanceof Float)) {
            throw new IllegalArgumentException("Illegal size type: " + number);
        }
        switch (n) {
            case 1: {
                this.a = AtStart.START0;
                this.b = AtStart.START0;
                this.c = AtEnd.END0;
                this.d = number instanceof Integer ? new AtStart(number.floatValue()) : new AtFraction(number.floatValue());
                this.e = null;
                this.f = sizeConstraint != null ? sizeConstraint : SizeConstraint.SIZE_MIN_MAX_START;
                break;
            }
            case 2: {
                this.a = AtStart.START0;
                this.b = AtStart.START0;
                this.c = number instanceof Integer ? new AtStart(number.floatValue()) : new AtFraction(number.floatValue());
                this.d = AtEnd.END0;
                this.e = sizeConstraint != null ? sizeConstraint : SizeConstraint.SIZE_MIN_MAX_START;
                this.f = null;
                break;
            }
            case 3: {
                this.a = AtStart.START0;
                this.b = number instanceof Integer ? new AtEnd(-number.floatValue()) : new AtFraction(1.0f - number.floatValue());
                this.c = AtEnd.END0;
                this.d = AtEnd.END0;
                this.e = null;
                this.f = sizeConstraint != null ? sizeConstraint : SizeConstraint.SIZE_MIN_MAX_END;
                break;
            }
            case 4: {
                this.a = number instanceof Integer ? new AtEnd(-number.floatValue()) : new AtFraction(1.0f - number.floatValue());
                this.b = AtStart.START0;
                this.c = AtEnd.END0;
                this.d = AtEnd.END0;
                this.e = sizeConstraint != null ? sizeConstraint : SizeConstraint.SIZE_MIN_MAX_END;
                this.f = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal dockSide: " + n);
            }
        }
        this.g = null;
    }

    public AbsRect(int n) {
        this(new AtStart(n), new AtStart(n), new AtEnd(-n), new AtEnd(-n));
    }

    public AbsRect(Insets insets) {
        this(new AtStart(insets.left), new AtStart(insets.top), new AtEnd(-insets.right), new AtEnd(-insets.bottom));
    }

    public AbsRect(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2) {
        this(atRefRangeNumber, atRefRangeNumber2, null, null, null, null, null);
    }

    public AbsRect(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, AtRefRangeNumber atRefRangeNumber3, AtRefRangeNumber atRefRangeNumber4) {
        this(atRefRangeNumber, atRefRangeNumber2, atRefRangeNumber3, atRefRangeNumber4, null, null, null);
    }

    public AbsRect(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, AtRefRangeNumber atRefRangeNumber3, AtRefRangeNumber atRefRangeNumber4, Insets insets) {
        this(atRefRangeNumber, atRefRangeNumber2, atRefRangeNumber3, atRefRangeNumber4, null, null, insets);
    }

    public AbsRect(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, AtRefRangeNumber atRefRangeNumber3, AtRefRangeNumber atRefRangeNumber4, SizeConstraint sizeConstraint, SizeConstraint sizeConstraint2, Insets insets) {
        this.a = atRefRangeNumber;
        this.b = atRefRangeNumber2;
        this.c = atRefRangeNumber3;
        this.d = atRefRangeNumber4;
        this.e = sizeConstraint;
        this.f = sizeConstraint2;
        this.g = insets != null ? new Insets(insets.top, insets.left, insets.bottom, insets.right) : null;
    }

    @Override
    public Rectangle getRect(Rectangle rectangle) {
        return this.getRect(rectangle, null);
    }

    @Override
    public Rectangle getRect(Rectangle rectangle, Dimension dimension) {
        int n;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = dimension != null ? dimension.width : rectangle.width;
        int n5 = n = dimension != null ? dimension.height : rectangle.height;
        if (this.a != null) {
            n2 = this.a.getIntValue(n2, n2 + rectangle.width);
        }
        if (this.b != null) {
            n3 = this.b.getIntValue(n3, n3 + rectangle.height);
        }
        if (this.c != null) {
            if (this.a != null) {
                n4 = this.c.getIntValue(rectangle.x, rectangle.x + rectangle.width) - n2;
            } else {
                n2 = rectangle.x + rectangle.width - n4;
            }
        }
        if (this.d != null) {
            if (this.b != null) {
                n = this.d.getIntValue(rectangle.y, rectangle.y + rectangle.height) - n3;
            } else {
                n3 = rectangle.y + rectangle.height - n;
            }
        }
        Rectangle rectangle2 = new Rectangle(n2, n3, n4, n);
        if (this.g != null) {
            GfxUtil.resizeRect(rectangle2, this.g, false);
        }
        if (this.e != null) {
            this.e.constrain(Range.wrap(rectangle2, 0), rectangle.width);
        }
        if (this.f != null) {
            this.f.constrain(Range.wrap(rectangle2, 1), rectangle.height);
        }
        return rectangle2;
    }

    public AbsRect derive(Insets insets) {
        Insets insets2 = this.g != null && insets != null ? new Insets(this.g.top + insets.top, this.g.left + insets.left, this.g.bottom + insets.bottom, this.g.right + insets.right) : (insets != null ? insets : this.g);
        return new AbsRect(this.a, this.b, this.c, this.d, this.e, this.f, insets2);
    }

    public Insets getResize() {
        return this.g != null ? new Insets(this.g.top, this.g.left, this.g.bottom, this.g.right) : null;
    }

    public AtRefRangeNumber getX1() {
        return this.a;
    }

    public AtRefRangeNumber getY1() {
        return this.b;
    }

    public AtRefRangeNumber getX2() {
        return this.c;
    }

    public AtRefRangeNumber getY2() {
        return this.d;
    }

    public SizeConstraint getHorizontalSizeConstraint() {
        return this.e;
    }

    public SizeConstraint getVerticalSizeConstraint() {
        return this.f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != AbsRect.class) {
            return false;
        }
        AbsRect absRect = (AbsRect)object;
        return MigUtil.equals(this.a, absRect.a) && MigUtil.equals(this.b, absRect.b) && MigUtil.equals(this.c, absRect.c) && MigUtil.equals(this.d, absRect.d) && MigUtil.equals(this.e, absRect.e) && MigUtil.equals(this.f, absRect.f) && MigUtil.equals(this.g, absRect.g);
    }

    public String toString() {
        return "x1: " + this.a + ", y1: " + this.b + ", x2: " + this.c + ", y2: " + this.d + "\nInsets: " + this.g;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AbsRect.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AbsRect.class, new DefaultPersistenceDelegate(new String[]{"x1", "y1", "x2", "y2", "horizontalSizeConstraint", "verticalSizeConstraint", "resize"}));
    }
}

