/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.GfxUtil;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public final class AlignRect
implements PlaceRect {
    private final transient AtRefRangeNumber a;
    private final transient AtRefRangeNumber b;
    private final transient Insets c;
    private static final long serialVersionUID = 1L;

    public AlignRect(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2) {
        this(atRefRangeNumber, atRefRangeNumber2, null);
    }

    public AlignRect(AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2, Insets insets) {
        if (atRefRangeNumber == null || atRefRangeNumber2 == null) {
            throw new IllegalArgumentException("xAlign or yAlign is null!");
        }
        this.a = atRefRangeNumber;
        this.b = atRefRangeNumber2;
        this.c = insets;
    }

    @Override
    public Rectangle getRect(Rectangle rectangle) {
        return rectangle;
    }

    @Override
    public Rectangle getRect(Rectangle rectangle, Dimension dimension) {
        if (dimension == null) {
            return rectangle;
        }
        int n = this.a.getIntValue(rectangle.x, rectangle.x + rectangle.width - dimension.width);
        int n2 = this.b.getIntValue(rectangle.y, rectangle.y + rectangle.height - dimension.height);
        Rectangle rectangle2 = new Rectangle(n, n2, dimension.width, dimension.height);
        if (this.c != null) {
            GfxUtil.resizeRect(rectangle2, this.c, false);
        }
        return rectangle2;
    }

    public AtRefRangeNumber getXAlign() {
        return this.a;
    }

    public AtRefRangeNumber getYAlign() {
        return this.b;
    }

    public Insets getResize() {
        return this.c != null ? new Insets(this.c.top, this.c.left, this.c.bottom, this.c.right) : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != AlignRect.class) {
            return false;
        }
        AlignRect alignRect = (AlignRect)object;
        return MigUtil.equals(this.a, alignRect.a) && MigUtil.equals(this.b, alignRect.b) && MigUtil.equals(this.c, alignRect.c);
    }

    public String toString() {
        return "xAlign: " + this.a + ", yAlign: " + this.b + "\nInsets: " + this.c;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AlignRect.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AlignRect.class, new DefaultPersistenceDelegate(new String[]{"xAlign", "yAlign", "resize"}));
    }
}

