/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.PlaceRect;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class AspectRatioRect
implements PlaceRect {
    public static final int MODE_SIZE = 2000;
    public static final int MODE_DIMENSION = 2001;
    private final transient PlaceRect a;
    private final transient float b;
    private final transient float c;
    private final transient float d;
    private final transient int e;
    private final transient AtRefRangeNumber f;
    private final transient AtRefRangeNumber g;
    private static final long serialVersionUID = 1L;

    public AspectRatioRect(float f) {
        this(null, f, f, 0.0f, 2000, null, null);
    }

    public AspectRatioRect(PlaceRect placeRect, float f, float f2, int n) {
        this(placeRect, f, f, f2, n, null, null);
    }

    public AspectRatioRect(PlaceRect placeRect, float f, float f2, float f3, int n, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2) {
        this.a = placeRect;
        this.b = f;
        this.c = f2;
        this.d = f3;
        this.e = n;
        this.f = atRefRangeNumber;
        this.g = atRefRangeNumber2;
    }

    protected void correctAspectRatio(Rectangle rectangle) {
        float f;
        int n = rectangle.width;
        int n2 = rectangle.height;
        float f2 = (float)n / (float)n2;
        if (f2 < this.b) {
            f = this.b;
        } else if (f2 > this.c) {
            f = this.c;
        } else {
            return;
        }
        float f3 = this.e == 2001 || f > f2 ? this.d : 1.0f - this.d;
        float f4 = (float)n / f;
        f4 += ((float)n2 - f4) * f3;
        rectangle.height = (int)(f4 + 0.5f);
        rectangle.width = (int)(f * f4 + 0.5f);
        rectangle.x = rectangle.x + (this.f == null ? n - rectangle.width >> 1 : this.f.getIntValue(0.0f, n - rectangle.width));
        rectangle.y = rectangle.y + (this.g == null ? n2 - rectangle.height >> 1 : this.g.getIntValue(0.0f, n2 - rectangle.height));
    }

    @Override
    public Rectangle getRect(Rectangle rectangle) {
        rectangle = this.a != null ? this.a.getRect(rectangle) : new Rectangle(rectangle);
        this.correctAspectRatio(rectangle);
        return rectangle;
    }

    @Override
    public Rectangle getRect(Rectangle rectangle, Dimension dimension) {
        rectangle = this.a != null ? this.a.getRect(rectangle, dimension) : new Rectangle(rectangle);
        this.correctAspectRatio(rectangle);
        return rectangle;
    }

    public PlaceRect getPlaceRect() {
        return this.a;
    }

    public float getMinAspectRatio() {
        return this.b;
    }

    public float getMaxAspectRatio() {
        return this.c;
    }

    public float getPercent() {
        return this.d;
    }

    public int getMode() {
        return this.e;
    }

    public AtRefRangeNumber getAlignmentX() {
        return this.f;
    }

    public AtRefRangeNumber getAlignmentY() {
        return this.g;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != AspectRatioRect.class) {
            return false;
        }
        AspectRatioRect aspectRatioRect = (AspectRatioRect)object;
        return this.b == aspectRatioRect.b && this.c == aspectRatioRect.c && this.d == aspectRatioRect.d && this.e == aspectRatioRect.e && MigUtil.equals(this.f, aspectRatioRect.f) && MigUtil.equals(this.g, aspectRatioRect.g) && MigUtil.equals(this.a, aspectRatioRect.a);
    }

    public String toString() {
        return "minAR: " + this.b + ", maxAR: " + this.c + ", perc " + this.d + ", mode: " + this.e + ", alignX: " + this.f + ", alignY: " + this.g + "\nplaceRect: " + this.a;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AspectRatioRect.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AspectRatioRect.class, new DefaultPersistenceDelegate(new String[]{"placeRect", "minAspectRatio", "maxAspectRatio", "percent", "mode", "alignmentX", "alignmentY"}));
    }
}

