/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.RefPoint;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class AtPoint
implements Serializable {
    private final transient RefPoint a;
    private final transient RefPoint b;
    private final transient AtNumber c;
    private final transient AtNumber d;
    private static final long serialVersionUID = 1L;

    public AtPoint(float f, float f2) {
        this(new AtFixed(f), new AtFixed(f2), null, null);
    }

    public AtPoint(float f, float f2, float f3, float f4, float f5, float f6) {
        this(new AtFixed(f), new AtFixed(f2), f3, f4, f5, f6);
    }

    public AtPoint(AtNumber atNumber, AtNumber atNumber2, float f, float f2, float f3, float f4) {
        this(atNumber, atNumber2, f != 0.0f || f2 != 0.0f ? new RefPoint(f, f2) : null, f3 != 0.0f || f4 != 0.0f ? new RefPoint(f3, f4) : null);
    }

    public AtPoint(AtNumber atNumber, AtNumber atNumber2) {
        this(atNumber, atNumber2, null, null);
    }

    public AtPoint(AtNumber atNumber, AtNumber atNumber2, RefPoint refPoint, RefPoint refPoint2) {
        if (atNumber == null || atNumber2 == null) {
            throw new IllegalArgumentException("x or y is null. x = " + atNumber + ", y = " + atNumber2);
        }
        this.c = atNumber;
        this.d = atNumber2;
        this.a = refPoint;
        this.b = refPoint2;
    }

    public final void calculate(float[] fArray) {
        float f = this.c.getValue();
        float f2 = this.d.getValue();
        fArray[0] = f;
        fArray[1] = f2;
        if (this.a != null) {
            fArray[2] = this.a.getX(f);
            fArray[3] = this.a.getY(f2);
        }
        if (this.b != null) {
            fArray[4] = this.b.getX(f);
            fArray[5] = this.b.getY(f2);
        }
    }

    public final boolean hasInCtrlPoint() {
        return this.a != null;
    }

    public final boolean hasOutCtrlPoint() {
        return this.b != null;
    }

    public final RefPoint getInCtrlPoint() {
        return this.a;
    }

    public final RefPoint getOutCtrlPoint() {
        return this.b;
    }

    public final AtNumber getXNumber() {
        return this.c;
    }

    public final AtNumber getYNumber() {
        return this.d;
    }

    public String toString() {
        return "x: [" + this.getXNumber() + "]\ny: [" + this.getYNumber() + "]\ninCtrlPoint: [" + this.getInCtrlPoint() + "]\noutCtrlPoint: [" + this.getOutCtrlPoint() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AtPoint)) {
            return false;
        }
        AtPoint atPoint = (AtPoint)object;
        return this.getXNumber().equals(atPoint.getXNumber()) && this.getYNumber().equals(atPoint.getYNumber()) && MigUtil.equals(this.getInCtrlPoint(), atPoint.getInCtrlPoint()) && MigUtil.equals(this.getOutCtrlPoint(), atPoint.getOutCtrlPoint());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AtPoint.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AtPoint.class, new DefaultPersistenceDelegate(new String[]{"xNumber", "yNumber", "inCtrlPoint", "outCtrlPoint"}));
    }
}

