/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry;

import com.miginfocom.util.io.IOUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Range
implements Serializable {
    private transient float a;
    private transient float b;
    private static final long serialVersionUID = 1L;

    public Range() {
        this(0.0f, 0.0f);
    }

    public Range(float f, float f2) {
        this.a = f;
        this.b = f2;
    }

    public float getStart() {
        return this.a;
    }

    public void setStart(float f) {
        this.a = f;
    }

    public float getEnd() {
        return this.b;
    }

    public void setEnd(float f) {
        this.b = f;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Range)) {
            return false;
        }
        return ((Range)object).getStart() == this.getStart() && ((Range)object).getEnd() == this.getEnd();
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == Range.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    public static Range wrap(Rectangle rectangle, int n) {
        return new RectRange(rectangle, n == 0);
    }

    public static final class RectRange
    extends Range {
        private final Rectangle a;
        private final boolean b;
        private static final long serialVersionUID = 1L;

        public RectRange() {
            this.a = new Rectangle();
            this.b = false;
        }

        private RectRange(Rectangle rectangle, boolean bl) {
            this.a = rectangle;
            this.b = bl;
        }

        @Override
        public final float getStart() {
            return this.b ? (float)this.a.x : (float)this.a.y;
        }

        @Override
        public final void setStart(float f) {
            if (this.b) {
                this.a.x = (int)f;
            } else {
                this.a.y = (int)f;
            }
        }

        @Override
        public final float getEnd() {
            return this.b ? (float)(this.a.x + this.a.width) : (float)(this.a.y + this.a.height);
        }

        @Override
        public final void setEnd(float f) {
            if (this.b) {
                this.a.width = (int)f - this.a.x;
            } else {
                this.a.height = (int)f - this.a.y;
            }
        }
    }
}

