/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry;

import com.miginfocom.util.gfx.geometry.numbers.AtOffset;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class RefPoint
implements Serializable {
    private final transient AtRefNumber a;
    private final transient AtRefNumber b;
    private static final long serialVersionUID = 1L;

    public RefPoint(float f, float f2) {
        this(new AtOffset(f), new AtOffset(f2));
    }

    public RefPoint(AtRefNumber atRefNumber, AtRefNumber atRefNumber2) {
        if (atRefNumber == null || atRefNumber2 == null) {
            throw new IllegalArgumentException("Argument null! x: " + atRefNumber + ", y: " + atRefNumber2);
        }
        this.a = atRefNumber;
        this.b = atRefNumber2;
    }

    public AtRefNumber getXNumber() {
        return this.a;
    }

    public AtRefNumber getYNumber() {
        return this.b;
    }

    public float getX(float f) {
        return this.a.getValue(f);
    }

    public float getY(float f) {
        return this.b.getValue(f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RefPoint)) {
            return false;
        }
        RefPoint refPoint = (RefPoint)object;
        return this.a.equals(refPoint.a) && this.b.equals(refPoint.b);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == RefPoint.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(RefPoint.class, new DefaultPersistenceDelegate(new String[]{"xNumber", "yNumber"}));
    }
}

