/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry.filters;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class RefRangeOperFilter
implements AtRefRangeNumber {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int PERCENT = 6;
    public static final int SET = 7;
    protected final transient int oper;
    protected final transient float auxValue;
    protected final transient AtRefRangeNumber constr;
    protected final transient AtRefRangeNumber wrap;
    private static final long serialVersionUID = 1L;

    public RefRangeOperFilter(AtRefRangeNumber atRefRangeNumber, int n, AtRefRangeNumber atRefRangeNumber2) {
        this(atRefRangeNumber, n, atRefRangeNumber2, 0.0f);
    }

    public RefRangeOperFilter(AtRefRangeNumber atRefRangeNumber, int n, AtRefRangeNumber atRefRangeNumber2, float f) {
        if (atRefRangeNumber2 == null) {
            throw new IllegalArgumentException("constr is null! wrap: " + atRefRangeNumber + ", constr: " + atRefRangeNumber2);
        }
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Unknown oper argument: " + n);
        }
        this.wrap = atRefRangeNumber;
        this.oper = n;
        this.constr = atRefRangeNumber2;
        this.auxValue = f;
    }

    public final AtRefRangeNumber getRefRangeConstraint() {
        return this.constr;
    }

    public final AtRefRangeNumber getRefRangeWrapped() {
        return this.wrap;
    }

    public final int getOperation() {
        return this.oper;
    }

    public final float getAuxValue() {
        return this.auxValue;
    }

    @Override
    public float getValue(float f, float f2) {
        float f3 = this.wrap.getValue(f, f2);
        float f4 = this.constr.getValue(f, f2);
        return this.constrainByType(f3, f4);
    }

    @Override
    public final int getIntValue(float f, float f2) {
        return (int)(this.getValue(f, f2) + 0.5f);
    }

    public float filter(float f, float f2, float f3) {
        float f4 = this.wrap instanceof RefRangeOperFilter ? ((RefRangeOperFilter)this.wrap).filter(f, f2, f3) : f;
        float f5 = this.constr.getValue(f2, f3);
        return this.constrainByType(f4, f5);
    }

    protected float constrainByType(float f, float f2) {
        switch (this.oper) {
            case 0: {
                return f + f2;
            }
            case 1: {
                return f - f2;
            }
            case 2: {
                return f * f2;
            }
            case 3: {
                return f / f2;
            }
            case 4: {
                return f >= f2 ? f : f2;
            }
            case 5: {
                return f <= f2 ? f : f2;
            }
            case 6: {
                return f + (f - f2) * this.auxValue;
            }
            case 7: {
                return f;
            }
        }
        throw new IllegalArgumentException("Unknown operation: " + this.oper);
    }

    public RefRangeOperFilter derive(AtRefRangeNumber atRefRangeNumber) {
        if (this.wrap instanceof RefRangeOperFilter) {
            atRefRangeNumber = ((RefRangeOperFilter)this.wrap).derive(atRefRangeNumber);
        }
        return new RefRangeOperFilter(atRefRangeNumber, this.oper, this.constr, this.auxValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RefRangeOperFilter)) {
            return false;
        }
        RefRangeOperFilter refRangeOperFilter = (RefRangeOperFilter)object;
        return refRangeOperFilter.auxValue == this.auxValue && refRangeOperFilter.oper == this.oper && MigUtil.equals(refRangeOperFilter.constr, this.constr) && MigUtil.equals(refRangeOperFilter.wrap, this.wrap);
    }

    public String toString() {
        return MigUtil.getSimpleClassName(this.getClass()) + "  wrap: " + this.wrap + ", type: " + this.oper + ", constr: " + this.constr + ", auxValue: " + this.auxValue;
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == RefRangeOperFilter.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(RefRangeOperFilter.class, new DefaultPersistenceDelegate(new String[]{"refRangeWrapped", "operation", "refRangeConstraint", "auxValue"}));
    }
}

