/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry.filters;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.Range;
import com.miginfocom.util.gfx.geometry.filters.RefOperFilter;
import com.miginfocom.util.gfx.geometry.numbers.AtFixed;
import com.miginfocom.util.gfx.geometry.numbers.AtFraction;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class SizeConstraint
implements Serializable {
    public static final SizeConstraint SIZE_MIN_MAX_START = new SizeConstraint(AtFixed.FIXED0, AtFraction.END, 0.0f);
    public static final SizeConstraint SIZE_MIN_MAX_END = new SizeConstraint(AtFixed.FIXED0, AtFraction.END, 1.0f);
    private final transient RefOperFilter a;
    private final transient float b;
    private static final long serialVersionUID = 1L;

    public SizeConstraint(AtRefNumber atRefNumber, AtRefNumber atRefNumber2, float f) {
        if (atRefNumber == null || atRefNumber2 == null) {
            throw new IllegalArgumentException("argument null!");
        }
        RefOperFilter refOperFilter = new RefOperFilter(null, 4, atRefNumber);
        this.a = new RefOperFilter(refOperFilter, 5, atRefNumber2);
        this.b = f;
    }

    public SizeConstraint(RefOperFilter refOperFilter, float f) {
        if (refOperFilter == null) {
            throw new IllegalArgumentException("constr is null!");
        }
        this.a = refOperFilter;
        this.b = f;
    }

    public void constrain(Range range, float f) {
        float f2 = range.getStart();
        float f3 = range.getEnd() - f2;
        float f4 = this.a.filter(f3, f);
        if (f4 != f3) {
            range.setStart(f2 += (f3 - f4) * this.b);
            range.setEnd(f2 + f4);
        }
    }

    public final RefOperFilter getConstraint() {
        return this.a;
    }

    public final float getSizeAlign() {
        return this.b;
    }

    public String toString() {
        return "SizeConstraint:  constr: " + this.a + ", sizeAlign: " + this.b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SizeConstraint)) {
            return false;
        }
        SizeConstraint sizeConstraint = (SizeConstraint)object;
        return sizeConstraint.b == this.b && MigUtil.equals(sizeConstraint.a, this.a);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == SizeConstraint.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(SizeConstraint.class, new DefaultPersistenceDelegate(new String[]{"constraint", "sizeAlign"}));
    }
}

