/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry.links;

import com.miginfocom.ashape.shapes.AShape;
import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.links.BoundsLinkNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class AShapeLinkNumber
extends BoundsLinkNumber {
    private final transient AShape a;
    private final transient boolean b;
    private static final long serialVersionUID = 1L;

    public AShapeLinkNumber(AShape aShape, AtRefRangeNumber atRefRangeNumber, int n, boolean bl) {
        super(atRefRangeNumber, n);
        if (aShape == null) {
            throw new IllegalArgumentException("aShape null!");
        }
        this.a = aShape;
        this.b = bl;
    }

    @Override
    protected float getHorizontalValue(AtRefRangeNumber atRefRangeNumber) {
        Rectangle rectangle = this.b ? this.a.getReferenceBounds() : this.a.getShapeBounds();
        int n = rectangle.x;
        return atRefRangeNumber.getValue(n, n + rectangle.width);
    }

    @Override
    protected float getVerticalValue(AtRefRangeNumber atRefRangeNumber) {
        Rectangle rectangle = this.b ? this.a.getReferenceBounds() : this.a.getShapeBounds();
        int n = rectangle.y;
        return atRefRangeNumber.getValue(n, n + rectangle.height);
    }

    public AShape getAShape() {
        return this.a;
    }

    public boolean getToRefBounds() {
        return this.b;
    }

    @Override
    public String toString() {
        return MigUtil.getSimpleClassName(this.getClass()) + " align: " + this.getAlign() + ", dimension: " + this.getDimension() + "\naShape: " + this.getAShape();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AShapeLinkNumber) || !super.equals(object)) {
            return false;
        }
        AShapeLinkNumber aShapeLinkNumber = (AShapeLinkNumber)object;
        return this.getDimension() == aShapeLinkNumber.getDimension() && MigUtil.equals(this.getAlign(), aShapeLinkNumber.getAlign());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AShapeLinkNumber.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AShapeLinkNumber.class, new DefaultPersistenceDelegate(new String[]{"aShape", "align", "dimension", "toRefBounds"}));
    }
}

