/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry.links;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public abstract class BoundsLinkNumber
implements AtNumber {
    public static final int X = 0;
    public static final int Y = 1;
    protected final transient AtRefRangeNumber align;
    protected final transient int dim;
    private static final long serialVersionUID = 1L;

    protected BoundsLinkNumber(AtRefRangeNumber atRefRangeNumber, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal dim: " + n);
        }
        this.align = atRefRangeNumber;
        this.dim = n;
    }

    protected abstract float getHorizontalValue(AtRefRangeNumber var1);

    protected abstract float getVerticalValue(AtRefRangeNumber var1);

    @Override
    public final float getValue() {
        return this.dim == 0 ? this.getHorizontalValue(this.align) : this.getVerticalValue(this.align);
    }

    @Override
    public final float getValue(float f) {
        return this.getValue();
    }

    @Override
    public final float getValue(float f, float f2) {
        return this.getValue();
    }

    @Override
    public final int getIntValue() {
        return (int)(this.getValue() + 0.5f);
    }

    @Override
    public final int getIntValue(float f) {
        return this.getIntValue();
    }

    @Override
    public final int getIntValue(float f, float f2) {
        return this.getIntValue();
    }

    public AtRefRangeNumber getAlign() {
        return this.align;
    }

    public int getDimension() {
        return this.dim;
    }

    public String toString() {
        return MigUtil.getSimpleClassName(this.getClass()) + ", align: " + this.align + ", dim: " + this.dim;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BoundsLinkNumber)) {
            return false;
        }
        BoundsLinkNumber boundsLinkNumber = (BoundsLinkNumber)object;
        return this.getDimension() == boundsLinkNumber.getDimension() && MigUtil.equals(this.getAlign(), boundsLinkNumber.getAlign());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == BoundsLinkNumber.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(BoundsLinkNumber.class, new DefaultPersistenceDelegate(new String[]{"align", "dimension"}));
    }
}

