/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry.links;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.links.BoundsLinkNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.io.IOUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class ShapeLinkNumber
extends BoundsLinkNumber {
    private final transient Shape a;
    private static final long serialVersionUID = 1L;

    public ShapeLinkNumber(Shape shape, AtRefRangeNumber atRefRangeNumber, int n) {
        super(atRefRangeNumber, n);
        if (shape == null) {
            throw new IllegalArgumentException("Shape null!");
        }
        this.a = shape;
    }

    @Override
    protected float getHorizontalValue(AtRefRangeNumber atRefRangeNumber) {
        Rectangle rectangle = this.a.getBounds();
        int n = rectangle.x;
        return atRefRangeNumber.getValue(n, n + rectangle.width);
    }

    @Override
    protected float getVerticalValue(AtRefRangeNumber atRefRangeNumber) {
        Rectangle rectangle = this.a.getBounds();
        int n = rectangle.y;
        return atRefRangeNumber.getValue(n, n + rectangle.height);
    }

    public Shape getShape() {
        return this.a;
    }

    @Override
    public String toString() {
        return MigUtil.getSimpleClassName(this.getClass()) + " align: " + this.getAlign() + ", dimension: " + this.getDimension() + "\nshape: " + this.getShape();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ShapeLinkNumber) || !super.equals(object)) {
            return false;
        }
        ShapeLinkNumber shapeLinkNumber = (ShapeLinkNumber)object;
        return this.getDimension() == shapeLinkNumber.getDimension() && MigUtil.equals(this.getAlign(), shapeLinkNumber.getAlign());
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == ShapeLinkNumber.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(ShapeLinkNumber.class, new DefaultPersistenceDelegate(new String[]{"shape", "align", "dimension"}));
    }
}

