/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.gfx.geometry.numbers;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtRefNumber;
import com.miginfocom.util.io.IOUtil;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public final class AtFraction
implements AtRefNumber {
    public static final AtFraction START = new AtFraction(0.0f);
    public static final AtFraction CENTER = new AtFraction(0.5f);
    public static final AtFraction END = new AtFraction(1.0f);
    private final transient float a;
    private static final long serialVersionUID = 1L;

    public AtFraction(float f) {
        this.a = f;
    }

    @Override
    public float getValue(float f) {
        return f * this.a;
    }

    @Override
    public int getIntValue(float f) {
        return (int)(f * this.a + 0.5f);
    }

    @Override
    public final float getValue(float f, float f2) {
        return f + (f2 - f) * this.a;
    }

    @Override
    public final int getIntValue(float f, float f2) {
        return (int)(f + (f2 - f) * this.a + 0.5f);
    }

    public final float getFraction() {
        return this.a;
    }

    public String toString() {
        return MigUtil.getSimpleClassName(this.getClass()) + " fraction: " + this.getFraction();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AtFraction)) {
            return false;
        }
        return ((AtFraction)object).getFraction() == this.getFraction();
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == AtFraction.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(AtFraction.class, new DefaultPersistenceDelegate(new String[]{"fraction"}));
    }
}

