/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.io;

import com.miginfocom.util.Base64;
import com.miginfocom.util.MigUtil;
import java.awt.BasicStroke;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.Beans;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.border.MatteBorder;

public class IOUtil {
    private static final Map a = new HashMap(2);
    private static final IdentityHashMap b = new IdentityHashMap();
    private static final ByteArrayOutputStream c = new ByteArrayOutputStream(16384);
    private static byte[] d = new byte[16384];
    private static final String[] e = new String[]{"moveTo", "lineTo", "quadTo", "curveTo", "closePath"};
    private static final int[] f = new int[]{2, 2, 4, 6, 0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSerializedObject(Object object, Object object2) {
        IdentityHashMap identityHashMap = b;
        synchronized (identityHashMap) {
            b.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSerializedObject(Object object) {
        IdentityHashMap identityHashMap = b;
        synchronized (identityHashMap) {
            return b.remove(object);
        }
    }

    public static boolean isProbableBase64(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n > 400) {
            return true;
        }
        return n > 100 && Base64.isBase64Compliant(string);
    }

    public static boolean isProbableURL(String string) {
        if (string.length() < 6) {
            return false;
        }
        return (string = string.substring(0, 5).trim().toLowerCase()).startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") || string.startsWith("sftp:") || string.startsWith("file:");
    }

    public static boolean isZippedStream(InputStream inputStream, boolean bl) throws IOException {
        if (!inputStream.markSupported()) {
            return bl;
        }
        inputStream.mark(4);
        byte[] byArray = new byte[4];
        int n = 0;
        n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        if (n < 4) {
            return false;
        }
        return byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static BufferedInputStream bufferInputStream(InputStream inputStream, int n) {
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
    }

    public static BufferedOutputStream bufferOutputStream(OutputStream outputStream, int n) {
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
    }

    public static ZipInputStream getZipEntryStream(InputStream inputStream, String string) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string)) continue;
            return zipInputStream;
        }
        return null;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readByteArray(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.toByteArray(fileInputStream);
            fileInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            fileInputStream.close();
            throw iOException;
        }
    }

    public static void writeXMLObject(OutputStream outputStream, Object object) {
        IOUtil.writeXMLObject(outputStream, object, new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    public static void writeXMLObject(OutputStream outputStream, Object object, ExceptionListener exceptionListener) {
        ClassLoader classLoader = null;
        Thread thread = Thread.currentThread();
        try {
            classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(IOUtil.class.getClassLoader());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        XMLEncoder xMLEncoder = new XMLEncoder(outputStream);
        if (exceptionListener != null) {
            xMLEncoder.setExceptionListener(exceptionListener);
        }
        IOUtil.addDelegates(xMLEncoder);
        xMLEncoder.writeObject(object);
        xMLEncoder.close();
        if (classLoader != null) {
            thread.setContextClassLoader(classLoader);
        }
    }

    public static synchronized void writeAsXML(ObjectOutput objectOutput, Object object) throws IOException {
        c.reset();
        IOUtil.writeXMLObject(c, object);
        byte[] byArray = c.toByteArray();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public static synchronized Object readAsXML(ObjectInput objectInput) throws IOException {
        ClassLoader classLoader = null;
        Thread thread = Thread.currentThread();
        try {
            classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(IOUtil.class.getClassLoader());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Object object = null;
        try {
            int n = objectInput.readInt();
            if (n > d.length) {
                d = new byte[n];
            }
            objectInput.readFully(d, 0, n);
            object = new XMLDecoder(new ByteArrayInputStream(d, 0, n)).readObject();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (classLoader != null) {
            thread.setContextClassLoader(classLoader);
        }
        return object;
    }

    public static void addPersistanceDelegates(XMLEncoder xMLEncoder) {
        IOUtil.addDelegates(xMLEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDelegates(XMLEncoder xMLEncoder) {
        IOUtil.c();
        Map map = a;
        synchronized (map) {
            for (Map.Entry entry : a.entrySet()) {
                Class clazz = (Class)entry.getKey();
                PersistenceDelegate persistenceDelegate = (PersistenceDelegate)entry.getValue();
                if (clazz == null || persistenceDelegate == null) continue;
                xMLEncoder.setPersistenceDelegate(clazz, persistenceDelegate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getDelegates() {
        IOUtil.c();
        Map map = a;
        synchronized (map) {
            return new HashMap(a);
        }
    }

    public static void registerDelegatesGlobally() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistenceDelegate getDelegate(Class clazz) {
        IOUtil.c();
        Map map = a;
        synchronized (map) {
            return (PersistenceDelegate)a.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDelegate(Class clazz, PersistenceDelegate persistenceDelegate) {
        IOUtil.c();
        Map map = a;
        synchronized (map) {
            a.put(clazz, persistenceDelegate);
        }
        if (Beans.isDesignTime()) {
            try {
                Introspector.getBeanInfo(clazz).getBeanDescriptor().setValue("persistenceDelegate", persistenceDelegate);
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void c() {
        HashMap<Class, PersistenceDelegate> hashMap = a;
        synchronized (hashMap) {
            if (a.size() > 0) {
                return;
            }
        }
        hashMap = new HashMap<Class, PersistenceDelegate>(256);
        hashMap.put(Polygon.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                Polygon polygon = (Polygon)object;
                return new Expression(object, object.getClass(), "new", new Object[]{polygon.xpoints, polygon.ypoints, new Integer(polygon.npoints)});
            }
        });
        if (!MigUtil.isAtLeastJRE6()) {
            hashMap.put(Locale.class, new DefaultPersistenceDelegate(new String[]{"language", "country", "variant"}));
            hashMap.put(BasicStroke.class, new DefaultPersistenceDelegate(new String[]{"lineWidth", "endCap", "lineJoin", "miterLimit", "dashArray", "dashPhase"}));
            hashMap.put(MatteBorder.class, new PersistenceDelegate(){

                @Override
                protected Expression instantiate(Object object, Encoder encoder) {
                    MatteBorder matteBorder = (MatteBorder)object;
                    if (matteBorder.getTileIcon() != null) {
                        return new Expression(object, object.getClass(), "new", new Object[]{matteBorder.getBorderInsets(), matteBorder.getTileIcon()});
                    }
                    return new Expression(object, object.getClass(), "new", new Object[]{matteBorder.getBorderInsets(), matteBorder.getMatteColor()});
                }
            });
            hashMap.put(Insets.class, new PersistenceDelegate(){

                @Override
                protected Expression instantiate(Object object, Encoder encoder) {
                    Insets insets = (Insets)object;
                    return new Expression(object, object.getClass(), "new", new Object[]{new Integer(insets.top), new Integer(insets.left), new Integer(insets.bottom), new Integer(insets.right)});
                }
            });
        }
        hashMap.put(Rectangle2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x", "y", "width", "height"}));
        hashMap.put(Rectangle2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                Rectangle2D.Float float_ = (Rectangle2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX()), new Float(float_.getY()), new Float(float_.getWidth()), new Float(float_.getHeight())});
            }
        });
        hashMap.put(Line2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x1", "y1", "x2", "y2"}));
        hashMap.put(Line2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                Line2D.Float float_ = (Line2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX1()), new Float(float_.getY1()), new Float(float_.getX2()), new Float(float_.getY2())});
            }
        });
        hashMap.put(CubicCurve2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x1", "y1", "ctrlX1", "ctrlY1", "ctrlX2", "ctrlY2", "x2", "y2"}));
        hashMap.put(CubicCurve2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                CubicCurve2D.Float float_ = (CubicCurve2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX1()), new Float(float_.getY1()), new Float(float_.getCtrlX1()), new Float(float_.getCtrlY1()), new Float(float_.getCtrlX2()), new Float(float_.getCtrlY2()), new Float(float_.getX2()), new Float(float_.getY2())});
            }
        });
        hashMap.put(QuadCurve2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x1", "y1", "ctrlx", "ctrly", "x2", "y2"}));
        hashMap.put(QuadCurve2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                QuadCurve2D.Float float_ = (QuadCurve2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX1()), new Float(float_.getY1()), new Float(float_.getCtrlX()), new Float(float_.getCtrlY()), new Float(float_.getX2()), new Float(float_.getY2())});
            }
        });
        hashMap.put(Arc2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x", "y", "width", "height", "angleAtart", "angleExtent", "arcType"}));
        hashMap.put(Arc2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                Arc2D.Float float_ = (Arc2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX()), new Float(float_.getY()), new Float(float_.getWidth()), new Float(float_.getHeight()), new Float(float_.getAngleStart()), new Float(float_.getAngleExtent()), new Integer(float_.getArcType())});
            }
        });
        hashMap.put(Ellipse2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x", "y", "width", "height"}));
        hashMap.put(Ellipse2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                Ellipse2D.Float float_ = (Ellipse2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX()), new Float(float_.getY()), new Float(float_.getWidth()), new Float(float_.getHeight())});
            }
        });
        hashMap.put(RoundRectangle2D.Double.class, new DefaultPersistenceDelegate(new String[]{"x", "y", "width", "height", "arcWidth", "arcHeight"}));
        hashMap.put(RoundRectangle2D.Float.class, new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                RoundRectangle2D.Float float_ = (RoundRectangle2D.Float)object;
                return new Expression(object, object.getClass(), "new", new Object[]{new Float(float_.getX()), new Float(float_.getY()), new Float(float_.getWidth()), new Float(float_.getHeight()), new Float(float_.getArcWidth()), new Float(float_.getArcHeight())});
            }
        });
        hashMap.put(GeneralPath.class, new DefaultPersistenceDelegate(){

            protected void initialize(Class clazz, Object object, Object object2, Encoder encoder) {
                super.initialize(clazz, object, object2, encoder);
                encoder.writeStatement(new Statement(object, "setWindingRule", new Object[]{new Integer(((GeneralPath)object).getWindingRule())}));
                float[] fArray = new float[6];
                PathIterator pathIterator = ((GeneralPath)object).getPathIterator(new AffineTransform());
                while (!pathIterator.isDone()) {
                    int n = pathIterator.currentSegment(fArray);
                    Object[] objectArray = new Float[f[n]];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = new Float(fArray[i]);
                    }
                    encoder.writeStatement(new Statement(object, e[n], objectArray));
                    pathIterator.next();
                }
            }
        });
        Map map = a;
        synchronized (map) {
            a.putAll(hashMap);
        }
    }
}

