/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.print;

import com.miginfocom.calendar.datearea.DateAreaContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class PrintUtil {
    private PrintUtil() {
    }

    public static Dimension getPageCount(Integer n, Integer n2, double d, double d2) {
        if (n2 == null && n == null) {
            if (d > d2) {
                return new Dimension((int)Math.ceil(d / d2), 1);
            }
            return new Dimension(1, (int)Math.ceil(d2 / d));
        }
        if (n2 == null) {
            int n3 = n;
            return new Dimension(n3, (int)Math.ceil(d2 / d * (double)n3));
        }
        if (n == null) {
            int n4 = n2;
            return new Dimension((int)Math.ceil(d / d2 * (double)n4), n4);
        }
        return new Dimension(n, n2);
    }

    public static void printComponent(Graphics2D graphics2D, JComponent jComponent, Dimension dimension) {
        Component[] componentArray = jComponent.getComponents();
        Insets insets = jComponent.getInsets();
        DateAreaContainer dateAreaContainer = jComponent instanceof DateAreaContainer ? (DateAreaContainer)jComponent : null;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component;
            Component component2 = componentArray[i];
            if (component2 instanceof JScrollBar) continue;
            Insets insets2 = new Insets(0, 0, 0, 0);
            Border border = null;
            while (component2 instanceof JScrollPane) {
                component = (JScrollPane)component2;
                insets2 = ((JComponent)component).getInsets();
                border = ((JComponent)component).getBorder();
                component2 = ((JScrollPane)component).getViewport().getView();
                if (dateAreaContainer == null) continue;
                if (dateAreaContainer.isSouthOfDateArea(component2)) {
                    insets2.top += dimension.height - component2.getHeight() - PrintUtil.a(component2).getY();
                }
                if (!dateAreaContainer.isEastOfDateArea(component2)) continue;
                insets2.left += dimension.width - component2.getWidth() - PrintUtil.a(component2).getX();
            }
            component = PrintUtil.a(component2);
            Rectangle rectangle = component.getBounds();
            graphics2D.translate(rectangle.x + insets2.left, rectangle.y + insets2.top);
            component2.printAll(graphics2D);
            graphics2D.translate(-insets2.left, -insets2.top);
            if (border != null) {
                PrintUtil.a(border, graphics2D, component2, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            }
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
        PrintUtil.a(jComponent.getBorder(), graphics2D, jComponent, dimension.width, dimension.height);
    }

    private static void a(Border border, Graphics2D graphics2D, Component component, int n, int n2) {
        if (border != null) {
            if (border instanceof LineBorder) {
                graphics2D.translate(0.5, 0.5);
            }
            border.paintBorder(component, graphics2D, 0, 0, n, n2);
            if (border instanceof LineBorder) {
                graphics2D.translate(-0.5, -0.5);
            }
        }
    }

    private static Component a(Component component) {
        Container container = SwingUtilities.getAncestorOfClass(JScrollPane.class, component);
        return container != null ? container : component;
    }
}

