/*
 * Decompiled with CFR 0.152.
 */
package com.miginfocom.util.repetition;

import com.miginfocom.util.MigUtil;
import com.miginfocom.util.gfx.geometry.numbers.AtRefRangeNumber;
import com.miginfocom.util.gfx.geometry.numbers.AtStart;
import com.miginfocom.util.io.IOUtil;
import com.miginfocom.util.repetition.Repetition;
import java.beans.DefaultPersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;

public class DefaultRepetition
implements Repetition {
    public static final int INTERVAL_ONCE = Integer.MAX_VALUE;
    public static final int OFFSET_LAST = Integer.MAX_VALUE;
    private final transient int a;
    private final transient int b;
    private final transient AtRefRangeNumber c;
    private final transient AtRefRangeNumber d;
    private static final long serialVersionUID = 1L;

    public DefaultRepetition() {
        this(0, 1, null, null);
    }

    public DefaultRepetition(int n, int n2) {
        this(n, n2, null, null);
    }

    public DefaultRepetition(int n, int n2, int n3) {
        this(n, n3, new AtStart(n), n2 >= n ? new AtStart(n2) : null);
    }

    public DefaultRepetition(int n, int n2, AtRefRangeNumber atRefRangeNumber, AtRefRangeNumber atRefRangeNumber2) {
        this.a = n;
        this.b = n2;
        this.c = atRefRangeNumber;
        this.d = atRefRangeNumber2;
    }

    @Override
    public boolean appliesTo(int n, int n2) {
        if (this.c != null && (float)n < this.c.getValue(0.0f, n2)) {
            return false;
        }
        if (this.d != null && (float)n > this.d.getValue(0.0f, n2)) {
            return false;
        }
        if (this.a == Integer.MAX_VALUE) {
            return n == n2 - 1;
        }
        if (this.b == Integer.MAX_VALUE) {
            return n == this.a;
        }
        return (n + this.a) % this.b == 0;
    }

    public int getOffset() {
        return this.a;
    }

    public int getInterval() {
        return this.b;
    }

    public AtRefRangeNumber getStartIndex() {
        return this.c;
    }

    public AtRefRangeNumber getEndIndex() {
        return this.d;
    }

    public String toString() {
        return "Start at: " + this.a + " and repeat every: " + this.b + (this.c != null ? ", startIndex: " + this.c : "") + (this.d != null ? ", endIndex: " + this.d : "");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Repetition)) {
            return false;
        }
        DefaultRepetition defaultRepetition = (DefaultRepetition)object;
        return this.a == defaultRepetition.a && this.b == defaultRepetition.b && MigUtil.equals(this.d, defaultRepetition.d) && MigUtil.equals(this.c, defaultRepetition.c);
    }

    private Object readResolve() throws ObjectStreamException {
        return IOUtil.getSerializedObject(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass() == DefaultRepetition.class) {
            IOUtil.writeAsXML(objectOutputStream, this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IOUtil.setSerializedObject(this, IOUtil.readAsXML(objectInputStream));
    }

    static {
        IOUtil.setDelegate(DefaultRepetition.class, new DefaultPersistenceDelegate(new String[]{"offset", "interval", "startIndex", "endIndex"}));
    }
}

