/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.inputoutput.filefilter;

import java.io.File;
import org.arakhne.afc.inputoutput.filefilter.FileFilter;
import org.arakhne.afc.vmutil.FileSystem;

public abstract class AbstractFileFilter
implements FileFilter {
    private final boolean acceptDirectories;
    private final String description;
    private final String[] extensions;

    public AbstractFileFilter(boolean acceptDirectories1, String description1, String ... extensions1) {
        this.acceptDirectories = acceptDirectories1;
        this.extensions = extensions1;
        StringBuilder b = new StringBuilder();
        b.append(description1);
        b.append(" (");
        for (int i = 0; i < this.extensions.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append("*");
            if (!this.extensions[i].startsWith(".")) {
                b.append(".");
            }
            b.append(this.extensions[i]);
        }
        b.append(")");
        this.description = b.toString();
    }

    @Override
    public final boolean accept(File file) {
        if (file.isDirectory()) {
            return this.acceptDirectories;
        }
        for (String ext : this.extensions) {
            if (!FileSystem.hasExtension((File)file, (String)ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String[] getExtensions() {
        return this.extensions;
    }
}

