/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.inputoutput.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.arakhne.afc.inputoutput.filefilter.FileFilter;

public class MultiFileFilter
implements FileFilter {
    private final boolean acceptDirectories;
    private final FileFilter[] filters;
    private final String description;

    public MultiFileFilter(String description, FileFilter ... filters) {
        this(true, description, filters);
    }

    public MultiFileFilter(boolean acceptDirectories1, String description, FileFilter ... filters) {
        this.acceptDirectories = acceptDirectories1;
        this.filters = filters;
        this.description = description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.acceptDirectories;
        }
        for (FileFilter ff : this.filters) {
            if (!ff.accept(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (FileFilter ff : this.filters) {
            extensions.addAll(Arrays.asList(ff.getExtensions()));
        }
        String[] tab = new String[extensions.size()];
        extensions.toArray(tab);
        return tab;
    }
}

