/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.ui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.event.EventListenerList;

@Deprecated
public class JColorSelector
extends JButton {
    private static final long serialVersionUID = 3759677089992951265L;
    private ColorButtonModel colorModel = null;
    private Handler handler = null;

    public JColorSelector() {
        this(new ColorButtonModel());
    }

    public JColorSelector(Color initialeColor) {
        this(new ColorButtonModel(initialeColor));
    }

    public JColorSelector(ColorButtonModel model) {
        this.setColorButtonModel(model);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color c;
        super.paintComponent(g);
        Dimension sizes = this.getSize();
        if (this.colorModel != null && (c = this.colorModel.getColor()) != null) {
            g.setColor(c);
            g.fill3DRect(5, 5, sizes.width - 10, sizes.height - 10, false);
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        Stroke oldStroke = g2d.getStroke();
        BasicStroke bs = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f);
        g2d.setStroke(bs);
        g2d.drawRect(5, 5, sizes.width - 10, sizes.height - 10);
        g2d.setStroke(oldStroke);
    }

    public void setSelectedColor(Color color) {
        if (this.colorModel != null) {
            this.colorModel.setColor(color);
        }
    }

    public Color getSelectedColor() {
        if (this.colorModel != null) {
            return this.colorModel.getColor();
        }
        return null;
    }

    public ColorButtonModel getColorButtonModel() {
        return this.colorModel;
    }

    public void setColorButtonModel(ColorButtonModel model) {
        if (model == null) {
            return;
        }
        if (this.colorModel != null && this.handler != null) {
            this.colorModel.removeColorButtonModelListener(this.handler);
            this.removeActionListener(this.handler);
            this.handler = null;
        }
        this.colorModel = model;
        this.handler = new Handler();
        this.addActionListener(this.handler);
        this.colorModel.addColorButtonModelListener(this.handler);
    }

    private class Handler
    implements ColorButtonModelListener,
    ActionListener {
        @Override
        public void onColorChange(ColorButtonModel source, Color oldColor, Color newColor) {
            JColorSelector.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color;
            Color newColor;
            ColorButtonModel btModel = JColorSelector.this.getColorButtonModel();
            if (btModel != null && (newColor = JColorChooser.showDialog(JColorSelector.this, null, color = btModel.getColor())) != null) {
                btModel.setColor(newColor);
            }
        }
    }

    public static interface ColorButtonModelListener
    extends EventListener {
        public void onColorChange(ColorButtonModel var1, Color var2, Color var3);
    }

    public static class ColorButtonModel {
        private EventListenerList listeners = null;
        private Color color;

        public ColorButtonModel() {
            this.color = null;
        }

        public ColorButtonModel(Color initialColor) {
            this.color = initialColor;
        }

        public void addColorButtonModelListener(ColorButtonModelListener listener) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(ColorButtonModelListener.class, listener);
        }

        public void removeColorButtonModelListener(ColorButtonModelListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(ColorButtonModelListener.class, listener);
            if (this.listeners.getListenerCount() == 0) {
                this.listeners = null;
            }
        }

        protected void fireColorChanged(Color oldColor, Color newColor) {
            if (this.listeners != null) {
                ColorButtonModelListener[] list;
                for (ColorButtonModelListener listener : list = (ColorButtonModelListener[])this.listeners.getListeners(ColorButtonModelListener.class)) {
                    listener.onColorChange(this, oldColor, newColor);
                }
            }
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            if (color == null || this.color == color || color.equals(this.color)) {
                return;
            }
            Color oldColor = this.color;
            this.color = color;
            this.fireColorChanged(oldColor, this.color);
        }
    }
}

