/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

@Deprecated
public class JPopupTextField
extends JPanel {
    private static final long serialVersionUID = 374219507363847111L;
    protected static final int BORDER_SIZE = 3;
    private final WeakReference<JComponent> component;
    private Point2D preferredLocation = null;
    private final EventHandler handler = new EventHandler();
    private final JTextField textField = new JTextField();

    public JPopupTextField(JComponent owner, Color borderColor, Color backColor) {
        this.setFocusable(true);
        this.component = new WeakReference<JComponent>(owner);
        Font font = this.textField.getFont();
        int size = font.getSize() - 2;
        Font smallFont = font.deriveFont(size);
        this.textField.setFont(smallFont);
        this.textField.setMinimumSize(new Dimension(2 * font.getSize(), font.getSize()));
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.textField.getActionMap().put("Cancel", new AbstractAction(){
            private static final long serialVersionUID = -2343325366957567597L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupTextField.this.hideInputComponent();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        if (borderColor != null) {
            this.setBorder(BorderFactory.createLineBorder(borderColor));
        }
        if (backColor != null) {
            this.setBackground(backColor);
        }
    }

    public void setPreferredLocation(float x, float y) {
        Point2D old = this.preferredLocation;
        if (old == null || old.getX() != (double)x || old.getY() != (double)y) {
            this.preferredLocation = new Point2D.Float(x, y);
            this.layoutInputComponent();
            this.firePropertyChange("preferredLocation", old, this.preferredLocation);
        }
    }

    public void setPreferredLocation(Point2D p) {
        Point2D old = this.preferredLocation;
        if (!(old == p || old != null && p != null && p.equals(old))) {
            this.preferredLocation = p;
            this.layoutInputComponent();
            this.firePropertyChange("preferredLocation", old, this.preferredLocation);
        }
    }

    public Point2D getPreferredLocation() {
        return this.preferredLocation;
    }

    protected JTextField getTextField() {
        return this.textField;
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    public void setDocument(Document doc) {
        this.textField.setDocument(doc);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireValidationAction(ActionEvent eventSource) {
        ActionListener[] list;
        for (ActionListener listener : list = (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(eventSource);
        }
    }

    protected void onValidationAction() {
    }

    public void doValidation() {
        ActionEvent e = new ActionEvent(this, 1001, null, System.currentTimeMillis(), 0);
        this.fireValidationAction(e);
    }

    public void doValidation(ActionEvent sourceEvent) {
        assert (sourceEvent != null);
        ActionEvent e = sourceEvent;
        if (e.getSource() != this) {
            e = new ActionEvent(this, sourceEvent.getID(), sourceEvent.getActionCommand(), sourceEvent.getWhen(), sourceEvent.getModifiers());
        }
        this.hideInputComponent();
        this.onValidationAction();
        this.fireValidationAction(e);
    }

    public JComponent getOwner() {
        return (JComponent)this.component.get();
    }

    protected void layoutInputComponent() {
        JComponent component = this.getOwner();
        if (component != null && this.getParent() != null) {
            Dimension cdim = this.getPreferredSize();
            if (cdim == null) {
                cdim = new Dimension(100, 20);
            }
            this.setSize(cdim);
            JRootPane root = component.getRootPane();
            JLayeredPane lpane = root.getLayeredPane();
            Rectangle r = component.getVisibleRect();
            r = SwingUtilities.convertRectangle(component, r, lpane);
            int x = 0;
            int y = 0;
            if (this.preferredLocation != null) {
                Point p = new Point();
                p.setLocation(this.preferredLocation);
                p = SwingUtilities.convertPoint(component, p, lpane);
                x = p.x;
                y = p.y;
            }
            if (x + cdim.width > r.width) {
                x = r.width - cdim.width;
            }
            if (y + cdim.height > r.height) {
                y = r.height - cdim.height;
            }
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.revalidate();
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            this.showInputComponent();
        } else {
            this.hideInputComponent();
        }
    }

    protected boolean showInputComponent() {
        JComponent component = this.getOwner();
        if (component != null && this.getParent() == null) {
            JRootPane root = component.getRootPane();
            JLayeredPane lpane = root.getLayeredPane();
            lpane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            this.layoutInputComponent();
            super.setVisible(true);
            this.textField.requestFocusInWindow();
            this.textField.addActionListener(this.handler);
            this.textField.addFocusListener(this.handler);
            this.textField.addHierarchyBoundsListener(this.handler);
            this.onPopupFieldOpened();
            return true;
        }
        return false;
    }

    protected boolean hideInputComponent() {
        JComponent component = this.getOwner();
        if (component != null && this.getParent() != null) {
            JLayeredPane lpane;
            this.textField.removeFocusListener(this.handler);
            this.textField.removeActionListener(this.handler);
            super.setVisible(false);
            JRootPane root = component.getRootPane();
            if (root != null && (lpane = root.getLayeredPane()) != null) {
                lpane.remove(this);
            }
            component.requestFocusInWindow();
            this.onPopupFieldClosed();
            return true;
        }
        return false;
    }

    protected void onPopupFieldClosed() {
    }

    protected void onPopupFieldOpened() {
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    private class EventHandler
    implements FocusListener,
    ActionListener,
    HierarchyBoundsListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JPopupTextField.this.hideInputComponent();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupTextField.this.doValidation(e);
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            JPopupTextField.this.layoutInputComponent();
        }
    }
}

