/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.ui.swing.progress;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.arakhne.afc.progress.DefaultProgression;
import org.arakhne.afc.progress.Progression;
import org.arakhne.afc.ui.swing.progress.ProgressionProgressBarWrapper;

@Deprecated
public class ProgressBarModel
extends DefaultProgression
implements BoundedRangeModel {
    private WeakReference<JProgressBar> progressBar;
    private final boolean percentInTooltip;
    private ComponentListener componentListener = null;
    private boolean savedStringPaintedFlag;

    public static BoundedRangeModel setBarModel(JProgressBar bar, Progression model) {
        BoundedRangeModel jmodel;
        if (model instanceof ProgressBarModel) {
            ProgressBarModel pbm;
            jmodel = pbm = (ProgressBarModel)model;
            pbm.setProgressBar(bar);
        } else {
            jmodel = model instanceof BoundedRangeModel ? (BoundedRangeModel)model : new ProgressionProgressBarWrapper(model);
            bar.setModel(jmodel);
        }
        return jmodel;
    }

    public ProgressBarModel(JProgressBar progressBar, int value, int min, int max, boolean adjusting) {
        this(progressBar, value, min, max, adjusting, true);
    }

    public ProgressBarModel(JProgressBar progressBar, int value, int min, int max, boolean adjusting, boolean percentInTooltip) {
        super(value, min, max, adjusting);
        this.percentInTooltip = percentInTooltip;
        this.progressBar = progressBar == null ? null : new WeakReference<JProgressBar>(progressBar);
        this.sharedInit(progressBar);
    }

    public ProgressBarModel(JProgressBar progressBar, int value, int min, int max) {
        super(value, min, max);
        this.percentInTooltip = true;
        this.progressBar = progressBar == null ? null : new WeakReference<JProgressBar>(progressBar);
        this.sharedInit(progressBar);
    }

    public ProgressBarModel(JProgressBar progressBar, int min, int max, boolean percentInTooltip) {
        super(min, max);
        this.percentInTooltip = percentInTooltip;
        this.progressBar = progressBar == null ? null : new WeakReference<JProgressBar>(progressBar);
        this.sharedInit(progressBar);
    }

    public ProgressBarModel(JProgressBar progressBar, int min, int max) {
        this(progressBar, min, max, true);
    }

    public ProgressBarModel(JProgressBar progressBar, boolean percentInTooltip) {
        this.percentInTooltip = percentInTooltip;
        this.progressBar = progressBar == null ? null : new WeakReference<JProgressBar>(progressBar);
        this.sharedInit(progressBar);
    }

    public ProgressBarModel(JProgressBar progressBar) {
        this(progressBar, true);
    }

    private void sharedInit(JProgressBar pb) {
        if (pb != null) {
            this.savedStringPaintedFlag = pb.isStringPainted();
            pb.setModel(this);
            this.componentListener = new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    this.update();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.update();
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    this.update();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    this.update();
                }

                public void update() {
                    JProgressBar pbar = (JProgressBar)ProgressBarModel.this.progressBar.get();
                    ComponentListener list = ProgressBarModel.this.componentListener;
                    ProgressBarModel.this.componentListener = null;
                    if (pbar != null) {
                        if (list != null) {
                            pbar.removeComponentListener(list);
                        }
                        ProgressBarModel.this.updateIndeterminateState(ProgressBarModel.this.isIndeterminate());
                    }
                }
            };
            pb.addComponentListener(this.componentListener);
        } else {
            this.updateIndeterminateState(this.isIndeterminate());
        }
    }

    private void updateIndeterminateState(boolean isIndeterminate) {
        JProgressBar pg;
        JProgressBar jProgressBar = pg = this.progressBar != null ? (JProgressBar)this.progressBar.get() : null;
        if (pg != null) {
            if (isIndeterminate) {
                this.savedStringPaintedFlag = pg.isStringPainted();
                pg.setStringPainted(false);
                pg.setIndeterminate(true);
            } else {
                pg.setIndeterminate(false);
                pg.setStringPainted(this.savedStringPaintedFlag);
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, (EventListener)listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, (EventListener)listener);
    }

    private void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    @Override
    public int getExtent() {
        return 1;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting();
    }

    @Override
    public void setExtent(int newExtent) {
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.setProperties(value, min, max, adjusting);
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.setAdjusting(b);
    }

    protected void fireStateChange() {
        JProgressBar bar;
        JProgressBar jProgressBar = bar = this.progressBar == null ? null : (JProgressBar)this.progressBar.get();
        if (bar != null) {
            this.updateIndeterminateState(this.isIndeterminate());
            if (this.percentInTooltip) {
                this.updateToolip(bar);
            }
        }
        super.fireStateChange();
    }

    protected void fireValueChange() {
        if (this.percentInTooltip) {
            JProgressBar bar = this.progressBar == null ? null : (JProgressBar)this.progressBar.get();
            this.updateToolip(bar);
        }
        super.fireValueChange();
        this.fireChange();
    }

    private void updateToolip(JProgressBar bar) {
        if (bar != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append((int)this.getPercent());
            buffer.append("%");
            String comment = this.getComment();
            if (comment != null) {
                buffer.append(" - ");
                buffer.append(comment);
            }
            bar.setString(comment);
            bar.setToolTipText(buffer.toString());
        }
    }

    public void setProgressBar(JProgressBar bar) {
        JProgressBar oldBar;
        JProgressBar jProgressBar = oldBar = this.progressBar == null ? null : (JProgressBar)this.progressBar.get();
        if (oldBar != bar) {
            if (oldBar != null) {
                DefaultBoundedRangeModel defaultModel = new DefaultBoundedRangeModel();
                defaultModel.setRangeProperties(this.getValue(), this.getExtent(), this.getMinimum(), this.getMaximum(), this.isAdjusting());
                oldBar.setModel(defaultModel);
            }
            WeakReference<JProgressBar> weakReference = this.progressBar = bar == null ? null : new WeakReference<JProgressBar>(bar);
            if (bar != null) {
                bar.setModel(this);
            }
            this.updateIndeterminateState(this.isIndeterminate());
            this.fireChange();
        }
    }
}

