/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.ui.swing.zoom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arakhne.afc.math.continous.object2d.Circle2f;
import org.arakhne.afc.math.continous.object2d.Ellipse2f;
import org.arakhne.afc.math.continous.object2d.Path2f;
import org.arakhne.afc.math.continous.object2d.PathElement2f;
import org.arakhne.afc.math.continous.object2d.PathIterator2f;
import org.arakhne.afc.math.continous.object2d.Point2f;
import org.arakhne.afc.math.continous.object2d.Rectangle2f;
import org.arakhne.afc.math.continous.object2d.RoundRectangle2f;
import org.arakhne.afc.math.continous.object2d.Segment2f;
import org.arakhne.afc.math.continous.object2d.Shape2f;
import org.arakhne.afc.math.generic.PathWindingRule;
import org.arakhne.afc.math.matrix.Transform2D;
import org.arakhne.afc.ui.CenteringTransform;
import org.arakhne.afc.ui.Graphics2DLOD;
import org.arakhne.afc.ui.StringAnchor;
import org.arakhne.afc.ui.ZoomableContext;
import org.arakhne.afc.ui.ZoomableContextUtil;
import org.arakhne.afc.ui.vector.AbstractVectorGraphics2D;
import org.arakhne.afc.ui.vector.FontMetrics;
import org.arakhne.afc.ui.vector.ImageObserver;
import org.arakhne.afc.ui.vector.Paint;
import org.arakhne.afc.ui.vector.VectorToolkit;

@Deprecated
public class ZoomableGraphics2D
extends AbstractVectorGraphics2D
implements ZoomableContext {
    protected final Graphics2D canvas;
    protected final org.arakhne.afc.ui.vector.Color defaultBackground;
    protected final Graphics2DLOD defaultLevelOfDetail;
    protected Graphics2DLOD levelOfDetail;
    protected org.arakhne.afc.ui.vector.Color background;
    protected final float scale;
    protected final CenteringTransform centeringTransform;
    protected final Rectangle2f tmpRect = new Rectangle2f();
    protected final Rectangle2D tmpRect2 = new Rectangle2D.Float();
    protected final org.arakhne.afc.ui.vector.Color defaultFillColor;
    protected final org.arakhne.afc.ui.vector.Color defaultLineColor;
    protected final float scalingSensitivity;
    protected final float focusX;
    protected final float focusY;
    protected final float maxScale;
    protected final float minScale;
    private final Font defaultAwtFont;

    public static Transform2D convertAffineTransform(AffineTransform m, float scale) {
        assert (m != null);
        if (m.isIdentity()) {
            return new Transform2D();
        }
        return new Transform2D(ZoomableContextUtil.pixel2logical_size((float)((float)m.getScaleX()), (float)scale), (float)m.getShearX(), ZoomableContextUtil.pixel2logical_size((float)((float)m.getTranslateX()), (float)scale), (float)m.getShearY(), ZoomableContextUtil.pixel2logical_size((float)((float)m.getScaleY()), (float)scale), ZoomableContextUtil.pixel2logical_size((float)((float)m.getTranslateY()), (float)scale));
    }

    public static AffineTransform convertTransformation(Transform2D t, float scale) {
        assert (t != null);
        AffineTransform at = !t.isIdentity() ? new AffineTransform(ZoomableContextUtil.logical2pixel_size((float)((float)t.getM00()), (float)scale), (float)t.getM01(), ZoomableContextUtil.logical2pixel_size((float)((float)t.getM02()), (float)scale), (float)t.getM10(), ZoomableContextUtil.logical2pixel_size((float)((float)t.getM11()), (float)scale), ZoomableContextUtil.logical2pixel_size((float)((float)t.getM12()), (float)scale)) : new AffineTransform();
        return at;
    }

    public ZoomableGraphics2D(Graphics2D canvas, org.arakhne.afc.ui.vector.Color defaultFillColor, org.arakhne.afc.ui.vector.Color defaultLineColor, float scaleFactor, CenteringTransform centeringTransform, org.arakhne.afc.ui.vector.Color background, boolean isAntiAlias, float scalingSensitivity, float focusX, float focusY, float minScaleFactor, float maxScaleFactor) {
        super(defaultFillColor, defaultLineColor, null, true, true, null);
        this.defaultAwtFont = canvas.getFont();
        this.defaultFillColor = defaultFillColor;
        this.defaultLineColor = defaultLineColor;
        this.scalingSensitivity = scalingSensitivity;
        this.focusX = focusX;
        this.focusY = focusY;
        this.minScale = minScaleFactor;
        this.maxScale = maxScaleFactor;
        this.canvas = canvas;
        this.scale = scaleFactor;
        this.centeringTransform = centeringTransform;
        this.defaultBackground = this.background = background;
        this.levelOfDetail = isAntiAlias ? Graphics2DLOD.NORMAL_LEVEL_OF_DETAIL : Graphics2DLOD.LOW_LEVEL_OF_DETAIL;
        this.defaultLevelOfDetail = this.levelOfDetail;
        this.resetPainters();
    }

    public Graphics2D getNativeGraphics2D() {
        return this.canvas;
    }

    public void dispose() {
        this.background = null;
        this.levelOfDetail = null;
        super.dispose();
    }

    public void reset() {
        super.reset();
        this.levelOfDetail = this.defaultLevelOfDetail;
        this.background = this.defaultBackground;
        this.setFillColor(this.defaultFillColor);
        this.setOutlineColor(this.defaultLineColor);
        this.resetPainters();
    }

    protected void resetPainters() {
        boolean isNormalLod = this.levelOfDetail.compareTo((Enum)Graphics2DLOD.NORMAL_LEVEL_OF_DETAIL) >= 0;
        this.canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, isNormalLod ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.canvas.setComposite(AlphaComposite.SrcOver);
        this.canvas.setStroke(new BasicStroke());
        float rawSize = this.logical2pixel_size(this.defaultAwtFont.getSize2D());
        this.canvas.setFont(this.defaultAwtFont.deriveFont(rawSize));
    }

    protected void log(String message) {
        Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName()).log(Level.FINEST, message);
    }

    protected void log(String message, Throwable exception) {
        Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName()).log(Level.FINEST, message, exception);
    }

    public Graphics2DLOD getLOD() {
        return this.levelOfDetail;
    }

    public void setLOD(Graphics2DLOD lod) {
        if (lod != null) {
            this.levelOfDetail = lod;
            boolean isNormalLod = this.levelOfDetail.compareTo((Enum)Graphics2DLOD.NORMAL_LEVEL_OF_DETAIL) >= 0;
            this.canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, isNormalLod ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public StringAnchor getStringAnchor() {
        return StringAnchor.LEFT_BASELINE;
    }

    public void drawPoint(float x, float y) {
        this.preDrawing();
        float px = ZoomableContextUtil.logical2pixel_x((float)x, (CenteringTransform)this.centeringTransform, (float)this.scale);
        float py = ZoomableContextUtil.logical2pixel_y((float)y, (CenteringTransform)this.centeringTransform, (float)this.scale);
        this.tmpRect2.setFrame(px - 0.5f, py - 0.5f, 1.0, 1.0);
        this.appliesOutlineAttributes();
        this.canvas.fill(this.tmpRect2);
        this.postDrawing();
    }

    public org.arakhne.afc.ui.vector.Font getFont() {
        Font f = this.canvas.getFont();
        f = f.deriveFont(ZoomableContextUtil.pixel2logical_size((float)f.getSize(), (float)this.scale));
        return VectorToolkit.font((Object)f);
    }

    public void setFont(org.arakhne.afc.ui.vector.Font font) {
        Font f = (Font)VectorToolkit.nativeUIObject(Font.class, (Object)font);
        assert (f != null);
        f = f.deriveFont(ZoomableContextUtil.logical2pixel_size((float)f.getSize(), (float)this.scale));
        this.canvas.setFont(f);
    }

    public FontMetrics getFontMetrics() {
        Font f = this.canvas.getFont();
        f = f.deriveFont(ZoomableContextUtil.pixel2logical_size((float)f.getSize(), (float)this.scale));
        return VectorToolkit.fontMetrics((Object)this.canvas.getFontMetrics(f));
    }

    public FontMetrics getFontMetrics(org.arakhne.afc.ui.vector.Font f) {
        return VectorToolkit.fontMetrics((org.arakhne.afc.ui.vector.Font)f);
    }

    public Shape2f getClip() {
        Rectangle2f rr = null;
        Shape r = this.canvas.getClip();
        if (r != null) {
            Rectangle2D b = r.getBounds2D();
            rr = new Rectangle2f((float)b.getMinX(), (float)b.getMinY(), (float)b.getWidth(), (float)b.getHeight());
            ZoomableContextUtil.pixel2logical((Rectangle2f)rr, (CenteringTransform)this.centeringTransform, (float)this.scale);
        }
        return rr;
    }

    public void setClip(Shape2f clip) {
        if (clip != null) {
            Rectangle2f r = clip.toBoundingBox();
            ZoomableContextUtil.logical2pixel((Rectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
            this.tmpRect2.setFrame(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
            this.canvas.setClip(this.tmpRect2);
        } else {
            this.canvas.setClip(null);
        }
    }

    public void clip(Shape2f clip) {
        Rectangle2f r = clip.toBoundingBox();
        ZoomableContextUtil.logical2pixel((Rectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
        this.tmpRect2.setFrame(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
        this.canvas.clip(this.tmpRect2);
    }

    public boolean drawImage(URL imageURL, org.arakhne.afc.ui.vector.Image img, float dx1, float dy1, float dx2, float dy2, int sx1, int sy1, int sx2, int sy2) {
        return this.drawImage(imageURL, img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public boolean drawImage(URL imageURL, org.arakhne.afc.ui.vector.Image img, float dx1, float dy1, float dx2, float dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.preDrawing();
        Image bitmap = (Image)VectorToolkit.nativeUIObject(Image.class, (Object)img);
        assert (bitmap != null);
        this.tmpRect.setFromCorners(dx1, dy1, dx2, dy2);
        ZoomableContextUtil.logical2pixel((Rectangle2f)this.tmpRect, (CenteringTransform)this.centeringTransform, (float)this.scale);
        ObserverWrapper obs = observer == null ? null : new ObserverWrapper(observer);
        boolean b = this.canvas.drawImage(bitmap, (int)this.tmpRect.getMinX(), (int)this.tmpRect.getMinY(), (int)this.tmpRect.getMaxX(), (int)this.tmpRect.getMaxY(), sx1, sy1, sx2, sy2, (Color)VectorToolkit.nativeUIObject(Color.class, (Object)this.getBackground()), obs);
        if (this.isOutlineDrawn()) {
            this.appliesOutlineAttributes();
            int x = Math.min((int)this.tmpRect.getMinX(), (int)this.tmpRect.getMaxX());
            int y = Math.min((int)this.tmpRect.getMinY(), (int)this.tmpRect.getMaxY());
            int w = Math.abs((int)this.tmpRect.getMinX() - (int)this.tmpRect.getMaxX());
            int h = Math.abs((int)this.tmpRect.getMinY() - (int)this.tmpRect.getMaxY());
            this.canvas.drawRect(x, y, w, h);
        }
        this.postDrawing();
        return b;
    }

    private Shape toAwt(Shape2f s) {
        if (s != null) {
            PathIterator2f path = null;
            if (s instanceof Path2f) {
                path = ((Path2f)s).getPathIterator();
            } else {
                if (s instanceof Rectangle2f) {
                    Rectangle2f r = (Rectangle2f)s;
                    this.tmpRect.set((Shape2f)r);
                    ZoomableContextUtil.logical2pixel((Rectangle2f)this.tmpRect, (CenteringTransform)this.centeringTransform, (float)this.scale);
                    this.tmpRect2.setFrame(this.tmpRect.getMinX(), this.tmpRect.getMinY(), this.tmpRect.getWidth(), this.tmpRect.getHeight());
                    return this.tmpRect2;
                }
                if (s instanceof Ellipse2f) {
                    Ellipse2f r = (Ellipse2f)s;
                    this.tmpRect.set((Shape2f)r);
                    ZoomableContextUtil.logical2pixel((Rectangle2f)this.tmpRect, (CenteringTransform)this.centeringTransform, (float)this.scale);
                    Ellipse2D.Float se = new Ellipse2D.Float(this.tmpRect.getMinX(), this.tmpRect.getMinY(), this.tmpRect.getWidth(), this.tmpRect.getHeight());
                    return se;
                }
                if (s instanceof Circle2f) {
                    Circle2f r = (Circle2f)s;
                    float cx = ZoomableContextUtil.logical2pixel_x((float)r.getX(), (CenteringTransform)this.centeringTransform, (float)this.scale);
                    float cy = ZoomableContextUtil.logical2pixel_y((float)r.getY(), (CenteringTransform)this.centeringTransform, (float)this.scale);
                    float radius = ZoomableContextUtil.logical2pixel_size((float)r.getRadius(), (float)this.scale);
                    float diameter = radius * 2.0f;
                    Ellipse2D.Float se = new Ellipse2D.Float(cx - radius, cy - radius, diameter, diameter);
                    return se;
                }
                if (s instanceof RoundRectangle2f) {
                    RoundRectangle2f r = (RoundRectangle2f)s;
                    this.tmpRect.set((Shape2f)r);
                    ZoomableContextUtil.logical2pixel((Rectangle2f)this.tmpRect, (CenteringTransform)this.centeringTransform, (float)this.scale);
                    float aw = ZoomableContextUtil.logical2pixel_size((float)(r.getArcWidth() / 2.0f), (float)this.scale);
                    float ah = ZoomableContextUtil.logical2pixel_size((float)(r.getArcHeight() / 2.0f), (float)this.scale);
                    RoundRectangle2D.Float rr = new RoundRectangle2D.Float(this.tmpRect.getMinX(), this.tmpRect.getMinY(), this.tmpRect.getWidth(), this.tmpRect.getHeight(), aw, ah);
                    return rr;
                }
                if (s instanceof Segment2f) {
                    Segment2f l = (Segment2f)s;
                    Line2D.Float sl = new Line2D.Float(ZoomableContextUtil.logical2pixel_x((float)l.getX1(), (CenteringTransform)this.centeringTransform, (float)this.scale), ZoomableContextUtil.logical2pixel_y((float)l.getY1(), (CenteringTransform)this.centeringTransform, (float)this.scale), ZoomableContextUtil.logical2pixel_x((float)l.getX2(), (CenteringTransform)this.centeringTransform, (float)this.scale), ZoomableContextUtil.logical2pixel_y((float)l.getY2(), (CenteringTransform)this.centeringTransform, (float)this.scale));
                    return sl;
                }
                path = s.getPathIterator();
            }
            if (path != null) {
                path = ZoomableContextUtil.logical2pixel((PathIterator2f)path, (CenteringTransform)this.centeringTransform, (float)this.scale);
                Path2D.Float sp = new Path2D.Float();
                if (path.getWindingRule() == PathWindingRule.EVEN_ODD) {
                    sp.setWindingRule(0);
                }
                block7: while (path.hasNext()) {
                    PathElement2f e = (PathElement2f)path.next();
                    switch (e.type) {
                        case MOVE_TO: {
                            ((Path2D)sp).moveTo(e.toX, e.toY);
                            continue block7;
                        }
                        case LINE_TO: {
                            ((Path2D)sp).lineTo(e.toX, e.toY);
                            continue block7;
                        }
                        case CURVE_TO: {
                            ((Path2D)sp).curveTo(e.ctrlX1, e.ctrlY1, e.ctrlX2, e.ctrlY2, e.toX, e.toY);
                            continue block7;
                        }
                        case QUAD_TO: {
                            ((Path2D)sp).quadTo(e.ctrlX1, e.ctrlY1, e.toX, e.toY);
                            continue block7;
                        }
                        case CLOSE: {
                            sp.closePath();
                            continue block7;
                        }
                    }
                }
                return sp;
            }
            throw new IllegalArgumentException(s.toString());
        }
        throw new IllegalArgumentException();
    }

    private Color toAwt(org.arakhne.afc.ui.vector.Color c) {
        if (c == null) {
            return this.canvas.getBackground();
        }
        return new Color(c.getRGB(), true);
    }

    private void appliesFillAttributes() {
        Paint painter = this.getPaint();
        java.awt.Paint awtPaint = (java.awt.Paint)VectorToolkit.nativeUIObject(java.awt.Paint.class, (Object)painter);
        if (awtPaint != null) {
            this.canvas.setPaint(awtPaint);
        } else {
            this.canvas.setColor(this.toAwt(this.getFillColor()));
        }
    }

    private void appliesOutlineAttributes() {
        this.canvas.setColor(this.toAwt(this.getOutlineColor()));
    }

    private void appliesTextAttributes() {
        this.canvas.setColor(this.toAwt(this.getOutlineColor()));
    }

    public void clear(Shape2f s) {
        this.canvas.setColor(this.toAwt(this.getBackground()));
        this.canvas.fill(this.toAwt(s));
        this.postDrawing();
    }

    public void draw(Shape2f s) {
        String text;
        this.preDrawing();
        Shape awt = this.toAwt(s);
        if (this.isInteriorPainted()) {
            this.appliesFillAttributes();
            this.canvas.fill(awt);
        }
        if ((text = this.getInteriorText()) != null && !text.isEmpty()) {
            this.paintString(text, s.toBoundingBox(), s);
        }
        if (this.isOutlineDrawn()) {
            this.appliesOutlineAttributes();
            this.canvas.draw(awt);
        }
        this.postDrawing();
    }

    protected void paintString(String text, float x, float y, Shape2f clip) {
        Shape2f oldClip = null;
        if (clip != null) {
            oldClip = this.getClip();
            this.clip(clip);
        }
        this.appliesTextAttributes();
        FontRenderContext frc = this.canvas.getFontRenderContext();
        GlyphVector glyphs = this.canvas.getFont().createGlyphVector(frc, text);
        Shape s = glyphs.getOutline(ZoomableContextUtil.logical2pixel_x((float)x, (CenteringTransform)this.centeringTransform, (float)this.scale), ZoomableContextUtil.logical2pixel_y((float)y, (CenteringTransform)this.centeringTransform, (float)this.scale));
        assert (s != null);
        this.canvas.fill(s);
        if (clip != null) {
            this.setClip(oldClip);
        }
    }

    public void translate(float tx, float ty) {
        this.canvas.translate(ZoomableContextUtil.logical2pixel_size((float)tx, (float)this.scale), ZoomableContextUtil.logical2pixel_size((float)ty, (float)this.scale));
    }

    public void scale(float sx, float sy) {
        this.canvas.scale(ZoomableContextUtil.logical2pixel_size((float)sx, (float)this.scale), ZoomableContextUtil.logical2pixel_size((float)sy, (float)this.scale));
    }

    public void rotate(float theta) {
        this.canvas.rotate((float)Math.toDegrees(theta));
    }

    public void shear(float shx, float shy) {
        this.canvas.shear(ZoomableContextUtil.logical2pixel_size((float)shx, (float)this.scale), ZoomableContextUtil.logical2pixel_size((float)shy, (float)this.scale));
    }

    public void transform(Transform2D Tx) {
        this.canvas.transform(ZoomableGraphics2D.convertTransformation(Tx, this.scale));
    }

    public Transform2D setTransform(Transform2D Tx) {
        Transform2D old = ZoomableGraphics2D.convertAffineTransform(this.canvas.getTransform(), this.scale);
        this.canvas.setTransform(ZoomableGraphics2D.convertTransformation(Tx, this.scale));
        return old;
    }

    public Transform2D getTransform() {
        return ZoomableGraphics2D.convertAffineTransform(this.canvas.getTransform(), this.scale);
    }

    public void setBackground(org.arakhne.afc.ui.vector.Color color) {
        this.background = color;
    }

    public org.arakhne.afc.ui.vector.Color getBackground() {
        return this.background;
    }

    public void setComposite(org.arakhne.afc.ui.vector.Composite composite) {
        Composite ac = (Composite)VectorToolkit.nativeUIObject(Composite.class, (Object)composite);
        this.canvas.setComposite(ac);
    }

    public org.arakhne.afc.ui.vector.Composite getComposite() {
        return VectorToolkit.composite((Object)this.canvas.getComposite());
    }

    public void setStroke(org.arakhne.afc.ui.vector.Stroke stroke) {
        Stroke as = (Stroke)VectorToolkit.nativeUIObject(Stroke.class, (Object)stroke);
        this.canvas.setStroke(as);
    }

    public org.arakhne.afc.ui.vector.Stroke getStroke() {
        return VectorToolkit.stroke((Object)this.canvas.getStroke());
    }

    public float logical2pixel_size(float l) {
        return ZoomableContextUtil.logical2pixel_size((float)l, (float)this.scale);
    }

    public float logical2pixel_x(float l) {
        return ZoomableContextUtil.logical2pixel_x((float)l, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public float logical2pixel_y(float l) {
        return ZoomableContextUtil.logical2pixel_y((float)l, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public float pixel2logical_size(float l) {
        return ZoomableContextUtil.pixel2logical_size((float)l, (float)this.scale);
    }

    public float pixel2logical_x(float l) {
        return ZoomableContextUtil.pixel2logical_x((float)l, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public float pixel2logical_y(float l) {
        return ZoomableContextUtil.pixel2logical_y((float)l, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public PathIterator2f logical2pixel(PathIterator2f p) {
        return ZoomableContextUtil.logical2pixel((PathIterator2f)p, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public PathIterator2f pixel2logical(PathIterator2f p) {
        return ZoomableContextUtil.pixel2logical((PathIterator2f)p, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void logical2pixel(Segment2f s) {
        ZoomableContextUtil.logical2pixel((Segment2f)s, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void pixel2logical(Segment2f s) {
        ZoomableContextUtil.pixel2logical((Segment2f)s, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void logical2pixel(RoundRectangle2f r) {
        ZoomableContextUtil.logical2pixel((RoundRectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void pixel2logical(RoundRectangle2f r) {
        ZoomableContextUtil.pixel2logical((RoundRectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void logical2pixel(Point2f p) {
        ZoomableContextUtil.logical2pixel((Point2f)p, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void pixel2logical(Point2f p) {
        ZoomableContextUtil.pixel2logical((Point2f)p, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void logical2pixel(Ellipse2f e) {
        ZoomableContextUtil.logical2pixel((Ellipse2f)e, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void pixel2logical(Ellipse2f e) {
        ZoomableContextUtil.pixel2logical((Ellipse2f)e, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void logical2pixel(Circle2f r) {
        ZoomableContextUtil.logical2pixel((Circle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void pixel2logical(Circle2f r) {
        ZoomableContextUtil.pixel2logical((Circle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void logical2pixel(Rectangle2f r) {
        ZoomableContextUtil.logical2pixel((Rectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public void pixel2logical(Rectangle2f r) {
        ZoomableContextUtil.pixel2logical((Rectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public Shape2f logical2pixel(Shape2f s) {
        return ZoomableContextUtil.logical2pixel((Shape2f)s, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public Shape2f pixel2logical(Shape2f s) {
        return ZoomableContextUtil.pixel2logical((Shape2f)s, (CenteringTransform)this.centeringTransform, (float)this.scale);
    }

    public float getScalingSensitivity() {
        return this.scalingSensitivity;
    }

    public float getFocusX() {
        return this.focusX;
    }

    public float getFocusY() {
        return this.focusY;
    }

    public float getScalingFactor() {
        return this.scale;
    }

    public float getMaxScalingFactor() {
        return this.maxScale;
    }

    public float getMinScalingFactor() {
        return this.minScale;
    }

    public boolean isXAxisInverted() {
        return this.centeringTransform.isXAxisFlipped();
    }

    public boolean isYAxisInverted() {
        return this.centeringTransform.isYAxisFlipped();
    }

    private static class ObserverWrapper
    implements java.awt.image.ImageObserver {
        private final ImageObserver observer;

        public ObserverWrapper(ImageObserver observer) {
            assert (observer != null);
            this.observer = observer;
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            assert (this.observer != null);
            return this.observer.imageUpdate(VectorToolkit.image((Object)img), x, y, width, height);
        }
    }
}

