/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.ui.swing.zoom;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import org.arakhne.afc.math.continous.object2d.Circle2f;
import org.arakhne.afc.math.continous.object2d.Ellipse2f;
import org.arakhne.afc.math.continous.object2d.PathIterator2f;
import org.arakhne.afc.math.continous.object2d.Point2f;
import org.arakhne.afc.math.continous.object2d.Rectangle2f;
import org.arakhne.afc.math.continous.object2d.RoundRectangle2f;
import org.arakhne.afc.math.continous.object2d.Segment2f;
import org.arakhne.afc.math.continous.object2d.Shape2f;
import org.arakhne.afc.ui.CenteringTransform;
import org.arakhne.afc.ui.Graphics2DLOD;
import org.arakhne.afc.ui.ZoomableContext;
import org.arakhne.afc.ui.ZoomableContextUtil;
import org.arakhne.afc.ui.event.KeyEvent;
import org.arakhne.afc.ui.event.PointerEvent;
import org.arakhne.afc.ui.swing.event.KeyEventSwing;
import org.arakhne.afc.ui.swing.event.PointerEventSwing;
import org.arakhne.afc.ui.swing.zoom.DocumentWrapper;
import org.arakhne.afc.ui.swing.zoom.ScrollingMethod;

@Deprecated
public abstract class ZoomableView
extends JPanel
implements ZoomableContext,
Printable {
    private static final long serialVersionUID = -5703191414584605699L;
    public static final int REPAINT_BORDER = 5;
    private boolean antialiasing = false;
    private float focusX = 0.0f;
    private float focusY = 0.0f;
    float scaleFactor = 1.0f;
    private float minScaleFactor = 1.0E-4f;
    private float maxScaleFactor = 1000.0f;
    private float zoomingSensitivity = 1.5f;
    private boolean isInvertScrollingDirection = false;
    private boolean dynamicCenteringWhenWheelMoved = false;
    final CenteringTransform centeringTransform = new CenteringTransform();
    private boolean isXAxisInverted = false;
    private boolean isYAxisInverted = false;
    private ScrollingMethod scrollingMethod = ScrollingMethod.MIDDLE_BUTTON;
    private Graphics2DLOD lod = Graphics2DLOD.NORMAL_LEVEL_OF_DETAIL;
    private boolean isWheelSupport = true;
    final DocumentWrapper documentWrapper;
    private final Viewport viewport;
    final JScrollBar hscroll;
    final JScrollBar vscroll;
    final AtomicBoolean isScrollbarEnabled = new AtomicBoolean();

    public ZoomableView() {
        this((DocumentWrapper)null);
    }

    public ZoomableView(DocumentWrapper documentWrapper) {
        this.documentWrapper = documentWrapper;
        SwingEventHandler handler = new SwingEventHandler();
        if (this.documentWrapper != null) {
            this.isScrollbarEnabled.set(true);
            this.viewport = new Viewport();
            this.hscroll = new JScrollBar(0);
            this.hscroll.setFocusable(false);
            this.hscroll.setRequestFocusEnabled(false);
            this.hscroll.setVisible(true);
            this.vscroll = new JScrollBar(1);
            this.vscroll.setFocusable(false);
            this.vscroll.setRequestFocusEnabled(false);
            this.vscroll.setVisible(true);
            JPanel southPane = new JPanel();
            southPane.setLayout(new BoxLayout(southPane, 0));
            JPanel corner = new JPanel();
            Dimension d1 = this.hscroll.getPreferredSize();
            Dimension d2 = this.vscroll.getPreferredSize();
            Dimension borderSize = new Dimension((int)((Dimension2D)d2).getWidth(), (int)((Dimension2D)d1).getHeight());
            corner.setMinimumSize(borderSize);
            corner.setMaximumSize(borderSize);
            corner.setPreferredSize(borderSize);
            this.setLayout(new BorderLayout());
            ComponentOrientation co = this.getComponentOrientation();
            if (co.isLeftToRight()) {
                this.add("East", this.vscroll);
                southPane.add(this.hscroll);
                southPane.add(corner);
            } else {
                this.add("West", this.vscroll);
                southPane.add(corner);
                southPane.add(this.hscroll);
            }
            this.add("South", southPane);
            this.add("Center", this.viewport);
            this.updateScrollbars();
            this.vscroll.addAdjustmentListener(handler);
            this.hscroll.addAdjustmentListener(handler);
            this.documentWrapper.addChangeListener(handler);
        } else {
            this.isScrollbarEnabled.set(false);
            this.viewport = null;
            this.hscroll = null;
            this.vscroll = null;
        }
        JPanel viewport = this.getViewport();
        viewport.addComponentListener(handler);
        viewport.addMouseListener(handler);
        viewport.addMouseMotionListener(handler);
        viewport.addMouseWheelListener(handler);
        viewport.addKeyListener(handler);
    }

    void updateScrollbars() {
        boolean oldV = this.isScrollbarEnabled.getAndSet(false);
        try {
            if (oldV) {
                assert (this.documentWrapper != null);
                Rectangle2f documentBounds = this.documentWrapper.getDocumentBounds();
                if (documentBounds == null) {
                    this.hscroll.setEnabled(false);
                    this.vscroll.setEnabled(false);
                } else {
                    ZoomableView.updateScrollBar(this.hscroll, (int)this.logical2pixel_x(documentBounds.getMinX()), (int)Math.ceil(this.logical2pixel_x(documentBounds.getMaxX())), this.getViewport().getWidth());
                    ZoomableView.updateScrollBar(this.vscroll, (int)this.logical2pixel_y(documentBounds.getMinY()), (int)Math.ceil(this.logical2pixel_y(documentBounds.getMaxY())), this.getViewport().getHeight());
                }
            }
        }
        finally {
            this.isScrollbarEnabled.set(oldV);
        }
    }

    private static void updateScrollBar(JScrollBar bar, int minDocument, int maxDocument, int maxViewport) {
        int minBar = Math.min(minDocument, 0);
        int maxBar = Math.max(maxDocument, maxViewport);
        if (minBar >= 0 && maxBar <= maxViewport) {
            bar.setEnabled(false);
        } else {
            bar.setEnabled(true);
            bar.setValues(0, maxViewport, minBar, maxBar);
        }
    }

    public JPanel getViewport() {
        if (this.viewport == null) {
            return this;
        }
        return this.viewport;
    }

    public boolean isAntiAliased() {
        return this.antialiasing;
    }

    public void setAntiAliased(boolean antialiasing) {
        this.antialiasing = antialiasing;
    }

    protected Graphics2DLOD getLOD() {
        return this.lod;
    }

    Graphics2DLOD setLOD(Graphics2DLOD lod) {
        Graphics2DLOD old = this.lod;
        this.lod = lod;
        return old;
    }

    public boolean isMouseWheelAllowed() {
        return this.isWheelSupport;
    }

    public void setMouseWheelEnable(boolean enable) {
        this.isWheelSupport = enable;
    }

    public boolean isFocusChangedOnMouseWheel() {
        return this.dynamicCenteringWhenWheelMoved;
    }

    public void setFocusChangedOnMouseWheel(boolean enable) {
        this.dynamicCenteringWhenWheelMoved = enable;
    }

    public ScrollingMethod getScrollingMethod() {
        return this.scrollingMethod;
    }

    public void setScrollingMethod(ScrollingMethod method) {
        this.scrollingMethod = method == null ? ScrollingMethod.MIDDLE_BUTTON : method;
    }

    public final boolean isXAxisInverted() {
        return this.isXAxisInverted;
    }

    public final boolean isYAxisInverted() {
        return this.isYAxisInverted;
    }

    public final void setXAxisInverted(boolean invert) {
        if (invert != this.isXAxisInverted) {
            this.isXAxisInverted = invert;
            this.onUpdateViewParameters();
            this.repaint();
        }
    }

    public final void setYAxisInverted(boolean invert) {
        if (invert != this.isYAxisInverted) {
            this.isYAxisInverted = invert;
            this.onUpdateViewParameters();
            this.repaint();
        }
    }

    @Override
    public void repaint() {
        if (this.viewport != null) {
            this.viewport.repaint();
        }
        super.repaint();
    }

    public final void repaint(float x, float y, float width, float height) {
        int l = (int)this.logical2pixel_x(x) - 5;
        int t = (int)this.logical2pixel_y(y) - 5;
        int w = (int)this.logical2pixel_size(width) + 10;
        int h = (int)this.logical2pixel_size(height) + 10;
        if (this.viewport == null) {
            this.repaint(l, t, w, h);
        } else {
            this.viewport.repaint(l, t, w, h);
        }
    }

    public final void repaint(Rectangle2f r) {
        if (r != null) {
            this.repaint(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
        }
    }

    public final void repaint(Shape2f r) {
        if (r != null) {
            Rectangle2f bounds = r.toBoundingBox();
            this.repaint(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        }
    }

    public final boolean isMoveDirectionInverted() {
        return this.isInvertScrollingDirection;
    }

    public final void setMoveDirectionInverted(boolean invert) {
        this.isInvertScrollingDirection = invert;
    }

    public final float logical2pixel_size(float l) {
        return ZoomableContextUtil.logical2pixel_size((float)l, (float)this.scaleFactor);
    }

    public final float logical2pixel_x(float l) {
        return ZoomableContextUtil.logical2pixel_x((float)l, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public final float logical2pixel_y(float l) {
        return ZoomableContextUtil.logical2pixel_y((float)l, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public final float pixel2logical_size(float l) {
        return ZoomableContextUtil.pixel2logical_size((float)l, (float)this.scaleFactor);
    }

    public final float pixel2logical_x(float l) {
        return ZoomableContextUtil.pixel2logical_x((float)l, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public final float pixel2logical_y(float l) {
        return ZoomableContextUtil.pixel2logical_y((float)l, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public PathIterator2f logical2pixel(PathIterator2f p) {
        return ZoomableContextUtil.logical2pixel((PathIterator2f)p, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public PathIterator2f pixel2logical(PathIterator2f p) {
        return ZoomableContextUtil.pixel2logical((PathIterator2f)p, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void logical2pixel(Segment2f s) {
        ZoomableContextUtil.logical2pixel((Segment2f)s, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void pixel2logical(Segment2f s) {
        ZoomableContextUtil.pixel2logical((Segment2f)s, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void logical2pixel(RoundRectangle2f r) {
        ZoomableContextUtil.logical2pixel((RoundRectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void pixel2logical(RoundRectangle2f r) {
        ZoomableContextUtil.pixel2logical((RoundRectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void logical2pixel(Point2f p) {
        ZoomableContextUtil.logical2pixel((Point2f)p, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void pixel2logical(Point2f p) {
        ZoomableContextUtil.pixel2logical((Point2f)p, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void logical2pixel(Ellipse2f e) {
        ZoomableContextUtil.logical2pixel((Ellipse2f)e, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void pixel2logical(Ellipse2f e) {
        ZoomableContextUtil.pixel2logical((Ellipse2f)e, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void logical2pixel(Circle2f r) {
        ZoomableContextUtil.logical2pixel((Circle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void pixel2logical(Circle2f r) {
        ZoomableContextUtil.pixel2logical((Circle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void logical2pixel(Rectangle2f r) {
        ZoomableContextUtil.logical2pixel((Rectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public void pixel2logical(Rectangle2f r) {
        ZoomableContextUtil.pixel2logical((Rectangle2f)r, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public Shape2f logical2pixel(Shape2f s) {
        return ZoomableContextUtil.logical2pixel((Shape2f)s, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public Shape2f pixel2logical(Shape2f s) {
        return ZoomableContextUtil.pixel2logical((Shape2f)s, (CenteringTransform)this.centeringTransform, (float)this.scaleFactor);
    }

    public final float getScalingSensitivity() {
        return this.zoomingSensitivity;
    }

    public final void setScalingSensitivity(float sensivility) {
        this.zoomingSensitivity = Math.max(sensivility, Float.MIN_NORMAL);
    }

    public final float getViewportCenterX() {
        return (float)this.getViewport().getWidth() / 2.0f;
    }

    public final float getViewportCenterY() {
        return (float)this.getViewport().getHeight() / 2.0f;
    }

    public final float getFocusX() {
        return this.pixel2logical_x(this.getViewportCenterX());
    }

    public final float getFocusY() {
        return this.pixel2logical_y(this.getViewportCenterY());
    }

    public final float getScalingFactor() {
        return this.scaleFactor;
    }

    public final boolean setScalingFactor(float factor) {
        if (this.setScalingFactorAndFocus(Float.NaN, Float.NaN, factor)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public void setScalingFactorForPixelRatio(float ratio) {
        float onePixel = this.pixel2logical_size(1.0f);
        float factor = onePixel * ratio;
        this.setScalingFactor(factor);
    }

    protected final boolean setScalingFactorAndFocus(float scalingX, float scalingY, float factor) {
        float normalizedFactor = factor;
        if (normalizedFactor < this.minScaleFactor) {
            normalizedFactor = this.minScaleFactor;
        }
        if (normalizedFactor > this.maxScaleFactor) {
            normalizedFactor = this.maxScaleFactor;
        }
        if (!Float.isNaN(scalingX) && !Float.isNaN(scalingY)) {
            float screenCenterX = this.getViewportCenterX();
            float screenCenterY = this.getViewportCenterY();
            float vectorToScreenCenterX = screenCenterX - scalingX;
            float vectorToScreenCenterY = screenCenterY - scalingY;
            float sX = this.pixel2logical_x(scalingX);
            float sY = this.pixel2logical_y(scalingY);
            float newX = sX + vectorToScreenCenterX / normalizedFactor;
            float newY = sY + vectorToScreenCenterY / normalizedFactor;
            if (normalizedFactor != this.scaleFactor || newX != this.focusX || newY != this.focusY) {
                this.scaleFactor = normalizedFactor;
                this.focusX = newX;
                this.focusY = newY;
                this.onUpdateViewParameters();
                return true;
            }
        } else if (normalizedFactor != this.scaleFactor) {
            this.scaleFactor = normalizedFactor;
            this.onUpdateViewParameters();
            return true;
        }
        return false;
    }

    public final void zoomIn() {
        if (this.onScale(this.getViewportCenterX(), this.getViewportCenterY(), this.getScalingSensitivity())) {
            this.repaint();
        }
    }

    public final void zoomOut() {
        if (this.onScale(this.getViewportCenterX(), this.getViewportCenterY(), 1.0f / this.getScalingSensitivity())) {
            this.repaint();
        }
    }

    public final float getMaxScalingFactor() {
        return this.maxScaleFactor;
    }

    public final void setMaxScalingFactor(float factor) {
        if (factor > 0.0f && factor != this.maxScaleFactor) {
            this.maxScaleFactor = factor;
            if (this.minScaleFactor > this.maxScaleFactor) {
                this.minScaleFactor = this.maxScaleFactor;
            }
            if (this.scaleFactor > this.maxScaleFactor) {
                this.scaleFactor = this.maxScaleFactor;
            }
            this.repaint();
        }
    }

    public final float getMinScalingFactor() {
        return this.minScaleFactor;
    }

    public final void setMinScalingFactor(float factor) {
        if (factor > 0.0f && factor != this.minScaleFactor) {
            this.minScaleFactor = factor;
            if (this.maxScaleFactor < this.minScaleFactor) {
                this.maxScaleFactor = this.minScaleFactor;
            }
            if (this.scaleFactor < this.minScaleFactor) {
                this.scaleFactor = this.minScaleFactor;
            }
            this.repaint();
        }
    }

    public final void setFocusPoint(float x, float y) {
        if (this.focusX != x || this.focusY != y) {
            this.focusX = x;
            this.focusY = y;
            this.onUpdateViewParameters();
            this.repaint();
        }
    }

    public final void translateFocusPoint(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            this.focusX += dx;
            this.focusY += dy;
            this.onUpdateViewParameters();
            this.repaint();
        }
    }

    protected void onUpdateViewParameters() {
        float t = this.pixel2logical_size(this.getViewportCenterX());
        if (this.isXAxisInverted()) {
            this.centeringTransform.setCenteringX(true, -1.0f, t + this.focusX);
        } else {
            this.centeringTransform.setCenteringX(false, 1.0f, t - this.focusX);
        }
        t = this.pixel2logical_size(this.getViewportCenterY());
        if (this.isYAxisInverted()) {
            this.centeringTransform.setCenteringY(true, -1.0f, t + this.focusY);
        } else {
            this.centeringTransform.setCenteringY(false, 1.0f, t - this.focusY);
        }
    }

    protected abstract float getPreferredFocusX();

    protected abstract float getPreferredFocusY();

    public final boolean resetView() {
        float px = this.getPreferredFocusX();
        float py = this.getPreferredFocusY();
        if (this.focusX != px || this.focusY != py || this.getScalingFactor() != 1.0f) {
            this.focusX = px;
            this.focusY = py;
            if (!this.setScalingFactor(1.0f)) {
                this.onUpdateViewParameters();
                this.repaint();
            }
            return true;
        }
        return false;
    }

    public float getScalingFactorToFit() {
        Rectangle2f documentBounds;
        if (this.documentWrapper != null && (documentBounds = this.documentWrapper.getDocumentBounds()) != null) {
            JPanel viewport = this.getViewport();
            float drawingAreaSize = viewport.getWidth();
            float documentSize = documentBounds.getWidth();
            float horizontalFactor = ZoomableContextUtil.determineFactor((float)documentSize, (float)drawingAreaSize);
            drawingAreaSize = viewport.getHeight();
            documentSize = documentBounds.getHeight();
            float verticalFactor = ZoomableContextUtil.determineFactor((float)documentSize, (float)drawingAreaSize);
            return Math.min(horizontalFactor, verticalFactor);
        }
        return 1.0f;
    }

    public final boolean fitView() {
        float px = this.getPreferredFocusX();
        float py = this.getPreferredFocusY();
        float fitFactor = this.getScalingFactorToFit();
        if (this.focusX != px || this.focusY != py || this.getScalingFactor() != fitFactor) {
            this.focusX = px;
            this.focusY = py;
            if (!this.setScalingFactor(fitFactor)) {
                this.onUpdateViewParameters();
                this.repaint();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result;
        Graphics2DLOD lod = this.setLOD(Graphics2DLOD.HIGH_LEVEL_OF_DETAIL);
        try {
            if (pageIndex == 0) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                float width = this.getViewport().getWidth();
                float height = this.getViewport().getHeight();
                float pageWidth = (float)pageFormat.getImageableWidth();
                float pageHeight = (float)pageFormat.getImageableHeight();
                float scale = pageWidth / width > pageHeight / height ? pageHeight / height : pageWidth / width;
                g2d.setColor(Color.BLACK);
                g2d.drawRect(0, 0, (int)pageWidth, (int)pageHeight);
                g2d.scale(scale, scale);
                this.print(g2d, new Rectangle2D.Float(0.0f, 0.0f, width, height));
                result = 0;
            } else {
                result = 1;
            }
        }
        finally {
            this.setLOD(lod);
        }
        return result;
    }

    protected final void print(Graphics2D g, Rectangle2D print_area) {
        float width = this.getViewport().getWidth();
        float height = this.getViewport().getHeight();
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, width, height).createIntersection(print_area);
        g.translate(-r.getX(), -r.getY());
        this.print(g);
    }

    @Override
    public final void print(Graphics g) {
        Graphics2DLOD lod = this.setLOD(Graphics2DLOD.HIGH_LEVEL_OF_DETAIL);
        try {
            super.print(g);
        }
        finally {
            this.setLOD(lod);
        }
    }

    @Override
    public final void printAll(Graphics g) {
        Graphics2DLOD lod = this.setLOD(Graphics2DLOD.HIGH_LEVEL_OF_DETAIL);
        try {
            super.printAll(g);
        }
        finally {
            this.setLOD(lod);
        }
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
        if (this.viewport == null) {
            this.onDrawView((Graphics2D)g, this.scaleFactor, this.centeringTransform);
        }
    }

    protected abstract void onDrawView(Graphics2D var1, float var2, CenteringTransform var3);

    protected void onKeyTyped(KeyEvent e) {
    }

    protected void onKeyPressed(KeyEvent e) {
    }

    protected void onKeyReleased(KeyEvent e) {
    }

    protected void onPointerPressed(PointerEvent e) {
    }

    protected void onPointerReleased(PointerEvent e) {
    }

    protected void onPointerDragged(PointerEvent e) {
    }

    protected void onPointerMoved(PointerEvent e) {
    }

    protected void onLongClick(PointerEvent e) {
    }

    protected void onClick(PointerEvent e) {
    }

    protected boolean onScale(float focusX, float focusY, float requestedScaleFactor) {
        this.setScalingFactorAndFocus(focusX, focusY, this.scaleFactor * requestedScaleFactor);
        return true;
    }

    private class SwingEventHandler
    implements ComponentListener,
    MouseInputListener,
    MouseWheelListener,
    ScrollingMethod.ScrollingMethodListener,
    AdjustmentListener,
    ChangeListener,
    KeyListener {
        private int bufferedWheelClicks = 0;
        private volatile ScrollWaiter scrollWaiter = null;
        private boolean mouseScrollingUnderProgress = false;
        private int mouseX = -1;
        private int mouseY = -1;
        private Graphics2DLOD previousLOD = null;

        @Override
        public void componentResized(ComponentEvent e) {
            ZoomableView.this.onUpdateViewParameters();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ZoomableView.this.onUpdateViewParameters();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            boolean isLongClick = e.getClickCount() > 1;
            PointerEventSwing evt = new PointerEventSwing(e);
            if (isLongClick) {
                ZoomableView.this.onLongClick(evt);
            } else {
                ZoomableView.this.onClick(evt);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            ZoomableView.this.getScrollingMethod().tryScroll(e, this);
            if (!e.isConsumed()) {
                ZoomableView.this.onPointerPressed(new PointerEventSwing(e));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.stopScrolling(e);
            if (!e.isConsumed()) {
                ZoomableView.this.onPointerReleased(new PointerEventSwing(e));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.mouseScrollingUnderProgress && this.scrollWaiter != null) {
                this.scrollWaiter = null;
                this.startScrolling(e, 0);
            }
            if (this.mouseScrollingUnderProgress) {
                Rectangle2f document_rect = ZoomableView.this.documentWrapper.getDocumentBounds();
                if (document_rect != null) {
                    float dy;
                    float dx;
                    if (ZoomableView.this.isMoveDirectionInverted()) {
                        dx = ZoomableView.this.pixel2logical_size(this.mouseX - e.getX());
                        dy = ZoomableView.this.pixel2logical_size(this.mouseY - e.getY());
                    } else {
                        dx = ZoomableView.this.pixel2logical_size(e.getX() - this.mouseX);
                        dy = ZoomableView.this.pixel2logical_size(e.getY() - this.mouseY);
                    }
                    if (dx != 0.0f || dy != 0.0f) {
                        float fx = ZoomableView.this.getFocusX() - dx;
                        float fy = ZoomableView.this.getFocusY() - dy;
                        ZoomableView.this.setFocusPoint(fx, fy);
                    }
                }
                e.consume();
            }
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            if (!e.isConsumed()) {
                ZoomableView.this.onPointerDragged(new PointerEventSwing(e));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            ZoomableView.this.onPointerMoved(new PointerEventSwing(e));
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            if (ZoomableView.this.isMouseWheelAllowed()) {
                float fy;
                float fx;
                int clicks = e.getWheelRotation() + this.bufferedWheelClicks;
                if (e.isControlDown() || ZoomableView.this.isFocusChangedOnMouseWheel()) {
                    fx = e.getX();
                    fy = e.getY();
                } else {
                    fx = ZoomableView.this.getViewportCenterX();
                    fy = ZoomableView.this.getViewportCenterY();
                }
                float scale = ZoomableView.this.getScalingSensitivity();
                if (clicks >= 0) {
                    scale = 1.0f / scale;
                }
                if (ZoomableView.this.onScale(fx, fy, (float)Math.abs(clicks) * scale)) {
                    this.bufferedWheelClicks = 0;
                    ZoomableView.this.repaint();
                } else {
                    this.bufferedWheelClicks = clicks;
                }
                e.consume();
            }
        }

        @Override
        public void startScrolling(MouseEvent event, int delay) {
            if (delay <= 0) {
                this.mouseScrollingUnderProgress = true;
                this.previousLOD = ZoomableView.this.setLOD(Graphics2DLOD.LOW_LEVEL_OF_DETAIL);
                ZoomableView.this.setCursor(Cursor.getPredefinedCursor(12));
                event.consume();
                this.mouseX = event.getX();
                this.mouseY = event.getY();
            } else if (this.scrollWaiter == null) {
                this.scrollWaiter = new ScrollWaiter(event, System.currentTimeMillis() + (long)delay);
                SwingUtilities.invokeLater(this.scrollWaiter);
            }
        }

        @Override
        public void stopScrolling(MouseEvent event) {
            this.scrollWaiter = null;
            if (this.mouseScrollingUnderProgress) {
                this.mouseScrollingUnderProgress = false;
                ZoomableView.this.setLOD(this.previousLOD);
                ZoomableView.this.setCursor(Cursor.getDefaultCursor());
                event.consume();
                ZoomableView.this.repaint();
                this.mouseX = event.getX();
                this.mouseY = event.getY();
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (ZoomableView.this.isScrollbarEnabled.get()) {
                ZoomableView.this.setLOD(e.getValueIsAdjusting() ? Graphics2DLOD.LOW_LEVEL_OF_DETAIL : Graphics2DLOD.NORMAL_LEVEL_OF_DETAIL);
                float fx = ZoomableView.this.getFocusX();
                float fy = ZoomableView.this.getFocusY();
                Rectangle2f document_rect = ZoomableView.this.documentWrapper.getDocumentBounds();
                if (document_rect != null) {
                    Rectangle viewport = ZoomableView.this.getViewport().getBounds();
                    if (e.getSource() == ZoomableView.this.vscroll) {
                        fy = ZoomableView.this.pixel2logical_y((float)e.getValue() + (float)((RectangularShape)viewport).getHeight() / 2.0f);
                    } else if (e.getSource() == ZoomableView.this.hscroll) {
                        fx = ZoomableView.this.pixel2logical_x((float)e.getValue() + (float)((RectangularShape)viewport).getWidth() / 2.0f);
                    }
                    ZoomableView.this.setFocusPoint(fx, fy);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ZoomableView.this.updateScrollbars();
        }

        @Override
        public void keyTyped(java.awt.event.KeyEvent e) {
            ZoomableView.this.onKeyTyped(new KeyEventSwing(e));
        }

        @Override
        public void keyPressed(java.awt.event.KeyEvent e) {
            ZoomableView.this.onKeyPressed(new KeyEventSwing(e));
        }

        @Override
        public void keyReleased(java.awt.event.KeyEvent e) {
            ZoomableView.this.onKeyReleased(new KeyEventSwing(e));
        }

        private class ScrollWaiter
        implements Runnable {
            private final long timeout;
            private final MouseEvent event;

            public ScrollWaiter(MouseEvent event, long timeout) {
                this.event = event;
                this.timeout = timeout;
            }

            @Override
            public void run() {
                if (System.currentTimeMillis() >= this.timeout) {
                    SwingEventHandler.this.startScrolling(this.event, 0);
                } else if (SwingEventHandler.this.scrollWaiter == this) {
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }

    private class Viewport
    extends JPanel {
        private static final long serialVersionUID = -4516500471311375616L;

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ZoomableView.this.onDrawView((Graphics2D)g, ZoomableView.this.scaleFactor, ZoomableView.this.centeringTransform);
        }
    }
}

