/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.neteditor.figlayout;

import java.util.ArrayList;
import java.util.List;
import org.arakhne.afc.math.continous.object2d.Point2f;
import org.arakhne.afc.ui.undo.AbstractUndoable;
import org.arakhne.afc.ui.undo.Undoable;
import org.arakhne.neteditor.fig.figure.Figure;
import org.arakhne.neteditor.fig.figure.edge.EdgeFigure;

public class FigureLayoutUndoableEdit
extends AbstractUndoable {
    private static final long serialVersionUID = 5414039762016942941L;
    private final List<Change> changes = new ArrayList<Change>();
    private final String name;

    public FigureLayoutUndoableEdit(String name) {
        this.name = name;
    }

    public String getPresentationName() {
        return this.name;
    }

    public void add(Undoable edit) {
        if (edit != null) {
            if (edit instanceof FigureLayoutUndoableEdit) {
                this.changes.addAll(((FigureLayoutUndoableEdit)edit).changes);
            } else {
                this.changes.add(new WrapChange(edit));
            }
        }
    }

    public void addLocationChange(Figure figure, float x, float y) {
        this.changes.add(new PositionChange(figure, x, y));
    }

    public void addControlPointRemoval(EdgeFigure<?> figure, int position) {
        this.changes.add(new ControlPointRemoval(figure, position));
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    protected void doEdit() {
        for (Change c : this.changes) {
            c.doEdit();
        }
    }

    protected void undoEdit() {
        for (int i = this.changes.size() - 1; i >= 0; --i) {
            this.changes.get(i).undoEdit();
        }
    }

    private static class WrapChange
    implements Change {
        private final Undoable edit;

        public WrapChange(Undoable edit) {
            this.edit = edit;
        }

        @Override
        public void doEdit() {
            this.edit.redo();
        }

        @Override
        public void undoEdit() {
            this.edit.undo();
        }
    }

    private static class ControlPointRemoval
    implements Change {
        private final EdgeFigure<?> figure;
        private final int position;
        private final float ox;
        private final float oy;

        public ControlPointRemoval(EdgeFigure<?> f, int position) {
            this.figure = f;
            this.position = position;
            Point2f p = f.getCtrlPointAt(position);
            this.ox = p.getX();
            this.oy = p.getY();
        }

        @Override
        public void doEdit() {
            this.figure.removeCtrlPointAt(this.position);
        }

        @Override
        public void undoEdit() {
            this.figure.insertCtrlPointAt(this.position, this.ox, this.oy);
        }
    }

    private static class PositionChange
    implements Change {
        private final Figure figure;
        private final float ox;
        private final float oy;
        private final float nx;
        private final float ny;

        public PositionChange(Figure f, float x2, float y2) {
            this.figure = f;
            this.ox = f.getX();
            this.oy = f.getY();
            this.nx = x2;
            this.ny = y2;
        }

        @Override
        public void doEdit() {
            this.figure.setLocation(this.nx, this.ny);
        }

        @Override
        public void undoEdit() {
            this.figure.setLocation(this.ox, this.oy);
        }
    }

    private static interface Change {
        public void doEdit();

        public void undoEdit();
    }
}

