/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.neteditor.figlayout.basic;

import java.util.Collection;
import org.arakhne.afc.ui.undo.Undoable;
import org.arakhne.afc.ui.vector.Margins;
import org.arakhne.afc.vmutil.locale.Locale;
import org.arakhne.neteditor.fig.figure.Figure;
import org.arakhne.neteditor.fig.figure.coercion.CoercedFigure;
import org.arakhne.neteditor.fig.figure.edge.EdgeFigure;
import org.arakhne.neteditor.figlayout.AbstractDirectionBasedFigureLayout;
import org.arakhne.neteditor.figlayout.FigureLayoutUndoableEdit;

public class BasicGridBagFigureLayout
extends AbstractDirectionBasedFigureLayout {
    @Override
    public Undoable layoutFigures(Collection<? extends Figure> figures) {
        FigureLayoutUndoableEdit undo = new FigureLayoutUndoableEdit(Locale.getString(BasicGridBagFigureLayout.class, (String)"UNDO_NAME", (Object[])new Object[0]));
        if (!figures.isEmpty()) {
            int ncolumns = (int)Math.sqrt(figures.size());
            assert (ncolumns >= 1);
            float x = this.getOrigin().getX();
            float y = this.getOrigin().getY();
            float max = 0.0f;
            int c = 0;
            Margins insets = this.getMargins();
            switch (this.getLayoutDirection()) {
                case HORIZONTAL: {
                    for (Figure figure : figures) {
                        float size;
                        if (figure instanceof EdgeFigure) {
                            EdgeFigure edgeFigure = (EdgeFigure)figure;
                            while (edgeFigure.getCtrlPointCount() > 2) {
                                undo.addControlPointRemoval(edgeFigure, 1);
                                edgeFigure.removeCtrlPointAt(1);
                            }
                            continue;
                        }
                        if (figure instanceof CoercedFigure) continue;
                        if (c >= ncolumns) {
                            x = this.getOrigin().getX();
                            y += max;
                            max = 0.0f;
                            c = 0;
                        }
                        if ((size = figure.getHeight() + insets.top() + insets.bottom()) > max) {
                            max = size;
                        }
                        undo.addLocationChange(figure, x += insets.left(), y + insets.top());
                        figure.setLocation(x, y + insets.top());
                        x += insets.right();
                        ++c;
                    }
                    break;
                }
                case VERTICAL: {
                    for (Figure figure : figures) {
                        float size;
                        if (figure instanceof EdgeFigure) {
                            EdgeFigure edgeFigure = (EdgeFigure)figure;
                            while (edgeFigure.getCtrlPointCount() > 2) {
                                undo.addControlPointRemoval(edgeFigure, 1);
                                edgeFigure.removeCtrlPointAt(1);
                            }
                            continue;
                        }
                        if (figure instanceof CoercedFigure) continue;
                        if (c >= ncolumns) {
                            y = this.getOrigin().getY();
                            x += max;
                            max = 0.0f;
                            c = 0;
                        }
                        if ((size = figure.getWidth() + insets.left() + insets.right()) > max) {
                            max = size;
                        }
                        undo.addLocationChange(figure, x + insets.left(), y += insets.top());
                        figure.setLocation(x + insets.left(), y);
                        y += insets.bottom();
                        ++c;
                    }
                    break;
                }
            }
        }
        if (undo.isEmpty()) {
            return null;
        }
        return undo;
    }
}

