/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.neteditor.figlayout.force;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import org.arakhne.afc.math.continous.object2d.Point2f;
import org.arakhne.afc.math.continous.object2d.Shape2f;
import org.arakhne.afc.math.continous.object2d.Vector2f;
import org.arakhne.afc.math.generic.Point2D;
import org.arakhne.afc.math.generic.Vector2D;
import org.arakhne.afc.ui.undo.Undoable;
import org.arakhne.afc.ui.vector.Margins;
import org.arakhne.afc.vmutil.locale.Locale;
import org.arakhne.neteditor.fig.figure.Figure;
import org.arakhne.neteditor.fig.figure.coercion.CoercedFigure;
import org.arakhne.neteditor.fig.figure.decoration.DecorationFigure;
import org.arakhne.neteditor.fig.figure.edge.EdgeFigure;
import org.arakhne.neteditor.fig.figure.node.NodeFigure;
import org.arakhne.neteditor.figlayout.AbstractFigureLayout;
import org.arakhne.neteditor.figlayout.FigureLayoutUndoableEdit;
import org.arakhne.neteditor.figlayout.force.FigureMassCalculator;
import org.arakhne.neteditor.figlayout.force.ForceBasedConstants;
import org.arakhne.neteditor.formalism.Edge;
import org.arakhne.neteditor.formalism.ModelObject;
import org.arakhne.neteditor.formalism.Node;

public class ForceBasedFigureLayout
extends AbstractFigureLayout
implements ForceBasedConstants {
    private FigureMassCalculator massCalculator = null;
    private float randomSpaceSize = 1000.0f;
    private float maxKinematicEnergy = 0.2f;
    private float damping = 0.8f;
    private float timestep = 1.0f;
    private float coulombConstant = 10.0f;
    private float springConstant = 0.001f;
    private float preferredInterNodeSpace = 40.0f;

    public void setPreferredInterNodeSpace(float space) {
        if (space > 0.0f) {
            this.preferredInterNodeSpace = space;
        }
    }

    public float getPreferredInterNodeSpace() {
        return this.preferredInterNodeSpace;
    }

    public void setNodeMassCalculator(FigureMassCalculator calculator) {
        this.massCalculator = calculator;
    }

    public FigureMassCalculator getNodeMassCalculator() {
        return this.massCalculator;
    }

    public float getRandomCoordinateSpaceSize() {
        return this.randomSpaceSize;
    }

    public void setRandomCoordinateSpaceSize(float size) {
        if (size >= 0.0f) {
            this.randomSpaceSize = size;
        }
    }

    public float getMaximalKinematicEnergy() {
        return this.maxKinematicEnergy;
    }

    public void setMaximalKinematicEnergy(float energy) {
        if (energy > 0.0f) {
            this.maxKinematicEnergy = energy;
        }
    }

    public float getCoulombConstant() {
        return this.coulombConstant;
    }

    public void setCoulombConstant(float k) {
        if (k > 0.0f) {
            this.coulombConstant = k;
        }
    }

    public float getSpringConstant() {
        return this.springConstant;
    }

    public void setSpringConstant(float k) {
        if (k > 0.0f) {
            this.springConstant = k;
        }
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float damping) {
        this.damping = damping <= 0.0f ? Float.MIN_NORMAL : (damping >= 1.0f ? 1.0f : damping);
    }

    public float getTimeStep() {
        return this.timestep;
    }

    public void setTimeStep(float step) {
        if (step > 0.0f) {
            this.timestep = step;
        }
    }

    @Override
    public Undoable layoutFigures(Collection<? extends Figure> figures) {
        float totalKineticEnergy;
        FigureLayoutUndoableEdit undo = new FigureLayoutUndoableEdit(Locale.getString(ForceBasedFigureLayout.class, (String)"UNDO_NAME", (Object[])new Object[0]));
        Random random = new Random();
        float kOfCoulomb = this.getCoulombConstant();
        float kOfSpring = this.getSpringConstant();
        float timestep = this.getTimeStep();
        float damping = this.getDamping();
        float threshold = this.getMaximalKinematicEnergy();
        float interNodeSpace = this.getPreferredInterNodeSpace();
        Margins insets = this.getMargins();
        Point2D origin = this.getOrigin();
        FigureMassCalculator calculator = this.getNodeMassCalculator();
        float barycenterY = 0.0f;
        float barycenterX = 0.0f;
        TreeMap<ModelObject, LayoutNode> nodes = new TreeMap<ModelObject, LayoutNode>();
        ArrayList<LayoutNode> allNodes = new ArrayList<LayoutNode>();
        TreeMap<Edge, EdgeFigure> allEdges = new TreeMap<Edge, EdgeFigure>();
        for (Figure figure : figures) {
            if (figure instanceof NodeFigure) {
                NodeFigure nodeFigure = (NodeFigure)figure;
                LayoutNode n = new LayoutNode(origin.getX() + (random.nextFloat() - random.nextFloat()) * this.getRandomCoordinateSpaceSize(), origin.getY() + (random.nextFloat() - random.nextFloat()) * this.getRandomCoordinateSpaceSize(), figure, calculator == null ? 1.0f : calculator.computeMassFor(figure));
                nodes.put(nodeFigure.getModelObject(), n);
                allNodes.add(n);
                barycenterX += n.getCenterX();
                barycenterY += n.getCenterY();
                for (Edge edge : ((Node)nodeFigure.getModelObject()).getEdges()) {
                    EdgeFigure edgeFigure = (EdgeFigure)edge.getViewBinding().getView(figure.getViewUUID(), EdgeFigure.class);
                    if (edgeFigure == null) continue;
                    allEdges.put(edge, edgeFigure);
                }
                continue;
            }
            if (!(figure instanceof DecorationFigure) || figure instanceof CoercedFigure) continue;
            LayoutNode n = new LayoutNode(origin.getX() + (random.nextFloat() - random.nextFloat()) * this.getRandomCoordinateSpaceSize(), origin.getY() + (random.nextFloat() - random.nextFloat()) * this.getRandomCoordinateSpaceSize(), figure, calculator == null ? 1.0f : calculator.computeMassFor(figure));
            allNodes.add(n);
            barycenterX += n.getCenterX();
            barycenterY += n.getCenterY();
        }
        if (allNodes.isEmpty()) {
            return null;
        }
        Point2f centerMassPoint = new Point2f();
        Vector2f vector2f = new Vector2f();
        do {
            centerMassPoint.set(barycenterX /= (float)allNodes.size(), barycenterY /= (float)allNodes.size());
            barycenterY = 0.0f;
            barycenterX = 0.0f;
            totalKineticEnergy = 0.0f;
            for (LayoutNode node : allNodes) {
                Vector2D d;
                vector2f.set(0.0f, 0.0f);
                for (LayoutNode layoutNode : allNodes) {
                    if (node == layoutNode) continue;
                    d = ForceBasedFigureLayout.computeCoulombRepulsion(node, layoutNode, kOfCoulomb);
                    vector2f.add(d);
                }
                for (Map.Entry entry : allEdges.entrySet()) {
                    if (((Edge)entry.getKey()).getStartAnchor().getNode() == node.getNode() || ((Edge)entry.getKey()).getEndAnchor().getNode() == node.getNode()) continue;
                    d = ForceBasedFigureLayout.computeCoulombRepulsion(node, (Edge)entry.getKey(), (EdgeFigure)entry.getValue(), kOfCoulomb);
                    vector2f.add(d);
                }
                if (node.isNodeFigure()) {
                    for (Edge edge : node.getNode().getEdges()) {
                        EdgeFigure springFigure = (EdgeFigure)edge.getViewBinding().getView(node.getView(), EdgeFigure.class);
                        if (springFigure != null) {
                            while (springFigure.getCtrlPointCount() > 2) {
                                undo.addControlPointRemoval(springFigure, 1);
                                springFigure.removeCtrlPointAt(1);
                            }
                        }
                        Node otherSideNode = edge.getOtherSideFrom(node.getNode());
                        LayoutNode otherSide = (LayoutNode)nodes.get(otherSideNode);
                        d = ForceBasedFigureLayout.computeHookeAttraction(node, otherSide, edge, kOfSpring, insets, interNodeSpace);
                        vector2f.add(d);
                    }
                } else {
                    d = ForceBasedFigureLayout.computeHookeAttraction(node, (Point2D)centerMassPoint, kOfSpring, insets);
                    vector2f.add(d);
                }
                node.velocity.add(vector2f.getX() * timestep, vector2f.getY() * timestep);
                node.velocity.scale(damping);
                node.setX(node.getX() + timestep * node.velocity.getX());
                node.setY(node.getY() + timestep * node.velocity.getY());
                totalKineticEnergy += node.mass * node.velocity.lengthSquared();
                barycenterX += node.getCenterX();
                barycenterY += node.getCenterY();
            }
        } while (totalKineticEnergy > threshold);
        if (!Double.isNaN(totalKineticEnergy) && !Double.isInfinite(totalKineticEnergy)) {
            for (LayoutNode node : nodes.values()) {
                undo.addLocationChange(node.getFigure(), node.getX(), node.getY());
                node.getFigure().setLocation(node.getX(), node.getY());
            }
        }
        if (undo.isEmpty()) {
            return null;
        }
        return undo;
    }

    private static Vector2D computeCoulombRepulsion(LayoutNode from, LayoutNode to, float coulombConstant) {
        float rx = from.getCenterX() - to.getCenterX();
        float ry = from.getCenterY() - to.getCenterY();
        float squaredDistance = rx * rx + ry * ry;
        float length = (float)Math.sqrt(squaredDistance);
        float F = Math.max(-0.0f, coulombConstant / squaredDistance);
        return new Vector2f(rx * F / length, ry * F / length);
    }

    private static Vector2D computeCoulombRepulsion(LayoutNode from, Edge<?, ?, ?, ?> edge, EdgeFigure<?> edgeFigure, float coulombConstant) {
        float rx = 0.0f;
        float ry = 0.0f;
        if (from.getFigure().intersects((Shape2f)edgeFigure.getBounds())) {
            Point2D pts = edgeFigure.getNearestPointTo(from.getCenterX(), from.getCenterY());
            rx = from.getCenterX() - pts.getX();
            ry = from.getCenterY() - pts.getY();
            float squaredDistance = rx * rx + ry * ry;
            float length = (float)Math.sqrt(squaredDistance);
            float boxSize = Math.max(from.getFigure().getWidth(), from.getFigure().getHeight());
            boxSize *= boxSize;
            if (length <= (boxSize = (float)Math.sqrt(boxSize + boxSize))) {
                float F = Math.max(0.0f, coulombConstant / squaredDistance);
                assert (F >= 0.0f);
                rx = rx * F / length;
                ry = ry * F / length;
            }
        }
        return new Vector2f(rx, ry);
    }

    private static Vector2D computeHookeAttraction(LayoutNode from, LayoutNode to, Edge<?, ?, ?, ?> spring, float springConstant, Margins insets, float interNodeSpace) {
        float displacementX = from.getMaxX() + insets.right() < to.getX() - insets.left() - interNodeSpace ? from.getMaxX() + insets.right() - (to.getX() - insets.left() - interNodeSpace) : (from.getX() - insets.left() > to.getMaxX() + insets.right() + interNodeSpace ? from.getX() - insets.left() - (to.getMaxX() + insets.right() + interNodeSpace) : 0.0f);
        float displacementY = from.getMaxY() + insets.bottom() < to.getY() - insets.top() - interNodeSpace ? from.getMaxY() + insets.bottom() - (to.getY() - insets.top() - interNodeSpace) : (from.getY() - insets.top() > to.getMaxY() + insets.bottom() + interNodeSpace ? from.getY() - insets.top() - (to.getMaxY() + insets.bottom() + interNodeSpace) : 0.0f);
        float Fx = -springConstant * displacementX;
        float Fy = -springConstant * displacementY;
        return new Vector2f(Fx, Fy);
    }

    private static Vector2D computeHookeAttraction(LayoutNode from, Point2D attractivePoint, float springConstant, Margins insets) {
        float displacementX = attractivePoint.getX() < from.getX() - insets.left() || attractivePoint.getX() > from.getMaxX() + insets.right() ? from.getCenterX() - attractivePoint.getX() : 0.0f;
        float displacementY = attractivePoint.getY() < from.getY() - insets.top() || attractivePoint.getY() > from.getMaxY() + insets.bottom() ? from.getCenterY() - attractivePoint.getY() : 0.0f;
        float Fx = -springConstant * displacementX;
        float Fy = -springConstant * displacementY;
        return new Vector2f(Fx, Fy);
    }

    private static class LayoutNode {
        private float x;
        private float y;
        private float centerX;
        private float centerY;
        private float maxX;
        private float maxY;
        public final Vector2D velocity = new Vector2f();
        public final float mass;
        private final Figure figure;

        public LayoutNode(float x, float y, Figure figure, float mass) {
            this.mass = mass;
            this.figure = figure;
            this.setX(x);
            this.setY(y);
        }

        public UUID getView() {
            return this.figure.getViewUUID();
        }

        public Figure getFigure() {
            return this.figure;
        }

        public boolean isNodeFigure() {
            return this.figure instanceof NodeFigure;
        }

        public Node<?, ?, ?, ?> getNode() {
            if (this.figure instanceof NodeFigure) {
                return (Node)((NodeFigure)this.figure).getModelObject();
            }
            return null;
        }

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
            float w = this.figure.getWidth();
            this.centerX = this.x + w / 2.0f;
            this.maxX = this.x + w;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
            float h = this.figure.getHeight();
            this.centerY = this.y + h / 2.0f;
            this.maxY = this.y + h;
        }

        public float getCenterX() {
            return this.centerX;
        }

        public float getCenterY() {
            return this.centerY;
        }

        public float getMaxX() {
            return this.maxX;
        }

        public float getMaxY() {
            return this.maxY;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("((LayoutNode:");
            b.append(this.figure);
            b.append("=(");
            b.append(this.x);
            b.append(";");
            b.append(this.y);
            b.append(")))");
            return b.toString();
        }
    }
}

