/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.neteditor.figlayout.sugiyama;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.arakhne.afc.math.generic.Point2D;
import org.arakhne.afc.references.WeakTreeSet;
import org.arakhne.afc.ui.undo.Undoable;
import org.arakhne.afc.ui.vector.Dimension;
import org.arakhne.afc.ui.vector.Margins;
import org.arakhne.afc.ui.vector.VectorToolkit;
import org.arakhne.afc.vmutil.locale.Locale;
import org.arakhne.neteditor.fig.figure.Figure;
import org.arakhne.neteditor.fig.figure.coercion.CoercedFigure;
import org.arakhne.neteditor.fig.figure.decoration.DecorationFigure;
import org.arakhne.neteditor.fig.figure.edge.EdgeFigure;
import org.arakhne.neteditor.fig.figure.node.NodeFigure;
import org.arakhne.neteditor.figlayout.AbstractDirectionBasedFigureLayout;
import org.arakhne.neteditor.figlayout.FigureLayoutDirection;
import org.arakhne.neteditor.figlayout.FigureLayoutUndoableEdit;
import org.arakhne.neteditor.figlayout.basic.BasicGridBagFigureLayout;
import org.arakhne.neteditor.formalism.Edge;
import org.arakhne.neteditor.formalism.Node;

public class GanswerSugiyamaFigureLayout
extends AbstractDirectionBasedFigureLayout {
    private float preferredInterLayerSpace = 40.0f;

    public float getPreferredInterLayerSpace() {
        return this.preferredInterLayerSpace;
    }

    public void setPreferredInterLayerSpace(float size) {
        this.preferredInterLayerSpace = Math.max(0.0f, size);
    }

    private static List<List<LayerNode>> layering(Iterable<? extends Figure> figures, FigureLayoutUndoableEdit undo) {
        ArrayList<List<LayerNode>> layers = new ArrayList<List<LayerNode>>();
        ArrayList<LayerNode> decorations = new ArrayList<LayerNode>();
        ArrayList<LayerNode> entryNodes = new ArrayList<LayerNode>();
        TreeSet consumedNodes = new TreeSet();
        layers.add(decorations);
        layers.add(entryNodes);
        Figure firstEncounteredNode = null;
        for (Figure figure : figures) {
            if (figure instanceof NodeFigure) {
                NodeFigure nodeFigure = (NodeFigure)figure;
                Node node = (Node)nodeFigure.getModelObject();
                if (node != null) {
                    if (firstEncounteredNode == null) {
                        firstEncounteredNode = figure;
                    }
                    if (node.hasIncomingEdges()) continue;
                    entryNodes.add(new LayerNode(1, entryNodes.size(), (Figure)nodeFigure));
                    consumedNodes.add(node);
                    continue;
                }
                decorations.add(new LayerNode(0, decorations.size(), (Figure)nodeFigure));
                continue;
            }
            if (figure instanceof EdgeFigure) {
                EdgeFigure edgeFigure = (EdgeFigure)figure;
                Edge edge = (Edge)edgeFigure.getModelObject();
                if (edge == null) {
                    decorations.add(new LayerNode(0, decorations.size(), (Figure)edgeFigure));
                }
                while (edgeFigure.getCtrlPointCount() > 2) {
                    undo.addControlPointRemoval(edgeFigure, 1);
                    edgeFigure.removeCtrlPointAt(1);
                }
                continue;
            }
            if (!(figure instanceof DecorationFigure) || figure instanceof CoercedFigure) continue;
            decorations.add(new LayerNode(0, decorations.size(), figure));
        }
        if (entryNodes.isEmpty() && firstEncounteredNode != null) {
            entryNodes.add(new LayerNode(1, entryNodes.size(), firstEncounteredNode));
        }
        if (entryNodes.isEmpty()) {
            layers.remove(1);
        } else {
            List<LayerNode> currentLayer = entryNodes;
            while (currentLayer != null && !currentLayer.isEmpty()) {
                List<LayerNode> list = GanswerSugiyamaFigureLayout.buildNextLayer(currentLayer, consumedNodes, undo);
                if (list != null && !list.isEmpty()) {
                    layers.add(list);
                }
                currentLayer = list;
            }
        }
        return layers;
    }

    private static LayerNode retreiveLayerNodeFor(Node<?, ?, ?, ?> node, List<LayerNode> layer) {
        for (LayerNode layerNode : layer) {
            if (layerNode.isEdge() || layerNode.getNode() != node) continue;
            return layerNode;
        }
        return null;
    }

    private static List<LayerNode> buildNextLayer(List<LayerNode> layer, Set<Node<?, ?, ?, ?>> consumed, FigureLayoutUndoableEdit undo) {
        ArrayList<LayerNode> nextLayer = new ArrayList<LayerNode>();
        for (LayerNode layerNode : layer) {
            NodeFigure targetFigure;
            Node targetNode;
            if (layerNode.isReference()) continue;
            if (layerNode.isEdge()) {
                if (layerNode.firstLayerno() + layerNode.referencedNodeDistance() > layerNode.layerno() + 1) {
                    LayerNode newLayerNode = new LayerNode(layerNode.layerno() + 1, nextLayer.size(), layerNode.getFigure(), layerNode.firstLayerno(), layerNode.referencedNodeDistance() - 1);
                    nextLayer.add(newLayerNode);
                    newLayerNode.addPredecessor(layerNode);
                    layerNode.addSuccessor(newLayerNode);
                    continue;
                }
                targetNode = layerNode.getEdge().getEndAnchor().getNode();
                targetFigure = (NodeFigure)targetNode.getViewBinding().getView(layerNode.getView(), NodeFigure.class);
                LayerNode alreadyIn = GanswerSugiyamaFigureLayout.retreiveLayerNodeFor(targetNode, nextLayer);
                if (alreadyIn != null) {
                    alreadyIn.addPredecessor(layerNode);
                    layerNode.addSuccessor(alreadyIn);
                    continue;
                }
                LayerNode newLayerNode = new LayerNode(layerNode.layerno() + 1, nextLayer.size(), (Figure)targetFigure);
                nextLayer.add(newLayerNode);
                newLayerNode.addPredecessor(layerNode);
                layerNode.addSuccessor(newLayerNode);
                continue;
            }
            Node<?, ?, ?, ?> node = layerNode.getNode();
            assert (node != null);
            for (Edge outgoingEdge : node.getOutgoingEdges()) {
                LayerNode newLayerNode;
                EdgeFigure edgeFigure = (EdgeFigure)outgoingEdge.getViewBinding().getView(layerNode.getView(), EdgeFigure.class);
                if (edgeFigure != null) {
                    while (edgeFigure.getCtrlPointCount() > 2) {
                        undo.addControlPointRemoval(edgeFigure, 1);
                        edgeFigure.removeCtrlPointAt(1);
                    }
                }
                if ((targetFigure = (NodeFigure)(targetNode = outgoingEdge.getOtherSideFrom(node)).getViewBinding().getView(layerNode.getView(), NodeFigure.class)) == null) continue;
                LayerNode alreadyIn = GanswerSugiyamaFigureLayout.retreiveLayerNodeFor(targetNode, layer);
                if (alreadyIn != null && !alreadyIn.isReference()) {
                    alreadyIn.setReference(1);
                    consumed.remove(targetNode);
                }
                if (consumed.contains(targetNode)) continue;
                alreadyIn = GanswerSugiyamaFigureLayout.retreiveLayerNodeFor(targetNode, nextLayer);
                if (alreadyIn != null) {
                    alreadyIn.addPredecessor(layerNode);
                    layerNode.addSuccessor(alreadyIn);
                    continue;
                }
                int maxDist = GanswerSugiyamaFigureLayout.getMaxDistance(node, targetNode);
                assert (maxDist >= 1);
                if (maxDist == 1) {
                    newLayerNode = new LayerNode(layerNode.layerno() + 1, nextLayer.size(), (Figure)targetFigure);
                    nextLayer.add(newLayerNode);
                    consumed.add(targetNode);
                } else {
                    newLayerNode = new LayerNode(layerNode.layerno() + 1, nextLayer.size(), (Figure)targetFigure, layerNode.firstLayerno(), maxDist);
                    nextLayer.add(newLayerNode);
                }
                newLayerNode.addPredecessor(layerNode);
                layerNode.addSuccessor(newLayerNode);
            }
        }
        return nextLayer;
    }

    private static int getMaxDistance(Node<?, ?, ?, ?> from, Node<?, ?, ?, ?> to) {
        TreeSet<MaxDistanceNodeCandidate> openList = new TreeSet<MaxDistanceNodeCandidate>();
        TreeSet closeList = new TreeSet();
        openList.add(new MaxDistanceNodeCandidate(null, from, 0));
        int max = -1;
        while (!openList.isEmpty()) {
            Iterator iterator = openList.iterator();
            MaxDistanceNodeCandidate e = (MaxDistanceNodeCandidate)iterator.next();
            iterator.remove();
            if (e.node == to) {
                if (e.distance > max) {
                    max = e.distance;
                }
                closeList.add(e.node);
                continue;
            }
            boolean inCloseList = closeList.contains(e.node);
            if (inCloseList && e.isLoop()) continue;
            for (Edge edge : e.node.getOutgoingEdges()) {
                Node targetNode = edge.getOtherSideFrom(e.node);
                MaxDistanceNodeCandidate old = GanswerSugiyamaFigureLayout.removeIn(targetNode, openList);
                if (old == null || old.distance < e.distance + 1) {
                    openList.add(new MaxDistanceNodeCandidate(e, targetNode, e.distance + 1));
                    continue;
                }
                openList.add(old);
            }
            if (inCloseList) continue;
            closeList.add(e.node);
        }
        openList.clear();
        closeList.clear();
        return max;
    }

    private static MaxDistanceNodeCandidate removeIn(Node<?, ?, ?, ?> node, SortedSet<MaxDistanceNodeCandidate> s) {
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            MaxDistanceNodeCandidate c = (MaxDistanceNodeCandidate)iterator.next();
            if (c.node != node) continue;
            iterator.remove();
            return c;
        }
        return null;
    }

    private static float barycenter(LayerNode node, List<LayerNode> neighbors) {
        if (neighbors.isEmpty()) {
            return node.getPositionInLayer();
        }
        float barycenter = 0.0f;
        for (LayerNode neighbor : neighbors) {
            barycenter += (float)neighbor.getPositionInLayer();
        }
        return barycenter / (float)neighbors.size();
    }

    private static void adjustCoord(List<LayerNode> layer) {
        Collections.sort(layer, new WeightComparator());
        int i = 0;
        for (LayerNode node : layer) {
            node.setPositionInLayer(i);
            ++i;
        }
    }

    private static void ordering(List<List<LayerNode>> layers) {
        List<LayerNode> top = layers.get(1);
        for (int i = 2; i < layers.size(); ++i) {
            List<LayerNode> next = layers.get(i);
            for (LayerNode node : top) {
                node.setWeight(GanswerSugiyamaFigureLayout.barycenter(node, next));
            }
            GanswerSugiyamaFigureLayout.adjustCoord(top);
            for (LayerNode node : next) {
                node.setWeight(GanswerSugiyamaFigureLayout.barycenter(node, top));
            }
            GanswerSugiyamaFigureLayout.adjustCoord(next);
        }
    }

    private static Dimension getLayerDimension(List<LayerNode> layer, FigureLayoutDirection direction, Margins insets, float layerSpace) {
        float maxW = 0.0f;
        float maxH = 0.0f;
        switch (direction) {
            case HORIZONTAL: {
                float vSpace = Math.max(layerSpace, insets.top() + insets.bottom());
                for (LayerNode node : layer) {
                    if (node.isEdge()) continue;
                    Figure figure = node.getFigure();
                    maxW += figure.getWidth() + insets.left() + insets.right();
                    float s = figure.getHeight() + vSpace;
                    if (!(s > maxH)) continue;
                    maxH = s;
                }
                break;
            }
            case VERTICAL: {
                float hSpace = Math.max(layerSpace, insets.left() + insets.right());
                for (LayerNode node : layer) {
                    if (node.isEdge()) continue;
                    Figure figure = node.getFigure();
                    float s = figure.getWidth() + hSpace;
                    if (s > maxW) {
                        maxW = s;
                    }
                    maxH += figure.getHeight() + insets.top() + insets.bottom();
                }
                break;
            }
        }
        return VectorToolkit.dimension((float)maxW, (float)maxH);
    }

    private static void positioning(List<List<LayerNode>> layers, FigureLayoutDirection direction, Margins insets, Point2D origin, float layerSpace, FigureLayoutUndoableEdit undo) {
        float maxWidth = 0.0f;
        float maxHeight = 0.0f;
        int rows = layers.size();
        Dimension[] layerDimensions = new Dimension[rows];
        int[] length = new int[rows];
        for (int i = 0; i < rows; ++i) {
            length[i] = layers.get(i).size();
            layerDimensions[i] = GanswerSugiyamaFigureLayout.getLayerDimension(layers.get(i), direction, insets, layerSpace);
            if (layerDimensions[i].height() > maxHeight) {
                maxHeight = layerDimensions[i].height();
            }
            if (!(layerDimensions[i].width() > maxWidth)) continue;
            maxWidth = layerDimensions[i].width();
        }
        switch (direction) {
            case HORIZONTAL: {
                float y = origin.getY();
                for (int i = 0; i < rows; ++i) {
                    List<LayerNode> layer = layers.get(i);
                    float x = origin.getX();
                    float dspace = Math.max(0.0f, maxWidth - layerDimensions[i].width()) / (float)layer.size() / 2.0f;
                    for (LayerNode node : layer) {
                        if (node.isEdge()) continue;
                        Figure figure = node.getFigure();
                        undo.addLocationChange(figure, x += insets.left() + dspace, y + insets.top());
                        figure.setLocation(x, y + insets.top());
                        x += figure.getWidth() + insets.right() + dspace;
                    }
                    y += layerDimensions[i].height();
                }
                break;
            }
            case VERTICAL: {
                float x = origin.getX();
                for (int i = 0; i < rows; ++i) {
                    List<LayerNode> layer = layers.get(i);
                    float y = origin.getX();
                    float dspace = Math.max(0.0f, maxHeight - layerDimensions[i].height()) / (float)layer.size() / 2.0f;
                    for (LayerNode node : layer) {
                        if (node.isEdge()) continue;
                        Figure figure = node.getFigure();
                        undo.addLocationChange(figure, x + insets.left(), y += insets.top() + dspace);
                        figure.setLocation(x + insets.left(), y);
                        y += figure.getHeight() + insets.bottom() + dspace;
                    }
                    x += layerDimensions[i].width();
                }
                break;
            }
        }
    }

    @Override
    public Undoable layoutFigures(Collection<? extends Figure> figures) {
        FigureLayoutUndoableEdit undo = new FigureLayoutUndoableEdit(Locale.getString(GanswerSugiyamaFigureLayout.class, (String)"UNDO_NAME", (Object[])new Object[0]));
        List<List<LayerNode>> layers = GanswerSugiyamaFigureLayout.layering(figures, undo);
        switch (layers.size()) {
            case 0: {
                break;
            }
            case 1: {
                BasicGridBagFigureLayout gridLayout = new BasicGridBagFigureLayout();
                gridLayout.setLayoutDirection(this.getLayoutDirection());
                gridLayout.setMargins(this.getMargins());
                undo.add(gridLayout.layoutFigures(figures));
                break;
            }
            default: {
                GanswerSugiyamaFigureLayout.ordering(layers);
                GanswerSugiyamaFigureLayout.positioning(layers, this.getLayoutDirection(), this.getMargins(), this.getOrigin(), this.getPreferredInterLayerSpace(), undo);
            }
        }
        if (undo.isEmpty()) {
            return null;
        }
        return undo;
    }

    private static class MaxDistanceNodeCandidate
    implements Comparable<MaxDistanceNodeCandidate> {
        public final Node<?, ?, ?, ?> node;
        public final int distance;
        public final MaxDistanceNodeCandidate from;
        private Boolean isLoop = null;

        public MaxDistanceNodeCandidate(MaxDistanceNodeCandidate from, Node<?, ?, ?, ?> node, int distance) {
            this.node = node;
            this.distance = distance;
            this.from = from;
        }

        @Override
        public int compareTo(MaxDistanceNodeCandidate o) {
            if (o == null) {
                return Integer.MAX_VALUE;
            }
            int cmp = o.distance - this.distance;
            if (cmp != 0) {
                return cmp;
            }
            if (this.from != o.from) {
                if (this.from == null) {
                    return Integer.MIN_VALUE;
                }
                if (o.from == null) {
                    return Integer.MAX_VALUE;
                }
                cmp = this.from.compareTo(o.from);
                if (cmp != 0) {
                    return cmp;
                }
            }
            return this.node.compareTo(o.node);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.node);
            b.append("{");
            b.append(this.distance);
            b.append("}");
            return b.toString();
        }

        public boolean isLoop() {
            if (this.isLoop == null) {
                MaxDistanceNodeCandidate c = this.from;
                while (this.isLoop == null && c != null) {
                    if (c.node == this.node) {
                        this.isLoop = Boolean.TRUE;
                    }
                    c = c.from;
                }
                if (this.isLoop == null) {
                    this.isLoop = Boolean.FALSE;
                }
            }
            return this.isLoop;
        }
    }

    private static class WeightComparator
    implements Comparator<LayerNode> {
        @Override
        public int compare(LayerNode o1, LayerNode o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return Integer.MIN_VALUE;
            }
            if (o2 == null) {
                return Integer.MAX_VALUE;
            }
            int cmp = Float.compare(o1.getWeight(), o2.getWeight());
            if (cmp != 0) {
                return cmp;
            }
            return o1.getFigure().compareTo((Object)o2.getFigure());
        }
    }

    private static class LayerNode {
        private final int layerno;
        private final int startLayerno;
        private final Figure figure;
        private final Set<LayerNode> predecessors = new WeakTreeSet();
        private final Set<LayerNode> successors = new WeakTreeSet();
        private int referencedDistance;
        private float weight = 0.0f;
        private int positionInLayer;

        public LayerNode(int layerno, int position, Figure figure) {
            this.layerno = layerno;
            this.figure = figure;
            this.startLayerno = layerno;
            this.referencedDistance = -1;
            this.positionInLayer = position;
        }

        public LayerNode(int layerno, int position, Figure figure, int firstLayerno, int referencedDistance) {
            this.layerno = layerno;
            this.figure = figure;
            this.startLayerno = firstLayerno;
            this.referencedDistance = referencedDistance;
            this.positionInLayer = position;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float weight) {
            this.weight = weight;
        }

        public int getPositionInLayer() {
            return this.positionInLayer;
        }

        public void setPositionInLayer(int position) {
            this.positionInLayer = position;
        }

        public int referencedNodeDistance() {
            return this.referencedDistance;
        }

        public boolean isReference() {
            return this.referencedDistance >= 1;
        }

        public void setReference(int referencedDistance) {
            this.referencedDistance = Math.max(1, referencedDistance);
        }

        public UUID getView() {
            return this.figure.getViewUUID();
        }

        public void addPredecessor(LayerNode predecessor) {
            assert (predecessor.layerno() < this.layerno());
            this.predecessors.add(predecessor);
        }

        public void addSuccessor(LayerNode successor) {
            assert (successor.layerno() > this.layerno());
            this.successors.add(successor);
        }

        public int layerno() {
            return this.layerno;
        }

        public int firstLayerno() {
            return this.startLayerno;
        }

        public boolean isEdge() {
            return this.figure instanceof EdgeFigure;
        }

        public Node<?, ?, ?, ?> getNode() {
            if (this.figure instanceof NodeFigure) {
                return (Node)((NodeFigure)this.figure).getModelObject();
            }
            return null;
        }

        public Edge<?, ?, ?, ?> getEdge() {
            if (this.figure instanceof EdgeFigure) {
                return (Edge)((EdgeFigure)this.figure).getModelObject();
            }
            return null;
        }

        public Figure getFigure() {
            return this.figure;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("((LayerNode");
            if (this.isReference()) {
                b.append("->");
            } else {
                b.append(":");
            }
            b.append(this.figure.toString());
            b.append("))");
            return b.toString();
        }
    }
}

