/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.tinyMAS.core;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.arakhne.tinyMAS.core.AgentIdentifier;
import org.arakhne.tinyMAS.core.DefaultProbe;
import org.arakhne.tinyMAS.core.Kernel;
import org.arakhne.tinyMAS.core.Message;
import org.arakhne.tinyMAS.core.MessageTransportService;
import org.arakhne.tinyMAS.core.Probe;
import org.arakhne.tinyMAS.core.YellowPages;

@Deprecated
public abstract class Agent
implements Comparable<Agent> {
    private volatile AgentIdentifier __id = null;
    private boolean __started = false;
    private DefaultProbe __probe = null;

    protected void forceIdentifierStringRepresentation() {
        this.forceIdentifierStringRepresentation(this.toString());
    }

    protected void forceIdentifierStringRepresentation(String str) {
        if (this.__id != null) {
            this.__id.setStringRepresentation(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Probe getProbe() {
        Agent agent = this;
        synchronized (agent) {
            return this.__probe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProbe(String probeName, Object value) {
        Agent agent = this;
        synchronized (agent) {
            assert (probeName != null && !"".equals(probeName));
            if (value == null) {
                if (this.__probe != null) {
                    this.__probe.removeProbeValue(probeName);
                    if (!this.__probe.hasProbeValues()) {
                        this.__probe = null;
                    }
                }
            } else {
                if (this.__probe == null) {
                    this.__probe = new DefaultProbe(this);
                }
                this.__probe.putProbeValue(probeName, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearProbes() {
        Agent agent = this;
        synchronized (agent) {
            this.__probe.clearProbeValues();
            this.__probe = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProbe(String probeName) {
        Agent agent = this;
        synchronized (agent) {
            assert (probeName != null && !"".equals(probeName));
            if (this.__probe != null) {
                this.__probe.removeProbeValue(probeName);
                if (!this.__probe.hasProbeValues()) {
                    this.__probe = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllProbes() {
        Agent agent = this;
        synchronized (agent) {
            if (this.__probe != null) {
                this.__probe.clearProbeValues();
                this.__probe = null;
            }
        }
    }

    @Override
    public int compareTo(Agent a) {
        if (a == null || a.getId() == null) {
            return 1;
        }
        if (this.__id == null) {
            return -1;
        }
        return this.__id.compareTo(a.getId());
    }

    public boolean equals(Object o) {
        if (o != null && o == this) {
            return true;
        }
        if (o != null && o instanceof Agent) {
            return this.compareTo((Agent)o) == 0;
        }
        if (o != null && o instanceof AgentIdentifier) {
            return ((AgentIdentifier)o).compareTo(this.__id) == 0;
        }
        return false;
    }

    public final AgentIdentifier getId() {
        return this.__id;
    }

    void setId(AgentIdentifier id) {
        this.__id = id;
    }

    boolean isAlive() {
        return this.__started && this.__id != null;
    }

    final void start(AgentIdentifier id) {
        assert (id != null);
        this.__started = true;
        this.__id = id;
        this.start();
    }

    public void start() {
    }

    public abstract void live();

    public void stop() {
        this.__started = false;
        this.__id = null;
    }

    protected final boolean sendMessage(AgentIdentifier to, Serializable content) {
        assert (to != null);
        if (this.__id != null) {
            Message m = new Message(this.__id, to, content);
            return ((MessageTransportService)Kernel.getSingleton().getMTS()).send(m);
        }
        return false;
    }

    protected final Message getNextMessage() {
        if (this.__id != null) {
            return ((MessageTransportService)Kernel.getSingleton().getMTS()).getNextMessage(this.__id);
        }
        return null;
    }

    protected final boolean hasMessage() {
        if (this.__id != null) {
            return ((MessageTransportService)Kernel.getSingleton().getMTS()).hasMessage(this.__id);
        }
        return false;
    }

    protected final void killMe() {
        Kernel.getSingleton().killAgent(this.__id);
    }

    protected final double getSimulationTime() {
        return Kernel.getSingleton().getSimulationClock().getSimulationTime(TimeUnit.MILLISECONDS);
    }

    protected final double getSimulationTime(TimeUnit timeUnit) {
        assert (timeUnit != null);
        return Kernel.getSingleton().getSimulationClock().getSimulationTime(timeUnit);
    }

    protected final double getSimulationStepDuration() {
        return this.getSimulationStepDuration(TimeUnit.MILLISECONDS);
    }

    protected double getSimulationStepDuration(TimeUnit desired_unit) {
        assert (desired_unit != null);
        return Kernel.getSingleton().getSimulationClock().getSimulationStepDuration(desired_unit);
    }

    protected double perSecond(double quantity) {
        return this.getSimulationStepDuration(TimeUnit.SECONDS) * quantity;
    }

    protected final void registerService(String ... services) {
        Kernel<?, ?, ?, ?> k = Kernel.getSingleton();
        assert (k != null);
        assert (this.__id != null);
        Object yp = k.getYellowPageSystem();
        if (yp != null) {
            for (String service : services) {
                ((YellowPages)yp).registerService(service, this.__id);
            }
        }
    }

    protected final void unregisterService(String ... services) {
        Kernel<?, ?, ?, ?> k = Kernel.getSingleton();
        assert (k != null);
        assert (this.__id != null);
        Object yp = k.getYellowPageSystem();
        if (yp != null) {
            for (String service : services) {
                ((YellowPages)yp).unregisterService(service, this.__id);
            }
        }
    }
}

