/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.tinyMAS.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.arakhne.afc.references.WeakArrayList;
import org.arakhne.tinyMAS.core.Agent;
import org.arakhne.tinyMAS.core.AgentIdentifier;
import org.arakhne.tinyMAS.core.DefaultScheduler;
import org.arakhne.tinyMAS.core.Environment;
import org.arakhne.tinyMAS.core.KernelIdentifier;
import org.arakhne.tinyMAS.core.KernelListener;
import org.arakhne.tinyMAS.core.MessageTransportService;
import org.arakhne.tinyMAS.core.Probe;
import org.arakhne.tinyMAS.core.Scheduler;
import org.arakhne.tinyMAS.core.SimulationClock;
import org.arakhne.tinyMAS.core.WhitePages;
import org.arakhne.tinyMAS.core.YellowPages;

@Deprecated
public class Kernel<AT extends Agent, ET extends Environment<AT>, YP extends YellowPages, MTS extends MessageTransportService>
implements Runnable {
    public static final int TIME_PRECISION = 10;
    public static final int KERNEL_STOP_TIMEOUT = 20000;
    private static volatile Kernel<?, ?, ?, ?> SINGLETON;
    private final MTS __mts;
    private final WhitePages<AT> __whitepages;
    private final YP __yellowpages;
    private final KernelIdentifier __kernel_id;
    private final Scheduler<AT> __scheduler;
    private ET __environment;
    private volatile boolean __stopsimu = true;
    private volatile boolean __isUnderPause = false;
    private volatile boolean __in_shutdowning = false;
    private volatile boolean __is_shutdown = false;
    private long __simulation_time = 0L;
    private long __simulation_step_duration = 0L;
    private final List<KernelListener> __kernelListeners = new ArrayList<KernelListener>();
    private final List<AgentIdentifier> __agentsToKill = new WeakArrayList();
    private int __waitingTime = 0;
    private long __waitingTimeCountDown = 0L;

    public Kernel() {
        this(new MessageTransportService(), new WhitePages(), new YellowPages(), new DefaultScheduler(), null);
    }

    public Kernel(Scheduler<AT> scheduler) {
        this(new MessageTransportService(), new WhitePages(), new YellowPages(), scheduler, null);
    }

    public Kernel(MTS mts, Scheduler<AT> scheduler) {
        this(mts, new WhitePages(), new YellowPages(), new DefaultScheduler(), null);
    }

    public Kernel(MTS mts, WhitePages<AT> whitepages, YP yellowpages) {
        this(mts, whitepages, yellowpages, new DefaultScheduler(), null);
    }

    public Kernel(MTS mts, YP yellowpages) {
        this(mts, new WhitePages(), yellowpages, new DefaultScheduler(), null);
    }

    public Kernel(MTS mts, WhitePages<AT> whitepages, YP yellowpages, Scheduler<AT> scheduler) {
        this(mts, whitepages, yellowpages, scheduler, null);
    }

    public Kernel(MTS mts, YP yellowpages, Scheduler<AT> scheduler) {
        this(mts, new WhitePages(), yellowpages, scheduler, null);
    }

    public Kernel(ET env) {
        this(new MessageTransportService(), new WhitePages(), new YellowPages(), new DefaultScheduler(), env);
    }

    public Kernel(MTS mts, WhitePages<AT> whitepages, YP yellowpages, Scheduler<AT> scheduler, ET env) {
        assert (whitepages != null);
        assert (yellowpages != null);
        assert (mts != null);
        this.__kernel_id = ((MessageTransportService)mts).getKernelId();
        this.__mts = mts;
        this.__whitepages = whitepages;
        this.__yellowpages = yellowpages;
        this.__scheduler = scheduler;
        this.__environment = env;
        this.registerAsSingleton();
    }

    public static Kernel<?, ?, ?, ?> getSingleton() {
        return SINGLETON;
    }

    public boolean registerAsSingleton() {
        if (SINGLETON == null || Kernel.SINGLETON.__is_shutdown) {
            SINGLETON = this;
            return true;
        }
        return false;
    }

    MTS getMTS() {
        return this.__mts;
    }

    public ET getEnvironment() {
        return this.__environment;
    }

    public void setEnvironment(ET env) {
        this.__environment = env;
    }

    public void addAgent(Agent agent) {
        assert (agent != null);
        Agent a = agent;
        if (!this.__in_shutdowning) {
            this.__whitepages.register(a);
            AgentIdentifier id = this.__whitepages.getId(a);
            ((MessageTransportService)this.__mts).registerAgent(id);
            if (this.__environment != null) {
                this.__environment.putAgent((Agent)a);
            }
            if (!this.__stopsimu) {
                a.start(id);
                this.fireAgentAdded(id);
            }
        }
    }

    public void addAgent(AgentIdentifier id, AT a) {
        assert (id != null);
        assert (a != null);
        if (!this.__in_shutdowning) {
            this.__whitepages.register(id, a);
            ((MessageTransportService)this.__mts).registerAgent(id);
            if (this.__environment != null) {
                this.__environment.putAgent(a);
            }
            if (!this.__stopsimu) {
                ((Agent)a).start(id);
                this.fireAgentAdded(id);
            }
        }
    }

    void killAgent(AgentIdentifier id) {
        assert (id != null);
        this.__agentsToKill.add(id);
    }

    void removeAgent(AgentIdentifier id) {
        assert (id != null);
        this.removeAgent(id, true);
    }

    private void removeAgent(AgentIdentifier id, boolean notify) {
        assert (id != null);
        if (this.__environment != null) {
            this.__environment.removeAgent(id);
        }
        AT ag = this.__whitepages.unregister(id);
        ((MessageTransportService)this.__mts).unregisterAgent(id);
        if (this.__yellowpages != null) {
            ((YellowPages)this.__yellowpages).unregisterServices(id);
        }
        if (ag != null && !this.__in_shutdowning) {
            ((Agent)ag).stop();
        }
        if (!this.__stopsimu && notify) {
            this.fireAgentRemoved(id);
        }
    }

    void removeAllAgents() {
        AgentIdentifier[] ags;
        for (AgentIdentifier identifier : ags = this.__whitepages.getAllAgentIdentifiers()) {
            this.removeAgent(identifier, false);
        }
        if (!this.__stopsimu) {
            this.fireAgentRemoved(ags);
        }
    }

    AgentIdentifier getAgentId(AT a) {
        assert (a != null);
        return this.__whitepages.getId(a);
    }

    @Override
    public void run() {
        this.runInitializationStage();
        this.runAgentLifeStage();
        this.runShutdownStage();
    }

    private List<AT> getAliveAgents() {
        Collection<AT> c = this.__whitepages.getAllAgents();
        ArrayList<Agent> l = new ArrayList<Agent>();
        for (Agent at : c) {
            if (at == null || !at.isAlive()) continue;
            l.add(at);
        }
        return l;
    }

    private List<AT> getRegisteredAgents() {
        Collection<AT> c = this.__whitepages.getAllAgents();
        ArrayList<AT> l = new ArrayList<AT>();
        l.addAll(c);
        return l;
    }

    protected void runInitializationStage() {
        this.__in_shutdowning = false;
        this.__is_shutdown = false;
        this.__stopsimu = true;
        this.__isUnderPause = false;
        this.__simulation_time = 0L;
        this.__simulation_step_duration = System.currentTimeMillis();
        Kernel.displayKernelMessage("Initializing micro-kernel...");
        this.registerAsSingleton();
        Kernel.displayKernelMessage("\tstarting MTS...");
        ((MessageTransportService)this.__mts).startMTS();
        if (this.__environment != null) {
            Kernel.displayKernelMessage("\tinitializing environment...");
            this.__environment.init();
        }
        Kernel.displayKernelMessage("\tstarting agents...");
        this.startAgents(this.getRegisteredAgents());
        this.__simulation_step_duration = System.currentTimeMillis() - this.__simulation_step_duration;
    }

    protected void runAgentLifeStage() {
        Kernel.displayKernelMessage("Running micro-kernel...");
        this.__stopsimu = false;
        this.__simulation_time = 0L;
        this.fireKernelStarted();
        boolean previousPauseState = this.__isUnderPause;
        while (!this.isStopped()) {
            if (previousPauseState != this.__isUnderPause) {
                if (this.__isUnderPause) {
                    this.fireKernelPaused();
                } else {
                    this.fireKernelRestarted();
                }
                previousPauseState = this.__isUnderPause;
            }
            if (this.__isUnderPause) continue;
            long starting_date = System.currentTimeMillis();
            if (this.__waitingTime > 0 && this.__waitingTimeCountDown > starting_date) continue;
            if (this.__scheduler != null) {
                List<AT> agents = this.getAliveAgents();
                if (this.__environment != null) {
                    this.__scheduler.schedule(this, (Environment<AT>)this.__environment, agents);
                } else {
                    this.__scheduler.schedule(agents);
                }
            }
            if (this.__environment != null && !this.__environment.isAlive()) {
                Kernel.stopKernel();
            }
            if (!this.__agentsToKill.isEmpty()) {
                for (AgentIdentifier id : this.__agentsToKill) {
                    this.removeAgent(id);
                }
                Kernel.displayKernelMessage("Killed " + this.__agentsToKill.size() + " agent(s)");
                this.__agentsToKill.clear();
            }
            long ending_date = System.currentTimeMillis();
            this.__simulation_step_duration = ending_date - starting_date;
            ++this.__simulation_time;
            if (this.__waitingTime > 0) {
                this.__waitingTimeCountDown = ending_date + (long)this.__waitingTime;
            }
            this.fireKernelExternalRefreshAllowed();
        }
    }

    protected void runShutdownStage() {
        Kernel.displayKernelMessage("Shutdowning micro-kernel...");
        Kernel.displayKernelMessage("\tstoping agents...");
        this.__in_shutdowning = true;
        this.stopAgents(this.getRegisteredAgents());
        this.removeAllAgents();
        if (this.__environment != null) {
            Kernel.displayKernelMessage("\tshutdown environment...");
            this.__environment.shutdown();
        }
        Kernel.displayKernelMessage("\tstoping MTS...");
        ((MessageTransportService)this.__mts).stopMTS();
        this.__stopsimu = true;
        this.__simulation_time = 0L;
        this.__simulation_step_duration = 0L;
        Kernel.displayKernelMessage("\tshutdown complete.");
        this.__in_shutdowning = false;
        this.__is_shutdown = true;
        this.fireKernelStopped();
    }

    protected void startAgents(Collection<AT> agents) {
        assert (agents != null);
        for (Agent agent : agents) {
            AgentIdentifier id = this.__whitepages.getId(agent);
            if (id == null) continue;
            agent.start(id);
        }
    }

    public void setWaitingDuration(int duration) {
        if (duration >= 0) {
            this.__waitingTime = duration;
        }
    }

    protected void stopAgents(Collection<AT> agents) {
        assert (agents != null);
        for (Agent agent : agents) {
            agent.stop();
        }
    }

    public boolean isStopped() {
        return this.__stopsimu || this.__whitepages.size() == 0 || this.__is_shutdown || this.__in_shutdowning;
    }

    public boolean isUnderPause() {
        return this.__isUnderPause;
    }

    public boolean isShutdown() {
        return this.__is_shutdown || this.__in_shutdowning;
    }

    public void stop() {
        Kernel.displayKernelMessage("Requesting kernel shutdown");
        this.__stopsimu = true;
    }

    public static void stopKernel() {
        if (SINGLETON != null) {
            SINGLETON.stop();
        }
    }

    public void pause() {
        if (!this.__stopsimu) {
            if (!this.__isUnderPause) {
                Kernel.displayKernelMessage("Requesting kernel pause");
            }
            this.__isUnderPause = !this.__isUnderPause;
        }
    }

    public static void pauseKernel() {
        if (SINGLETON != null) {
            SINGLETON.pause();
        }
    }

    public static Probe probe(AgentIdentifier agentId) {
        assert (agentId != null);
        if (SINGLETON != null) {
            SINGLETON.getProbe(agentId);
        }
        return null;
    }

    public static AgentIdentifier[] service(String serviceName) {
        assert (serviceName != null && !"".equals(serviceName));
        if (SINGLETON != null) {
            return SINGLETON.getServiceProviders(serviceName);
        }
        return new AgentIdentifier[0];
    }

    public KernelIdentifier getKernelId() {
        return this.__kernel_id;
    }

    public YP getYellowPageSystem() {
        return this.__yellowpages;
    }

    public AgentIdentifier[] getServiceProviders(String serviceName) {
        assert (serviceName != null && !"".equals(serviceName));
        return ((YellowPages)this.__yellowpages).getAgents(serviceName);
    }

    public long getAgentCount() {
        return this.__whitepages.size();
    }

    public boolean isOnThisKernel(AgentIdentifier agent) {
        assert (agent != null);
        return this.getKernelId().equals(agent.getKernelId());
    }

    protected static void displayKernelMessage(String msg) {
        System.err.println("*** KERNEL *** > " + msg);
    }

    public long getKernelStep() {
        return this.__simulation_time;
    }

    public long getKernelStepDuration() {
        return this.__simulation_step_duration < 10L ? 10L : this.__simulation_step_duration;
    }

    public SimulationClock getSimulationClock() {
        SimulationClock sc = null;
        ET env = this.getEnvironment();
        if (env != null) {
            sc = env.getSimulationClock();
        }
        if (sc == null) {
            return new SimulationClock(){

                @Override
                public double getSimulationStepDuration(TimeUnit desired_unit) {
                    return desired_unit.convert(Kernel.this.getKernelStepDuration(), TimeUnit.MILLISECONDS);
                }

                @Override
                public double getSimulationStepDuration() {
                    return Kernel.this.getKernelStepDuration();
                }

                @Override
                public double getSimulationTime(TimeUnit desired_unit) {
                    return Kernel.this.getKernelStep();
                }

                @Override
                public double getSimulationTime() {
                    return Kernel.this.getKernelStep();
                }

                @Override
                public double perTimeUnit(double value) {
                    return this.perTimeUnit(value, TimeUnit.SECONDS);
                }

                @Override
                public double perTimeUnit(double value, TimeUnit desiredUnit) {
                    return value * this.getSimulationStepDuration(desiredUnit);
                }
            };
        }
        return sc;
    }

    public void addKernelListener(KernelListener listener) {
        assert (listener != null);
        this.__kernelListeners.add(listener);
    }

    public void removeKernelListener(KernelListener listener) {
        assert (listener != null);
        this.__kernelListeners.remove(listener);
    }

    private void fireKernelStarted() {
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelStarted(this);
        }
    }

    private void fireKernelStopped() {
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelStopped(this);
        }
    }

    private void fireKernelExternalRefreshAllowed() {
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelRefreshAllowed(this);
        }
    }

    private void fireKernelPaused() {
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelPaused(this);
        }
    }

    private void fireKernelRestarted() {
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelRestarted(this);
        }
    }

    private void fireAgentAdded(AgentIdentifier ... ids) {
        assert (ids != null);
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelAgentAdded(this, ids);
        }
    }

    private void fireAgentRemoved(AgentIdentifier ... ids) {
        assert (ids != null);
        for (KernelListener listener : this.__kernelListeners) {
            if (listener == null) continue;
            listener.kernelAgentRemoved(this, ids);
        }
    }

    public Probe getProbe(AgentIdentifier agentId) {
        assert (agentId != null);
        AT ag = this.__whitepages.getAgent(agentId);
        if (ag != null) {
            return ((Agent)ag).getProbe();
        }
        return null;
    }
}

