/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.tinyMAS.network;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.arakhne.tinyMAS.core.Kernel;
import org.arakhne.tinyMAS.core.KernelIdentifier;
import org.arakhne.tinyMAS.core.Message;
import org.arakhne.tinyMAS.core.MessageTransportService;
import org.arakhne.tinyMAS.core.YellowPages;
import org.arakhne.tinyMAS.network.KernelMessage;
import org.arakhne.tinyMAS.network.MTSBasedYellowPages;
import org.arakhne.tinyMAS.network.NetworkKernel;

@Deprecated
public class NetworkMessageTransportService
extends MessageTransportService {
    protected final List<KernelIdentifier> __other_kernels = new ArrayList<KernelIdentifier>();
    private final InetAddress __other_kernel_adr;
    private final int __other_kernel_port;
    protected final ServerSocket __server_socket;
    protected final ExecutorService __server_thread;
    protected volatile boolean __mts_presented = false;
    private Map<String, Socket> sockets = new TreeMap<String, Socket>();

    public NetworkMessageTransportService(int socket_port) {
        this(socket_port, null, 0);
    }

    public NetworkMessageTransportService(int socket_port, InetAddress other_kernel_adr, int other_kernel_port) {
        try {
            this.__server_socket = new ServerSocket(socket_port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ThreadFactory factory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, r instanceof ConnexionListener ? "MTS listener" : "MTS message parser");
                th.setDaemon(true);
                return th;
            }
        };
        this.__server_thread = Executors.newCachedThreadPool(factory);
        this.__other_kernel_adr = other_kernel_adr;
        this.__other_kernel_port = other_kernel_port;
    }

    @Override
    protected KernelIdentifier getKernelId() {
        return new KernelIdentifier(this.__server_socket.getLocalPort());
    }

    void broadcast(KernelMessage m) {
        assert (m != null);
        KernelIdentifier[] tab = new KernelIdentifier[this.__other_kernels.size()];
        this.__other_kernels.toArray(tab);
        for (int i = 0; i < tab.length; ++i) {
            this.send(tab[i], m);
        }
        tab = null;
    }

    boolean send(KernelIdentifier kernel, KernelMessage m) {
        assert (kernel != null);
        assert (m != null);
        return this.sendSocket(kernel.getKernelAddress().getAddress(), kernel.getKernelAddress().getPort(), m);
    }

    @Override
    public boolean send(Message m) {
        assert (m != null);
        KernelIdentifier target_kernel = m.TO.getKernelId();
        if (target_kernel.equals(Kernel.getSingleton().getKernelId())) {
            return super.send(m);
        }
        return this.sendSocket(target_kernel.getKernelAddress().getAddress(), target_kernel.getKernelAddress().getPort(), m);
    }

    protected boolean sendSocket(InetAddress adr, int port, Serializable m) {
        assert (adr != null);
        String socketId = adr.getHostAddress() + ":" + port;
        try {
            Socket socket = this.sockets.get(socketId);
            if (socket == null) {
                socket = new Socket(adr, port);
                socket.shutdownInput();
                this.sockets.put(socketId, socket);
            }
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeObject(m);
            oos.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sockets.remove(socketId);
            return false;
        }
    }

    @Override
    public void stopMTS() {
        this.__server_thread.shutdownNow();
        this.broadcast(new KernelMessage(KernelMessage.Type.KERNEL_DELETION, Kernel.getSingleton().getKernelId()));
        this.__other_kernels.clear();
    }

    @Override
    public void startMTS() {
        NetworkKernel.displayKernelMessage("\tMTS listening on port " + this.__server_socket.getLocalPort());
        this.__server_thread.submit(new ConnexionListener());
        if (this.__other_kernel_adr != null) {
            NetworkKernel.displayKernelMessage("\twaiting for the ack of the community");
            this.sendSocket(this.__other_kernel_adr, this.__other_kernel_port, new KernelMessage(KernelMessage.Type.KERNEL_PRESENTATION, Kernel.getSingleton().getKernelId()));
            while (!this.__mts_presented) {
                Thread.yield();
            }
        }
    }

    @Deprecated
    class RemoteKernelListener
    implements Runnable {
        private final Socket __client;

        public RemoteKernelListener(Socket client) {
            assert (client != null);
            this.__client = client;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ObjectInputStream oos;
                    Object obj;
                    if ((obj = (oos = new ObjectInputStream(this.__client.getInputStream())).readObject()) != null && obj instanceof Message) {
                        this.treatAgentMessage((Message)obj);
                        continue;
                    }
                    if (obj == null || !(obj instanceof KernelMessage)) continue;
                    this.treatKernelMessage((KernelMessage)obj);
                }
            }
            catch (Throwable _) {
                try {
                    this.__client.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
        }

        protected void treatAgentMessage(Message msg) {
            assert (msg != null);
            if (msg.TO.getKernelId().equals(Kernel.getSingleton().getKernelId())) {
                NetworkMessageTransportService.this.registerInLocalBoxes(msg);
            } else {
                NetworkKernel.displayKernelMessage("Ignoring network message from:" + msg.FROM.toString());
            }
        }

        protected void treatKernelMessage(KernelMessage msg) {
            assert (msg != null);
            switch (msg.TYPE) {
                case KERNEL_DELETION: {
                    NetworkKernel.displayKernelMessage("Shutdown of the kernel " + ((Object)msg.IDENTIFIER).toString());
                    NetworkMessageTransportService.this.__other_kernels.remove(msg.IDENTIFIER);
                    break;
                }
                case KERNEL_PRESENTATION: {
                    NetworkKernel.displayKernelMessage("Presentation of the kernel " + ((Object)msg.IDENTIFIER).toString());
                    KernelIdentifier ki = (KernelIdentifier)msg.IDENTIFIER;
                    NetworkMessageTransportService.this.__other_kernels.add(ki);
                    NetworkMessageTransportService.this.sendSocket(ki.getKernelAddress().getAddress(), ki.getKernelAddress().getPort(), new KernelMessage(KernelMessage.Type.KERNEL_PRESENTATION_ACK, Kernel.getSingleton().getKernelId()));
                    ((MTSBasedYellowPages)NetworkKernel.getSingleton().getYellowPageSystem()).onKernelMessage(msg);
                    break;
                }
                case KERNEL_PRESENTATION_ACK: {
                    NetworkKernel.displayKernelMessage("\tI'm beeing presented to the community");
                    NetworkMessageTransportService.this.__other_kernels.add((KernelIdentifier)msg.IDENTIFIER);
                    NetworkMessageTransportService.this.__mts_presented = true;
                    break;
                }
                default: {
                    try {
                        if (msg.TYPE == null || YellowPages.class.asSubclass(msg.TARGET) == null) break;
                        ((MTSBasedYellowPages)NetworkKernel.getSingleton().getYellowPageSystem()).onKernelMessage(msg);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Deprecated
    class ConnexionListener
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket client;
                        if ((client = NetworkMessageTransportService.this.__server_socket.accept()) == null) {
                            continue;
                        }
                        NetworkMessageTransportService.this.__server_thread.submit(new RemoteKernelListener(client));
                        client = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

