/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.tinyMAS.situatedEnvironment.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.arakhne.tinyMAS.core.AbstractEnvironment;
import org.arakhne.tinyMAS.core.Agent;
import org.arakhne.tinyMAS.core.AgentIdentifier;
import org.arakhne.tinyMAS.core.Identifier;
import org.arakhne.tinyMAS.core.Kernel;
import org.arakhne.tinyMAS.core.TimeManager;
import org.arakhne.tinyMAS.situatedEnvironment.agent.SituatedAgent;
import org.arakhne.tinyMAS.situatedEnvironment.body.AgentBody;
import org.arakhne.tinyMAS.situatedEnvironment.environment.SituatedEnvironment;
import org.arakhne.tinyMAS.situatedEnvironment.environment.SituatedObject;
import org.arakhne.tinyMAS.situatedEnvironment.influence.Influence;
import org.arakhne.tinyMAS.situatedEnvironment.perception.Perception;

@Deprecated
public abstract class AbstractSituatedEnvironment<AT extends SituatedAgent<AB, OB, PT, IT>, AB extends AgentBody<?, IT>, OB extends SituatedObject, PT extends Perception<?>, IT extends Influence>
extends AbstractEnvironment<AT>
implements SituatedEnvironment<AT, AB, OB, PT, IT> {
    private final Map<AgentIdentifier, AB> __agent_bodies = new WeakHashMap<AgentIdentifier, AB>();
    private final Map<Identifier, OB> __objects = new TreeMap<Identifier, OB>();
    private final List<IT> __influences = new ArrayList<IT>();

    public AbstractSituatedEnvironment(TimeManager time_manager) {
        super(time_manager);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.__agent_bodies.clear();
        this.__objects.clear();
    }

    @Override
    public void postAgentScheduling(Kernel<AT, ?, ?, ?> runningKernel) {
        this.applyInfluences(this.__influences);
        this.__influences.clear();
        super.postAgentScheduling(runningKernel);
    }

    @Override
    public void putAgent(AT agent) {
        assert (agent != null);
        AgentIdentifier id = ((Agent)agent).getId();
        Object body = ((SituatedAgent)agent).createDefaultBody(this);
        if (body != null) {
            this.__agent_bodies.put(id, body);
            this.onAgentBodyAdded(body);
        }
    }

    protected abstract void onAgentBodyAdded(AB var1);

    protected abstract void onAgentBodyRemoved(AB var1);

    @Override
    public void removeAgent(AgentIdentifier agent) {
        assert (agent != null);
        AgentBody body = (AgentBody)this.__agent_bodies.get(agent);
        if (body != null) {
            this.__agent_bodies.remove(agent);
            this.onAgentBodyRemoved(body);
        }
    }

    @Override
    public Collection<AB> getAllAgentBodies() {
        ArrayList<AB> list = new ArrayList<AB>();
        list.addAll(this.__agent_bodies.values());
        return list;
    }

    @Override
    public <T extends AB> T getAgentBody(AgentIdentifier agent) {
        assert (agent != null);
        return (T)((AgentBody)this.__agent_bodies.get(agent));
    }

    @Override
    public OB getObjectBody(Identifier object) {
        assert (object != null);
        return (OB)((SituatedObject)this.__objects.get(object));
    }

    protected abstract boolean applyInfluences(Collection<IT> var1);

    @Override
    public final boolean influence(IT ... influences) {
        assert (influences != null && influences.length > 0);
        return this.__influences.addAll(Arrays.asList(influences));
    }
}

