/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jme;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.IoLib;
import org.luaj.vm2.lib.jme.JmeBaseLib;

public class JmeIoLib
extends IoLib {
    protected IoLib.File wrapStdin() throws IOException {
        return new FileImpl(JmeBaseLib.stdin((LuaValue)this));
    }

    protected IoLib.File wrapStdout() throws IOException {
        return new FileImpl(JmeBaseLib.stdout((LuaValue)this));
    }

    protected IoLib.File openFile(String filename, boolean readMode, boolean appendMode, boolean updateMode, boolean binaryMode) throws IOException {
        String url = "file:///" + filename;
        int mode = readMode ? 1 : 3;
        StreamConnection conn = (StreamConnection)Connector.open((String)url, (int)mode);
        FileImpl f = readMode ? new FileImpl(conn, conn.openInputStream(), null) : new FileImpl(conn, conn.openInputStream(), conn.openOutputStream());
        return f;
    }

    private static void notimplemented() throws IOException {
        throw new IOException("not implemented");
    }

    protected IoLib.File openProgram(String prog, String mode) throws IOException {
        JmeIoLib.notimplemented();
        return null;
    }

    protected IoLib.File tmpFile() throws IOException {
        JmeIoLib.notimplemented();
        return null;
    }

    private final class FileImpl
    extends IoLib.File {
        private final StreamConnection conn;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed;
        private boolean nobuffer;
        private int lookahead;

        private FileImpl(StreamConnection conn, InputStream is, OutputStream os) {
            super((IoLib)JmeIoLib.this);
            this.closed = false;
            this.nobuffer = false;
            this.lookahead = -1;
            this.conn = conn;
            this.is = is;
            this.os = os;
        }

        private FileImpl(InputStream i) {
            this(null, i, null);
        }

        private FileImpl(OutputStream o) {
            this(null, null, o);
        }

        public String tojstring() {
            return "file (" + ((Object)((Object)this)).hashCode() + ")";
        }

        public boolean isstdfile() {
            return this.conn == null;
        }

        public void close() throws IOException {
            this.closed = true;
            if (this.conn != null) {
                this.conn.close();
            }
        }

        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        public void write(LuaString s) throws IOException {
            if (this.os != null) {
                this.os.write(s.m_bytes, s.m_offset, s.m_length);
            } else {
                JmeIoLib.notimplemented();
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        public boolean isclosed() {
            return this.closed;
        }

        public int seek(String option, int pos) throws IOException {
            JmeIoLib.notimplemented();
            return 0;
        }

        public void setvbuf(String mode, int size) {
            this.nobuffer = "no".equals(mode);
        }

        public int remaining() throws IOException {
            return -1;
        }

        public int peek() throws IOException {
            if (this.lookahead < 0) {
                this.lookahead = this.is.read();
            }
            return this.lookahead;
        }

        public int read() throws IOException {
            if (this.lookahead >= 0) {
                int c = this.lookahead;
                this.lookahead = -1;
                return c;
            }
            if (this.is != null) {
                return this.is.read();
            }
            JmeIoLib.notimplemented();
            return 0;
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            int i = 0;
            if (this.is != null) {
                if (length > 0 && this.lookahead >= 0) {
                    bytes[offset] = (byte)this.lookahead;
                    this.lookahead = -1;
                    ++i;
                }
                while (i < length) {
                    int n = this.is.read(bytes, offset + i, length - i);
                    if (n < 0) {
                        return i > 0 ? i : -1;
                    }
                    i += n;
                }
            } else {
                JmeIoLib.notimplemented();
            }
            return length;
        }
    }
}

